/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.MultiBackgroundInitializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiBackgroundInitializerTest {
    private static final String CHILD_INIT = "childInitializer";
    private MultiBackgroundInitializer initializer;

    @Before
    public void setUp() throws Exception {
        this.initializer = new MultiBackgroundInitializer();
    }

    private void checkChild(BackgroundInitializer<?> child, ExecutorService expExec) throws ConcurrentException {
        ChildBackgroundInitializer cinit = (ChildBackgroundInitializer)child;
        Integer result = (Integer)cinit.get();
        Assert.assertEquals((String)"Wrong result", (long)1L, (long)result.intValue());
        Assert.assertEquals((String)"Wrong number of executions", (long)1L, (long)cinit.initializeCalls);
        if (expExec != null) {
            Assert.assertEquals((String)"Wrong executor service", (Object)expExec, (Object)cinit.currentExecutor);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInitializerNullName() {
        this.initializer.addInitializer(null, (BackgroundInitializer)new ChildBackgroundInitializer());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddInitializerNullInit() {
        this.initializer.addInitializer(CHILD_INIT, null);
    }

    @Test
    public void testInitializeNoChildren() throws ConcurrentException {
        Assert.assertTrue((String)"Wrong result of start()", (boolean)this.initializer.start());
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assert.assertTrue((String)"Got child initializers", (boolean)res.initializerNames().isEmpty());
        Assert.assertTrue((String)"Executor not shutdown", (boolean)this.initializer.getActiveExecutor().isShutdown());
    }

    private MultiBackgroundInitializer.MultiBackgroundInitializerResults checkInitialize() throws ConcurrentException {
        int count = 5;
        for (int i = 0; i < 5; ++i) {
            this.initializer.addInitializer(CHILD_INIT + i, (BackgroundInitializer)new ChildBackgroundInitializer());
        }
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assert.assertEquals((String)"Wrong number of child initializers", (long)5L, (long)res.initializerNames().size());
        for (int i = 0; i < 5; ++i) {
            String key = CHILD_INIT + i;
            Assert.assertTrue((String)("Name not found: " + key), (boolean)res.initializerNames().contains(key));
            Assert.assertEquals((String)"Wrong result object", (Object)1, (Object)res.getResultObject(key));
            Assert.assertFalse((String)"Exception flag", (boolean)res.isException(key));
            Assert.assertNull((String)"Got an exception", (Object)((Object)res.getException(key)));
            this.checkChild(res.getInitializer(key), this.initializer.getActiveExecutor());
        }
        return res;
    }

    @Test
    public void testInitializeTempExec() throws ConcurrentException {
        this.checkInitialize();
        Assert.assertTrue((String)"Executor not shutdown", (boolean)this.initializer.getActiveExecutor().isShutdown());
    }

    @Test
    public void testInitializeExternalExec() throws ConcurrentException, InterruptedException {
        ExecutorService exec = Executors.newCachedThreadPool();
        try {
            this.initializer = new MultiBackgroundInitializer(exec);
            this.checkInitialize();
            Assert.assertEquals((String)"Wrong executor", (Object)exec, (Object)this.initializer.getActiveExecutor());
            Assert.assertFalse((String)"Executor was shutdown", (boolean)exec.isShutdown());
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitializeChildWithExecutor() throws ConcurrentException, InterruptedException {
        String initExec = "childInitializerWithExecutor";
        ExecutorService exec = Executors.newSingleThreadExecutor();
        try {
            ChildBackgroundInitializer c1 = new ChildBackgroundInitializer();
            ChildBackgroundInitializer c2 = new ChildBackgroundInitializer();
            c2.setExternalExecutor(exec);
            this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)c1);
            this.initializer.addInitializer("childInitializerWithExecutor", (BackgroundInitializer)c2);
            this.initializer.start();
            this.initializer.get();
            this.checkChild(c1, this.initializer.getActiveExecutor());
            this.checkChild(c2, exec);
        }
        finally {
            exec.shutdown();
            exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testAddInitializerAfterStart() throws ConcurrentException {
        this.initializer.start();
        try {
            this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)new ChildBackgroundInitializer());
            Assert.fail((String)"Could add initializer after start()!");
        }
        catch (IllegalStateException istex) {
            this.initializer.get();
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testResultGetInitializerUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        res.getInitializer("unknown");
    }

    @Test(expected=NoSuchElementException.class)
    public void testResultGetResultObjectUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        res.getResultObject("unknown");
    }

    @Test(expected=NoSuchElementException.class)
    public void testResultGetExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        res.getException("unknown");
    }

    @Test(expected=NoSuchElementException.class)
    public void testResultIsExceptionUnknown() throws ConcurrentException {
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = this.checkInitialize();
        res.isException("unknown");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testResultInitializerNamesModify() throws ConcurrentException {
        this.checkInitialize();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Iterator it = res.initializerNames().iterator();
        it.next();
        it.remove();
    }

    @Test
    public void testInitializeRuntimeEx() {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new RuntimeException();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        try {
            this.initializer.get();
            Assert.fail((String)"Runtime exception not thrown!");
        }
        catch (Exception ex) {
            Assert.assertEquals((String)"Wrong exception", (Object)child.ex, (Object)ex);
        }
    }

    @Test
    public void testInitializeEx() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assert.assertTrue((String)"No exception flag", (boolean)res.isException(CHILD_INIT));
        Assert.assertNull((String)"Got a results object", (Object)res.getResultObject(CHILD_INIT));
        ConcurrentException cex = res.getException(CHILD_INIT);
        Assert.assertEquals((String)"Wrong cause", (Object)child.ex, (Object)cex.getCause());
    }

    @Test
    public void testInitializeResultsIsSuccessfulTrue() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assert.assertTrue((String)"Wrong success flag", (boolean)res.isSuccessful());
    }

    @Test
    public void testInitializeResultsIsSuccessfulFalse() throws ConcurrentException {
        ChildBackgroundInitializer child = new ChildBackgroundInitializer();
        child.ex = new Exception();
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)child);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        Assert.assertFalse((String)"Wrong success flag", (boolean)res.isSuccessful());
    }

    @Test
    public void testInitializeNested() throws ConcurrentException {
        String nameMulti = "multiChildInitializer";
        this.initializer.addInitializer(CHILD_INIT, (BackgroundInitializer)new ChildBackgroundInitializer());
        MultiBackgroundInitializer mi2 = new MultiBackgroundInitializer();
        int count = 3;
        for (int i = 0; i < 3; ++i) {
            mi2.addInitializer(CHILD_INIT + i, (BackgroundInitializer)new ChildBackgroundInitializer());
        }
        this.initializer.addInitializer("multiChildInitializer", (BackgroundInitializer)mi2);
        this.initializer.start();
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)this.initializer.get();
        ExecutorService exec = this.initializer.getActiveExecutor();
        this.checkChild(res.getInitializer(CHILD_INIT), exec);
        MultiBackgroundInitializer.MultiBackgroundInitializerResults res2 = (MultiBackgroundInitializer.MultiBackgroundInitializerResults)res.getResultObject("multiChildInitializer");
        Assert.assertEquals((String)"Wrong number of initializers", (long)3L, (long)res2.initializerNames().size());
        for (int i = 0; i < 3; ++i) {
            this.checkChild(res2.getInitializer(CHILD_INIT + i), exec);
        }
        Assert.assertTrue((String)"Executor not shutdown", (boolean)exec.isShutdown());
    }

    private static class ChildBackgroundInitializer
    extends BackgroundInitializer<Integer> {
        volatile ExecutorService currentExecutor;
        volatile int initializeCalls;
        Exception ex;

        private ChildBackgroundInitializer() {
        }

        protected Integer initialize() throws Exception {
            this.currentExecutor = this.getActiveExecutor();
            ++this.initializeCalls;
            if (this.ex != null) {
                throw this.ex;
            }
            return this.initializeCalls;
        }
    }
}

