/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractExceptionContextTest<T extends ExceptionContext & Serializable> {
    protected static final String TEST_MESSAGE_2 = "This is monotonous";
    protected static final String TEST_MESSAGE = "Test Message";
    protected T exceptionContext;

    @Before
    public void setUp() throws Exception {
        this.exceptionContext.addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new ObjectWithFaultyToString());
    }

    @Test
    public void testAddContextValue() {
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        Assert.assertTrue((message.indexOf(TEST_MESSAGE) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("test1") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("test2") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("test Date") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("test Nbr") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("some value") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("5") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.exceptionContext.getFirstContextValue("test1") == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("some value"));
        Assert.assertEquals((long)5L, (long)this.exceptionContext.getContextLabels().size());
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test1"));
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Date"));
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Nbr"));
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assert.assertEquals((long)5L, (long)this.exceptionContext.getContextLabels().size());
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test2"));
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        Assert.assertTrue((contextMessage.indexOf(TEST_MESSAGE) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testSetContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        this.exceptionContext.setContextValue("test3", (Object)"3");
        String message = this.exceptionContext.getFormattedExceptionMessage(TEST_MESSAGE);
        Assert.assertTrue((message.indexOf(TEST_MESSAGE) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("test Poorly written obj") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((message.indexOf("Crap") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.exceptionContext.getFirstContextValue("crap") == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(this.exceptionContext.getFirstContextValue("test Poorly written obj") instanceof ObjectWithFaultyToString));
        Assert.assertEquals((long)7L, (long)this.exceptionContext.getContextEntries().size());
        Assert.assertEquals((long)6L, (long)this.exceptionContext.getContextLabels().size());
        Assert.assertTrue((boolean)this.exceptionContext.getContextLabels().contains("test Poorly written obj"));
        Assert.assertTrue((!this.exceptionContext.getContextLabels().contains("crap") ? 1 : 0) != 0);
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"replacement");
        Assert.assertEquals((long)7L, (long)this.exceptionContext.getContextEntries().size());
        Assert.assertEquals((long)6L, (long)this.exceptionContext.getContextLabels().size());
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assert.assertEquals((long)6L, (long)this.exceptionContext.getContextEntries().size());
        Assert.assertEquals((long)6L, (long)this.exceptionContext.getContextLabels().size());
        String contextMessage = this.exceptionContext.getFormattedExceptionMessage(null);
        Assert.assertTrue((contextMessage.indexOf(TEST_MESSAGE) == -1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetFirstContextValue() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assert.assertTrue((this.exceptionContext.getFirstContextValue("test1") == null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("some value"));
        Assert.assertTrue((this.exceptionContext.getFirstContextValue("crap") == null ? 1 : 0) != 0);
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assert.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("another"));
    }

    @Test
    public void testGetContextValues() {
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Assert.assertEquals((Object)this.exceptionContext.getContextValues("test1"), Collections.singletonList(null));
        Assert.assertEquals((Object)this.exceptionContext.getContextValues("test2"), Arrays.asList("some value", "different value"));
        this.exceptionContext.setContextValue("test2", (Object)"another");
        Assert.assertTrue((boolean)this.exceptionContext.getFirstContextValue("test2").equals("another"));
    }

    @Test
    public void testGetContextLabels() {
        Assert.assertEquals((long)5L, (long)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        Set labels = this.exceptionContext.getContextLabels();
        Assert.assertEquals((long)6L, (long)this.exceptionContext.getContextEntries().size());
        Assert.assertEquals((long)5L, (long)labels.size());
        Assert.assertTrue((boolean)labels.contains("test1"));
        Assert.assertTrue((boolean)labels.contains("test2"));
        Assert.assertTrue((boolean)labels.contains("test Date"));
        Assert.assertTrue((boolean)labels.contains("test Nbr"));
    }

    @Test
    public void testGetContextEntries() {
        Assert.assertEquals((long)5L, (long)this.exceptionContext.getContextEntries().size());
        this.exceptionContext.addContextValue("test2", (Object)"different value");
        List entries = this.exceptionContext.getContextEntries();
        Assert.assertEquals((long)6L, (long)entries.size());
        Assert.assertEquals((Object)"test1", (Object)((Pair)entries.get(0)).getKey());
        Assert.assertEquals((Object)"test2", (Object)((Pair)entries.get(1)).getKey());
        Assert.assertEquals((Object)"test Date", (Object)((Pair)entries.get(2)).getKey());
        Assert.assertEquals((Object)"test Nbr", (Object)((Pair)entries.get(3)).getKey());
        Assert.assertEquals((Object)"test Poorly written obj", (Object)((Pair)entries.get(4)).getKey());
        Assert.assertEquals((Object)"test2", (Object)((Pair)entries.get(5)).getKey());
    }

    @Test
    public void testJavaSerialization() {
        this.exceptionContext.setContextValue("test Poorly written obj", (Object)"serializable replacement");
        ExceptionContext clone = (ExceptionContext)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)this.exceptionContext)));
        Assert.assertEquals((Object)this.exceptionContext.getFormattedExceptionMessage(null), (Object)clone.getFormattedExceptionMessage(null));
    }

    protected static class ObjectWithFaultyToString {
        protected ObjectWithFaultyToString() {
        }

        public String toString() {
            throw new RuntimeException("Crap");
        }
    }
}

