/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.reflect;

import org.apache.commons.lang3.reflect.InheritanceUtils;
import org.apache.commons.lang3.reflect.testbed.AnotherChild;
import org.apache.commons.lang3.reflect.testbed.AnotherParent;
import org.apache.commons.lang3.reflect.testbed.Grandchild;
import org.junit.Assert;
import org.junit.Test;

public class InheritanceUtilsTest {
    @Test
    public void testConstructor() throws Exception {
        Assert.assertNotNull(InheritanceUtils.class.newInstance());
    }

    @Test
    public void testDistanceGreaterThanZero() {
        Assert.assertEquals((long)1L, (long)InheritanceUtils.distance(AnotherChild.class, AnotherParent.class));
        Assert.assertEquals((long)1L, (long)InheritanceUtils.distance(Grandchild.class, AnotherChild.class));
        Assert.assertEquals((long)2L, (long)InheritanceUtils.distance(Grandchild.class, AnotherParent.class));
        Assert.assertEquals((long)3L, (long)InheritanceUtils.distance(Grandchild.class, Object.class));
    }

    @Test
    public void testDistanceEqual() {
        Assert.assertEquals((long)0L, (long)InheritanceUtils.distance(AnotherChild.class, AnotherChild.class));
    }

    @Test
    public void testDistanceEqualObject() {
        Assert.assertEquals((long)0L, (long)InheritanceUtils.distance(Object.class, Object.class));
    }

    @Test
    public void testDistanceNullChild() {
        Assert.assertEquals((long)-1L, (long)InheritanceUtils.distance(null, Object.class));
    }

    @Test
    public void testDistanceNullParent() {
        Assert.assertEquals((long)-1L, (long)InheritanceUtils.distance(Object.class, null));
    }

    @Test
    public void testDistanceNullParentNullChild() {
        Assert.assertEquals((long)-1L, (long)InheritanceUtils.distance(null, null));
    }

    @Test
    public void testDistanceDisjoint() {
        Assert.assertEquals((long)-1L, (long)InheritanceUtils.distance(Boolean.class, String.class));
    }

    @Test
    public void testDistanceReverseParentChild() {
        Assert.assertEquals((long)-1L, (long)InheritanceUtils.distance(Object.class, Grandchild.class));
    }
}

