/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.apache.commons.lang3.time.DatePrinter;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.apache.commons.lang3.time.FormatCache;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class FastDatePrinterTest {
    private static final String YYYY_MM_DD = "yyyy/MM/dd";
    private static final TimeZone NEW_YORK = TimeZone.getTimeZone("America/New_York");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final TimeZone INDIA = TimeZone.getTimeZone("Asia/Calcutta");
    private static final Locale SWEDEN = new Locale("sv", "SE");
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();

    DatePrinter getInstance(String format) {
        return this.getInstance(format, TimeZone.getDefault(), Locale.getDefault());
    }

    private DatePrinter getDateInstance(int dateStyle, Locale locale) {
        return this.getInstance(FormatCache.getPatternForStyle((Integer)dateStyle, null, (Locale)locale), TimeZone.getDefault(), Locale.getDefault());
    }

    private DatePrinter getInstance(String format, Locale locale) {
        return this.getInstance(format, TimeZone.getDefault(), locale);
    }

    private DatePrinter getInstance(String format, TimeZone timeZone) {
        return this.getInstance(format, timeZone, Locale.getDefault());
    }

    protected DatePrinter getInstance(String format, TimeZone timeZone, Locale locale) {
        return new FastDatePrinter(format, timeZone, locale);
    }

    @SystemDefaults(timezone="America/New_York", locale="en_US")
    @Test
    public void testFormat() {
        GregorianCalendar cal1 = new GregorianCalendar(2003, 0, 10, 15, 33, 20);
        GregorianCalendar cal2 = new GregorianCalendar(2003, 6, 10, 9, 0, 0);
        Date date1 = cal1.getTime();
        Date date2 = cal2.getTime();
        long millis1 = date1.getTime();
        long millis2 = date2.getTime();
        DatePrinter fdf = this.getInstance("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Assert.assertEquals((Object)sdf.format(date1), (Object)fdf.format(date1));
        Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format(date1));
        Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format((Calendar)cal1));
        Assert.assertEquals((Object)"2003-01-10T15:33:20", (Object)fdf.format(millis1));
        Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format(date2));
        Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format((Calendar)cal2));
        Assert.assertEquals((Object)"2003-07-10T09:00:00", (Object)fdf.format(millis2));
        fdf = this.getInstance("Z");
        Assert.assertEquals((Object)"-0500", (Object)fdf.format(date1));
        Assert.assertEquals((Object)"-0500", (Object)fdf.format((Calendar)cal1));
        Assert.assertEquals((Object)"-0500", (Object)fdf.format(millis1));
        Assert.assertEquals((Object)"-0400", (Object)fdf.format(date2));
        Assert.assertEquals((Object)"-0400", (Object)fdf.format((Calendar)cal2));
        Assert.assertEquals((Object)"-0400", (Object)fdf.format(millis2));
        fdf = this.getInstance("ZZ");
        Assert.assertEquals((Object)"-05:00", (Object)fdf.format(date1));
        Assert.assertEquals((Object)"-05:00", (Object)fdf.format((Calendar)cal1));
        Assert.assertEquals((Object)"-05:00", (Object)fdf.format(millis1));
        Assert.assertEquals((Object)"-04:00", (Object)fdf.format(date2));
        Assert.assertEquals((Object)"-04:00", (Object)fdf.format((Calendar)cal2));
        Assert.assertEquals((Object)"-04:00", (Object)fdf.format(millis2));
        String pattern = "GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z";
        fdf = this.getInstance("GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z");
        sdf = new SimpleDateFormat("GGGG GGG GG G yyyy yyy yy y MMMM MMM MM M dddd ddd dd d DDDD DDD DD D EEEE EEE EE E aaaa aaa aa a zzzz zzz zz z");
        Assert.assertEquals((Object)sdf.format(date1).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (Object)fdf.format(date1));
        Assert.assertEquals((Object)sdf.format(date2).replaceAll("2003 03 03 03", "2003 2003 03 2003"), (Object)fdf.format(date2));
    }

    @Test
    public void testShortDateStyleWithLocales() {
        Locale usLocale = Locale.US;
        Locale swedishLocale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 1, 3);
        DatePrinter fdf = this.getDateInstance(3, usLocale);
        Assert.assertEquals((Object)"2/3/04", (Object)fdf.format(cal));
        fdf = this.getDateInstance(3, swedishLocale);
        Assert.assertEquals((Object)"2004-02-03", (Object)fdf.format(cal));
    }

    @Test
    public void testLowYearPadding() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        cal.set(1, 0, 1);
        Assert.assertEquals((Object)"0001/01/01", (Object)format.format(cal));
        cal.set(10, 0, 1);
        Assert.assertEquals((Object)"0010/01/01", (Object)format.format(cal));
        cal.set(100, 0, 1);
        Assert.assertEquals((Object)"0100/01/01", (Object)format.format(cal));
        cal.set(999, 0, 1);
        Assert.assertEquals((Object)"0999/01/01", (Object)format.format(cal));
    }

    @Test
    public void testMilleniumBug() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance("dd.MM.yyyy");
        cal.set(1000, 0, 1);
        Assert.assertEquals((Object)"01.01.1000", (Object)format.format(cal));
    }

    @Test
    public void testSimpleDate() {
        Calendar cal = Calendar.getInstance();
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        cal.set(2004, 11, 31);
        Assert.assertEquals((Object)"2004/12/31", (Object)format.format(cal));
        cal.set(999, 11, 31);
        Assert.assertEquals((Object)"0999/12/31", (Object)format.format(cal));
        cal.set(1, 2, 2);
        Assert.assertEquals((Object)"0001/03/02", (Object)format.format(cal));
    }

    @Test
    public void testLang303() {
        Calendar cal = Calendar.getInstance();
        cal.set(2004, 11, 31);
        DatePrinter format = this.getInstance(YYYY_MM_DD);
        String output = format.format(cal);
        format = (DatePrinter)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Serializable)((Serializable)format)));
        Assert.assertEquals((Object)output, (Object)format.format(cal));
    }

    @Test
    public void testLang538() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT-8"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        DatePrinter format = this.getInstance("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", TimeZone.getTimeZone("GMT"));
        Assert.assertEquals((String)"dateTime", (Object)"2009-10-16T16:42:16.000Z", (Object)format.format(cal.getTime()));
        Assert.assertEquals((String)"dateTime", (Object)"2009-10-16T16:42:16.000Z", (Object)format.format((Calendar)cal));
    }

    @Test
    public void testLang645() {
        Locale locale = new Locale("sv", "SE");
        Calendar cal = Calendar.getInstance();
        cal.set(2010, 0, 1, 12, 0, 0);
        Date d = cal.getTime();
        DatePrinter fdf = this.getInstance("EEEE', week 'ww", locale);
        Assert.assertEquals((Object)"fredag, week 53", (Object)fdf.format(d));
    }

    @Test
    public void testEquals() {
        DatePrinter printer1 = this.getInstance(YYYY_MM_DD);
        DatePrinter printer2 = this.getInstance(YYYY_MM_DD);
        Assert.assertEquals((Object)printer1, (Object)printer2);
        Assert.assertEquals((long)printer1.hashCode(), (long)printer2.hashCode());
        Assert.assertFalse((boolean)printer1.equals(new Object()));
    }

    @Test
    public void testToStringContainsName() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD);
        Assert.assertTrue((boolean)printer.toString().startsWith("FastDate"));
    }

    @Test
    public void testPatternMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD);
        Assert.assertEquals((Object)YYYY_MM_DD, (Object)printer.getPattern());
    }

    @Test
    public void testLocaleMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD, SWEDEN);
        Assert.assertEquals((Object)SWEDEN, (Object)printer.getLocale());
    }

    @Test
    public void testTimeZoneMatches() {
        DatePrinter printer = this.getInstance(YYYY_MM_DD, NEW_YORK);
        Assert.assertEquals((Object)NEW_YORK, (Object)printer.getTimeZone());
    }

    @SystemDefaults(timezone="UTC")
    @Test
    public void testTimeZoneAsZ() throws Exception {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        FastDateFormat noColonFormat = FastDateFormat.getInstance((String)"Z");
        Assert.assertEquals((Object)"+0000", (Object)noColonFormat.format(c));
        FastDateFormat isoFormat = FastDateFormat.getInstance((String)"ZZ");
        Assert.assertEquals((Object)"Z", (Object)isoFormat.format(c));
        FastDateFormat colonFormat = FastDateFormat.getInstance((String)"ZZZ");
        Assert.assertEquals((Object)"+00:00", (Object)colonFormat.format(c));
    }

    private static Calendar initializeCalendar(TimeZone tz) {
        Calendar cal = Calendar.getInstance(tz);
        cal.set(1, 2001);
        cal.set(2, 1);
        cal.set(5, 4);
        cal.set(11, 12);
        cal.set(12, 8);
        cal.set(13, 56);
        cal.set(14, 235);
        return cal;
    }

    @Test(expected=IllegalArgumentException.class)
    public void test1806Argument() {
        this.getInstance("XXXX");
    }

    @Test
    public void test1806() throws ParseException {
        for (Expected1806 trial : Expected1806.values()) {
            Calendar cal = FastDatePrinterTest.initializeCalendar(trial.zone);
            DatePrinter printer = this.getInstance("X", trial.zone);
            Assert.assertEquals((Object)trial.one, (Object)printer.format(cal));
            printer = this.getInstance("XX", trial.zone);
            Assert.assertEquals((Object)trial.two, (Object)printer.format(cal));
            printer = this.getInstance("XXX", trial.zone);
            Assert.assertEquals((Object)trial.three, (Object)printer.format(cal));
        }
    }

    @Test
    public void testLang1103() throws ParseException {
        Calendar cal = Calendar.getInstance(SWEDEN);
        cal.set(5, 2);
        Assert.assertEquals((Object)"2", (Object)this.getInstance("d", SWEDEN).format(cal));
        Assert.assertEquals((Object)"02", (Object)this.getInstance("dd", SWEDEN).format(cal));
        Assert.assertEquals((Object)"002", (Object)this.getInstance("ddd", SWEDEN).format(cal));
        Assert.assertEquals((Object)"0002", (Object)this.getInstance("dddd", SWEDEN).format(cal));
        Assert.assertEquals((Object)"00002", (Object)this.getInstance("ddddd", SWEDEN).format(cal));
    }

    @Test
    public void testLang916() throws Exception {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("Europe/Paris"));
        cal.clear();
        cal.set(2009, 9, 16, 8, 42, 16);
        String value = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("Europe/Paris")).format(cal);
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T08:42:16 +0200", (Object)value);
        value = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("Asia/Kolkata")).format(cal);
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T12:12:16 +0530", (Object)value);
        value = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss Z", (TimeZone)TimeZone.getTimeZone("Europe/London")).format(cal);
        Assert.assertEquals((String)"calendar", (Object)"2009-10-16T07:42:16 +0100", (Object)value);
    }

    @Test
    public void testHourFormats() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        DatePrinter printer = this.getInstance("K k H h");
        calendar.set(11, 0);
        Assert.assertEquals((Object)"0 24 0 12", (Object)printer.format(calendar));
        calendar.set(11, 12);
        Assert.assertEquals((Object)"0 12 12 12", (Object)printer.format(calendar));
        calendar.set(11, 23);
        Assert.assertEquals((Object)"11 23 23 11", (Object)printer.format(calendar));
    }

    @Test
    public void testStringBufferOptions() {
        DatePrinter format = this.getInstance("yyyy-MM-dd HH:mm:ss.SSS Z", TimeZone.getTimeZone("GMT"));
        Calendar calendar = Calendar.getInstance();
        StringBuffer sb = new StringBuffer();
        String expected = format.format((Object)calendar, sb, new FieldPosition(0)).toString();
        sb.setLength(0);
        Assert.assertEquals((Object)expected, (Object)format.format(calendar, sb).toString());
        sb.setLength(0);
        Date date = calendar.getTime();
        Assert.assertEquals((Object)expected, (Object)format.format((Object)date, sb, new FieldPosition(0)).toString());
        sb.setLength(0);
        Assert.assertEquals((Object)expected, (Object)format.format(date, sb).toString());
        sb.setLength(0);
        long epoch = date.getTime();
        Assert.assertEquals((Object)expected, (Object)format.format((Object)epoch, sb, new FieldPosition(0)).toString());
        sb.setLength(0);
        Assert.assertEquals((Object)expected, (Object)format.format(epoch, sb).toString());
    }

    @Test
    public void testAppendableOptions() {
        DatePrinter format = this.getInstance("yyyy-MM-dd HH:mm:ss.SSS Z", TimeZone.getTimeZone("GMT"));
        Calendar calendar = Calendar.getInstance();
        StringBuilder sb = new StringBuilder();
        String expected = ((StringBuilder)format.format(calendar, (Appendable)sb)).toString();
        sb.setLength(0);
        Date date = calendar.getTime();
        Assert.assertEquals((Object)expected, (Object)((StringBuilder)format.format(date, (Appendable)sb)).toString());
        sb.setLength(0);
        long epoch = date.getTime();
        Assert.assertEquals((Object)expected, (Object)((StringBuilder)format.format(epoch, (Appendable)sb)).toString());
    }

    @Test
    public void testDayNumberOfWeek() {
        DatePrinter printer = this.getInstance("u");
        Calendar calendar = Calendar.getInstance();
        calendar.set(7, 2);
        Assert.assertEquals((Object)"1", (Object)printer.format(calendar.getTime()));
        calendar.set(7, 7);
        Assert.assertEquals((Object)"6", (Object)printer.format(calendar.getTime()));
        calendar.set(7, 1);
        Assert.assertEquals((Object)"7", (Object)printer.format(calendar.getTime()));
    }

    static /* synthetic */ TimeZone access$000() {
        return INDIA;
    }

    static /* synthetic */ TimeZone access$100() {
        return GMT;
    }

    static /* synthetic */ TimeZone access$200() {
        return NEW_YORK;
    }

    private static enum Expected1806 {
        India(FastDatePrinterTest.access$000(), "+05", "+0530", "+05:30"),
        Greenwich(FastDatePrinterTest.access$100(), "Z", "Z", "Z"),
        NewYork(FastDatePrinterTest.access$200(), "-05", "-0500", "-05:00");

        final TimeZone zone;
        final String one;
        final String two;
        final String three;

        private Expected1806(TimeZone zone, String one, String two, String three) {
            this.zone = zone;
            this.one = one;
            this.two = two;
            this.three = three;
        }
    }
}

