/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDatePrinter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WeekYearTest {
    final Calendar vulgar;
    final String isoForm;

    @Parameterized.Parameters(name="{index}: {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList({2005, 0, 1, "2004-W53-6"}, {2005, 0, 2, "2004-W53-7"}, {2005, 11, 31, "2005-W52-6"}, {2007, 0, 1, "2007-W01-1"}, {2007, 11, 30, "2007-W52-7"}, {2007, 11, 31, "2008-W01-1"}, {2008, 0, 1, "2008-W01-2"}, {2008, 11, 28, "2008-W52-7"}, {2008, 11, 29, "2009-W01-1"}, {2008, 11, 30, "2009-W01-2"}, {2008, 11, 31, "2009-W01-3"}, {2009, 0, 1, "2009-W01-4"}, {2009, 11, 31, "2009-W53-4"}, {2010, 0, 1, "2009-W53-5"}, {2010, 0, 2, "2009-W53-6"}, {2010, 0, 3, "2009-W53-7"});
    }

    public WeekYearTest(int year, int month, int day, String isoForm) {
        this.vulgar = new GregorianCalendar(year, month, day);
        this.isoForm = isoForm;
    }

    @Test
    public void testParser() throws ParseException {
        FastDateParser parser = new FastDateParser("YYYY-'W'ww-u", TimeZone.getDefault(), Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        cal.clear();
        parser.parse(this.isoForm, new ParsePosition(0), cal);
        Assert.assertEquals((Object)this.vulgar.getTime(), (Object)cal.getTime());
    }

    @Test
    public void testPrinter() {
        FastDatePrinter printer = new FastDatePrinter("YYYY-'W'ww-u", TimeZone.getDefault(), Locale.getDefault());
        this.vulgar.setMinimalDaysInFirstWeek(4);
        this.vulgar.setFirstDayOfWeek(2);
        Assert.assertEquals((Object)this.isoForm, (Object)printer.format(this.vulgar));
    }
}

