/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bag;

import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.bag.AbstractBagTest;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.collections4.bag.PredicatedBag;
import org.apache.commons.collections4.functors.TruePredicate;

public class PredicatedBagTest<T>
extends AbstractBagTest<T> {
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    public PredicatedBagTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PredicatedBagTest.class);
    }

    protected Predicate<T> stringPredicate() {
        return new Predicate<T>(){

            public boolean evaluate(T o) {
                return o instanceof String;
            }
        };
    }

    protected Bag<T> decorateBag(HashBag<T> bag, Predicate<T> predicate) {
        return PredicatedBag.predicatedBag(bag, predicate);
    }

    @Override
    public Bag<T> makeObject() {
        return this.decorateBag(new HashBag(), this.truePredicate);
    }

    protected Bag<T> makeTestBag() {
        return this.decorateBag(new HashBag(), this.stringPredicate());
    }

    public void testlegalAddRemove() {
        Bag<T> bag = this.makeTestBag();
        PredicatedBagTest.assertEquals((int)0, (int)bag.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "1"};
        for (int i = 0; i < els.length; ++i) {
            bag.add(els[i]);
            PredicatedBagTest.assertEquals((int)(i + 1), (int)bag.size());
            PredicatedBagTest.assertEquals((boolean)true, (boolean)bag.contains(els[i]));
        }
        Set set = ((PredicatedBag)bag).uniqueSet();
        PredicatedBagTest.assertTrue((String)"Unique set contains the first element", (boolean)set.contains(els[0]));
        PredicatedBagTest.assertEquals((boolean)true, (boolean)bag.remove(els[0]));
        set = ((PredicatedBag)bag).uniqueSet();
        PredicatedBagTest.assertTrue((String)"Unique set now does not contain the first element", (!set.contains(els[0]) ? 1 : 0) != 0);
    }

    public void testIllegalAdd() {
        Bag<T> bag = this.makeTestBag();
        Integer i = 3;
        try {
            bag.add((Object)i);
            PredicatedBagTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedBagTest.assertTrue((String)"Collection shouldn't contain illegal element", (!bag.contains((Object)i) ? 1 : 0) != 0);
    }

    public void testIllegalDecorate() {
        HashBag elements = new HashBag();
        elements.add((Object)"one");
        elements.add((Object)"two");
        elements.add((Object)3);
        elements.add((Object)"four");
        try {
            this.decorateBag(elements, this.stringPredicate());
            PredicatedBagTest.fail((String)"Bag contains an element that should fail the predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.decorateBag(new HashBag(), null);
            PredicatedBagTest.fail((String)"Expecting NullPointerException for null predicate.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

