/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractMockPredicateTest;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCompositePredicateTest<T>
extends AbstractMockPredicateTest<T> {
    protected AbstractCompositePredicateTest(T testValue) {
        super(testValue);
    }

    protected abstract Predicate<T> getPredicateInstance(Predicate<? super T> ... var1);

    protected abstract Predicate<T> getPredicateInstance(Collection<Predicate<T>> var1);

    protected final Predicate<T> getPredicateInstance(Boolean ... mockReturnValues) {
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
        for (Boolean returnValue : mockReturnValues) {
            predicates.add(this.createMockPredicate(returnValue));
        }
        return this.getPredicateInstance(predicates);
    }

    public void singleElementArrayToGetInstance() {
        Predicate predicate = this.createMockPredicate(null);
        Predicate<T> allPredicate = this.getPredicateInstance(predicate);
        Assert.assertSame((String)"expected argument to be returned by getInstance()", predicate, allPredicate);
    }

    public void singletonCollectionToGetInstance() {
        Predicate predicate = this.createMockPredicate(null);
        Predicate allPredicate = this.getPredicateInstance(Collections.singleton(predicate));
        Assert.assertSame((String)"expected argument to be returned by getInstance()", predicate, allPredicate);
    }

    @Test(expected=NullPointerException.class)
    public final void nullArrayToGetInstance() {
        this.getPredicateInstance((Predicate[])null);
    }

    @Test(expected=NullPointerException.class)
    public final void nullElementInArrayToGetInstance() {
        this.getPredicateInstance(new Predicate[]{null});
    }

    @Test(expected=NullPointerException.class)
    public final void nullElementsInArrayToGetInstance() {
        this.getPredicateInstance(new Predicate[]{null, null});
    }

    @Test(expected=NullPointerException.class)
    public final void nullCollectionToGetInstance() {
        this.getPredicateInstance((Collection)null);
    }

    @Test(expected=NullPointerException.class)
    public final void nullElementsInCollectionToGetInstance() {
        ArrayList<Predicate<T>> coll = new ArrayList<Predicate<T>>();
        coll.add(null);
        coll.add(null);
        this.getPredicateInstance(coll);
    }
}

