/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.Comparator;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractPredicateTest;
import org.apache.commons.collections4.functors.ComparatorPredicate;
import org.junit.Test;

public class ComparatorPredicateTest
extends AbstractPredicateTest {
    @Test
    public void compareEquals() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator());
        this.assertFalse(p, value - 1);
        this.assertTrue(p, Integer.valueOf(value));
        this.assertFalse(p, value + 1);
    }

    @Test
    public void compareGreater() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.GREATER);
        this.assertTrue(p, value - 1);
        this.assertFalse(p, Integer.valueOf(value));
        this.assertFalse(p, value + 1);
    }

    @Test
    public void compareLess() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.LESS);
        this.assertFalse(p, value - 1);
        this.assertFalse(p, Integer.valueOf(value));
        this.assertTrue(p, value + 1);
    }

    @Test
    public void compareGreaterOrEqual() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.GREATER_OR_EQUAL);
        this.assertTrue(p, value - 1);
        this.assertTrue(p, Integer.valueOf(value));
        this.assertFalse(p, value + 1);
    }

    @Test
    public void compareLessOrEqual() {
        Integer value = 10;
        Predicate p = ComparatorPredicate.comparatorPredicate((Object)value, new TestComparator(), (ComparatorPredicate.Criterion)ComparatorPredicate.Criterion.LESS_OR_EQUAL);
        this.assertFalse(p, value - 1);
        this.assertTrue(p, Integer.valueOf(value));
        this.assertTrue(p, value + 1);
    }

    @Override
    protected Predicate<?> generatePredicate() {
        return ComparatorPredicate.comparatorPredicate((Object)10, new TestComparator());
    }

    private class TestComparator<T extends Comparable<T>>
    implements Comparator<T> {
        private TestComparator() {
        }

        @Override
        public int compare(T first, T second) {
            return first.compareTo(second);
        }
    }
}

