/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.keyvalue;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.KeyValue;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.junit.Assert;
import org.junit.Test;

public class DefaultKeyValueTest<K, V> {
    private final String key = "name";
    private final String value = "duke";

    protected DefaultKeyValue<K, V> makeDefaultKeyValue() {
        return new DefaultKeyValue(null, null);
    }

    protected DefaultKeyValue<K, V> makeDefaultKeyValue(K key, V value) {
        return new DefaultKeyValue(key, value);
    }

    @Test
    public void testAccessorsAndMutators() {
        DefaultKeyValue<K, V> kv = this.makeDefaultKeyValue();
        kv.setKey((Object)"name");
        Assert.assertTrue((kv.getKey() == "name" ? 1 : 0) != 0);
        kv.setValue((Object)"duke");
        Assert.assertTrue((kv.getValue() == "duke" ? 1 : 0) != 0);
        kv.setKey(null);
        Assert.assertTrue((kv.getKey() == null ? 1 : 0) != 0);
        kv.setValue(null);
        Assert.assertTrue((kv.getValue() == null ? 1 : 0) != 0);
    }

    @Test
    public void testSelfReferenceHandling() {
        DefaultKeyValue<K, V> kv = this.makeDefaultKeyValue();
        try {
            kv.setKey(kv);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        }
        try {
            kv.setValue(kv);
            Assert.fail((String)"Should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            Assert.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConstructors() {
        DefaultKeyValue kv = new DefaultKeyValue();
        Assert.assertTrue((kv.getKey() == null && kv.getValue() == null ? 1 : 0) != 0);
        kv = new DefaultKeyValue((Object)"name", (Object)"duke");
        Assert.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        DefaultKeyValue kv2 = new DefaultKeyValue((KeyValue)kv);
        Assert.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        kv.setKey(null);
        kv.setValue(null);
        Assert.assertTrue((kv2.getKey() == "name" && kv2.getValue() == "duke" ? 1 : 0) != 0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "duke");
        Map.Entry entry = map.entrySet().iterator().next();
        kv = new DefaultKeyValue(entry);
        Assert.assertTrue((kv.getKey() == "name" && kv.getValue() == "duke" ? 1 : 0) != 0);
        entry.setValue(null);
        Assert.assertTrue((kv.getValue() == "duke" ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsAndHashCode() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        DefaultKeyValue<String, String> kv2 = this.makeDefaultKeyValue("name", "duke");
        Assert.assertTrue((boolean)kv.equals(kv));
        Assert.assertTrue((boolean)kv.equals(kv2));
        Assert.assertTrue((kv.hashCode() == kv2.hashCode() ? 1 : 0) != 0);
        kv = this.makeDefaultKeyValue(null, null);
        kv2 = this.makeDefaultKeyValue(null, null);
        Assert.assertTrue((boolean)kv.equals(kv));
        Assert.assertTrue((boolean)kv.equals(kv2));
        Assert.assertTrue((kv.hashCode() == kv2.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        Assert.assertTrue((boolean)kv.toString().equals(kv.getKey() + "=" + kv.getValue()));
        kv = this.makeDefaultKeyValue(null, null);
        Assert.assertTrue((boolean)kv.toString().equals(kv.getKey() + "=" + kv.getValue()));
    }

    @Test
    public void testToMapEntry() {
        DefaultKeyValue<String, String> kv = this.makeDefaultKeyValue("name", "duke");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(kv.getKey(), kv.getValue());
        Map.Entry entry = map.entrySet().iterator().next();
        Assert.assertTrue((boolean)entry.equals(kv.toMapEntry()));
        Assert.assertTrue((entry.hashCode() == kv.hashCode() ? 1 : 0) != 0);
    }
}

