/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.multiset;

import java.util.Set;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.MultiSet;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.multiset.AbstractMultiSetTest;
import org.apache.commons.collections4.multiset.HashMultiSet;
import org.apache.commons.collections4.multiset.PredicatedMultiSet;

public class PredicatedMultiSetTest<T>
extends AbstractMultiSetTest<T> {
    protected Predicate<T> truePredicate = TruePredicate.truePredicate();

    public PredicatedMultiSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PredicatedMultiSetTest.class);
    }

    protected Predicate<T> stringPredicate() {
        return new Predicate<T>(){

            public boolean evaluate(T o) {
                return o instanceof String;
            }
        };
    }

    protected MultiSet<T> decorateMultiSet(HashMultiSet<T> multiset, Predicate<T> predicate) {
        return PredicatedMultiSet.predicatedMultiSet(multiset, predicate);
    }

    @Override
    public MultiSet<T> makeObject() {
        return this.decorateMultiSet(new HashMultiSet(), this.truePredicate);
    }

    protected MultiSet<T> makeTestMultiSet() {
        return this.decorateMultiSet(new HashMultiSet(), this.stringPredicate());
    }

    public void testLegalAddRemove() {
        MultiSet<T> multiset = this.makeTestMultiSet();
        PredicatedMultiSetTest.assertEquals((int)0, (int)multiset.size());
        Object[] els = new Object[]{"1", "3", "5", "7", "2", "4", "1"};
        for (int i = 0; i < els.length; ++i) {
            multiset.add(els[i]);
            PredicatedMultiSetTest.assertEquals((int)(i + 1), (int)multiset.size());
            PredicatedMultiSetTest.assertEquals((boolean)true, (boolean)multiset.contains(els[i]));
        }
        Set set = ((PredicatedMultiSet)multiset).uniqueSet();
        PredicatedMultiSetTest.assertTrue((String)"Unique set contains the first element", (boolean)set.contains(els[0]));
        PredicatedMultiSetTest.assertEquals((boolean)true, (boolean)multiset.remove(els[0]));
        set = ((PredicatedMultiSet)multiset).uniqueSet();
        PredicatedMultiSetTest.assertTrue((String)"Unique set does not contain anymore the first element", (boolean)set.contains(els[0]));
    }

    public void testIllegalAdd() {
        MultiSet<T> multiset = this.makeTestMultiSet();
        Integer i = 3;
        try {
            multiset.add((Object)i);
            PredicatedMultiSetTest.fail((String)"Integer should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedMultiSetTest.assertTrue((String)"Collection shouldn't contain illegal element", (!multiset.contains((Object)i) ? 1 : 0) != 0);
    }

    public void testIllegalDecorate() {
        HashMultiSet elements = new HashMultiSet();
        elements.add((Object)"one");
        elements.add((Object)"two");
        elements.add((Object)3);
        elements.add((Object)"four");
        try {
            this.decorateMultiSet(elements, this.stringPredicate());
            PredicatedMultiSetTest.fail((String)"MultiSet contains an element that should fail the predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.decorateMultiSet(new HashMultiSet(), null);
            PredicatedMultiSetTest.fail((String)"Expecting NullPointerException for null predicate.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4.1";
    }
}

