/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.queue;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.queue.AbstractQueueTest;
import org.apache.commons.collections4.queue.UnmodifiableQueue;

public class UnmodifiableQueueTest<E>
extends AbstractQueueTest<E> {
    public UnmodifiableQueueTest(String testName) {
        super(testName);
    }

    @Override
    public Queue<E> makeObject() {
        return UnmodifiableQueue.unmodifiableQueue(new LinkedList());
    }

    @Override
    public Queue<E> makeFullCollection() {
        LinkedList queue = new LinkedList();
        queue.addAll(Arrays.asList(this.getFullElements()));
        return UnmodifiableQueue.unmodifiableQueue(queue);
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new LinkedList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        LinkedList list = new LinkedList();
        list.addAll(Arrays.asList(this.getFullElements()));
        return list;
    }

    @Override
    public Queue<E> getCollection() {
        return super.getCollection();
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public boolean isNullSupported() {
        return false;
    }

    @Override
    public void testQueueRemove() {
        this.resetEmpty();
        try {
            this.getCollection().remove();
            UnmodifiableQueueTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUnmodifiable() {
        UnmodifiableQueueTest.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        UnmodifiableQueueTest.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        Collection queue = this.makeFullCollection();
        UnmodifiableQueueTest.assertSame((Object)queue, (Object)UnmodifiableQueue.unmodifiableQueue((Queue)queue));
        try {
            UnmodifiableQueue.unmodifiableQueue(null);
            UnmodifiableQueueTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

