/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.Arrays;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.set.AbstractSortedSetTest;
import org.apache.commons.collections4.set.PredicatedSortedSet;

public class PredicatedSortedSetTest<E>
extends AbstractSortedSetTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = new Predicate<E>(){

        public boolean evaluate(E o) {
            return o instanceof String && ((String)o).startsWith("A");
        }
    };

    public PredicatedSortedSetTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return BulkTest.makeSuite(PredicatedSortedSetTest.class);
    }

    @Override
    public SortedSet<E> makeObject() {
        return PredicatedSortedSet.predicatedSortedSet(new TreeSet(), this.truePredicate);
    }

    @Override
    public SortedSet<E> makeFullCollection() {
        TreeSet set = new TreeSet();
        set.addAll(Arrays.asList(this.getFullElements()));
        return PredicatedSortedSet.predicatedSortedSet(set, this.truePredicate);
    }

    protected PredicatedSortedSet<E> makeTestSet() {
        return PredicatedSortedSet.predicatedSortedSet(new TreeSet(), this.testPredicate);
    }

    public void testGetSet() {
        PredicatedSortedSet<E> set = this.makeTestSet();
        PredicatedSortedSetTest.assertTrue((String)"returned set should not be null", (set.decorated() != null ? 1 : 0) != 0);
    }

    public void testIllegalAdd() {
        PredicatedSortedSet<String> set = this.makeTestSet();
        String testString = "B";
        try {
            set.add("B");
            PredicatedSortedSetTest.fail((String)"Should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedSortedSetTest.assertTrue((String)"Collection shouldn't contain illegal element", (!set.contains("B") ? 1 : 0) != 0);
    }

    public void testIllegalAddAll() {
        PredicatedSortedSet set = this.makeTestSet();
        TreeSet<String> elements = new TreeSet<String>();
        elements.add("Aone");
        elements.add("Atwo");
        elements.add("Bthree");
        elements.add("Afour");
        try {
            set.addAll(elements);
            PredicatedSortedSetTest.fail((String)"Should fail string predicate.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        PredicatedSortedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Aone") ? 1 : 0) != 0);
        PredicatedSortedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Atwo") ? 1 : 0) != 0);
        PredicatedSortedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Bthree") ? 1 : 0) != 0);
        PredicatedSortedSetTest.assertTrue((String)"Set shouldn't contain illegal element", (!set.contains("Afour") ? 1 : 0) != 0);
    }

    public void testComparator() {
        PredicatedSortedSet<E> set = this.makeTestSet();
        Comparator c = set.comparator();
        PredicatedSortedSetTest.assertTrue((String)"natural order, so comparator should be null", (c == null ? 1 : 0) != 0);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }
}

