/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArrayUtilsRemoveTest {
    @Test
    public void testRemoveObjectArray() {
        Object[] array = ArrayUtils.remove((Object[])new Object[]{"a"}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b", "c"}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"a", "c"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((Object[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        Assert.assertEquals((long)3L, (long)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.remove((Object[])inarray, (int)1);
        Assert.assertEquals((long)2L, (long)outarray.length);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)1);
        Assert.assertEquals((long)1L, (long)outarray.length);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)0);
        Assert.assertEquals((long)0L, (long)outarray.length);
        Assert.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    @Test
    public void testRemoveBooleanArray() {
        boolean[] array = ArrayUtils.remove((boolean[])new boolean[]{true}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false, true}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((boolean[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveByteArray() {
        byte[] array = ArrayUtils.remove((byte[])new byte[]{1}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2, 1}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((byte[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveCharArray() {
        char[] array = ArrayUtils.remove((char[])new char[]{'a'}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b', 'c'}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((char[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveDoubleArray() {
        double[] array = ArrayUtils.remove((double[])new double[]{1.0}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0, 1.0}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((double[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveFloatArray() {
        float[] array = ArrayUtils.remove((float[])new float[]{1.0f}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f, 1.0f}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((float[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveIntArray() {
        int[] array = ArrayUtils.remove((int[])new int[]{1}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2, 1}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((int[])new int[]{1, 2}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((int[])new int[]{1, 2}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((int[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveLongArray() {
        long[] array = ArrayUtils.remove((long[])new long[]{1L}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L, 1L}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((long[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveShortArray() {
        short[] array = ArrayUtils.remove((short[])new short[]{1}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2, 1}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        try {
            ArrayUtils.remove((short[])new short[]{1, 2}, (int)-1);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((short[])new short[]{1, 2}, (int)2);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            ArrayUtils.remove((short[])null, (int)0);
            Assert.fail((String)"IndexOutOfBoundsException expected");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveElementObjectArray() {
        Object[] array = ArrayUtils.removeElement((Object[])null, (Object)"a");
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a"}, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_OBJECT_ARRAY, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b"}, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b", "a"}, (Object)"a");
        Assert.assertTrue((boolean)Arrays.equals(new Object[]{"b", "a"}, array));
        Assert.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElement((boolean[])null, (boolean)true);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true}, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false}, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false, true}, (boolean)true);
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, true}, array));
        Assert.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElement((byte[])null, (byte)1);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1}, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2}, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2, 1}, (byte)1);
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{2, 1}, array));
        Assert.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElement((char[])null, (char)'a');
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char)'a');
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a'}, (char)'a');
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b'}, (char)'a');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b', 'a'}, (char)'a');
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'b', 'a'}, array));
        Assert.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElement((double[])null, (double)1.0);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0}, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0}, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0, 1.0}, (double)1.0);
        Assert.assertTrue((boolean)Arrays.equals(new double[]{2.0, 1.0}, array));
        Assert.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElement((float[])null, (float)1.0f);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f}, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f}, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f, 1.0f}, (float)1.0f);
        Assert.assertTrue((boolean)Arrays.equals(new float[]{2.0f, 1.0f}, array));
        Assert.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElement((int[])null, (int)1);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2, 1}, (int)1);
        Assert.assertTrue((boolean)Arrays.equals(new int[]{2, 1}, array));
        Assert.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElement((long[])null, (long)1L);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L}, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L}, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L, 1L}, (long)1L);
        Assert.assertTrue((boolean)Arrays.equals(new long[]{2L, 1L}, array));
        Assert.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElement((short[])null, (short)1);
        Assert.assertNull((Object)array);
        array = ArrayUtils.removeElement((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1}, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2}, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2, 1}, (short)1);
        Assert.assertTrue((boolean)Arrays.equals(new short[]{2, 1}, array));
        Assert.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllBooleanOccurences() {
        boolean[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (boolean)true));
        a = new boolean[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true)));
        a = new boolean[]{true};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true)));
        a = new boolean[]{true, true};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BOOLEAN_ARRAY, ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true)));
        a = new boolean[]{false, true, true, false, true};
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{false, false}, ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true)));
        a = new boolean[]{false, true, true, false, true};
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, true, true}, ArrayUtils.removeAllOccurences((boolean[])a, (boolean)false)));
    }

    @Test
    public void testRemoveAllCharOccurences() {
        char[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (char)'2'));
        a = new char[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, ArrayUtils.removeAllOccurences((char[])a, (char)'2')));
        a = new char[]{'2'};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, ArrayUtils.removeAllOccurences((char[])a, (char)'2')));
        a = new char[]{'2', '2'};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_CHAR_ARRAY, ArrayUtils.removeAllOccurences((char[])a, (char)'2')));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'1', '3'}, ArrayUtils.removeAllOccurences((char[])a, (char)'2')));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'1', '2', '2', '3', '2'}, ArrayUtils.removeAllOccurences((char[])a, (char)'4')));
    }

    @Test
    public void testRemoveAllByteOccurences() {
        byte[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (byte)2));
        a = new byte[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.removeAllOccurences((byte[])a, (byte)2)));
        a = new byte[]{2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.removeAllOccurences((byte[])a, (byte)2)));
        a = new byte[]{2, 2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_BYTE_ARRAY, ArrayUtils.removeAllOccurences((byte[])a, (byte)2)));
        a = new byte[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 3}, ArrayUtils.removeAllOccurences((byte[])a, (byte)2)));
        a = new byte[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{1, 2, 2, 3, 2}, ArrayUtils.removeAllOccurences((byte[])a, (byte)4)));
    }

    @Test
    public void testRemoveAllShortOccurences() {
        short[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (short)2));
        a = new short[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, ArrayUtils.removeAllOccurences((short[])a, (short)2)));
        a = new short[]{2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, ArrayUtils.removeAllOccurences((short[])a, (short)2)));
        a = new short[]{2, 2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_SHORT_ARRAY, ArrayUtils.removeAllOccurences((short[])a, (short)2)));
        a = new short[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 3}, ArrayUtils.removeAllOccurences((short[])a, (short)2)));
        a = new short[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new short[]{1, 2, 2, 3, 2}, ArrayUtils.removeAllOccurences((short[])a, (short)4)));
    }

    @Test
    public void testRemoveAllIntOccurences() {
        int[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (int)2));
        a = new int[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.removeAllOccurences((int[])a, (int)2)));
        a = new int[]{2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.removeAllOccurences((int[])a, (int)2)));
        a = new int[]{2, 2};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.removeAllOccurences((int[])a, (int)2)));
        a = new int[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 3}, ArrayUtils.removeAllOccurences((int[])a, (int)2)));
        a = new int[]{1, 2, 2, 3, 2};
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 2, 3, 2}, ArrayUtils.removeAllOccurences((int[])a, (int)4)));
    }

    @Test
    public void testRemoveAllLongOccurences() {
        long[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (long)2L));
        a = new long[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, ArrayUtils.removeAllOccurences((long[])a, (long)2L)));
        a = new long[]{2L};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, ArrayUtils.removeAllOccurences((long[])a, (long)2L)));
        a = new long[]{2L, 2L};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_LONG_ARRAY, ArrayUtils.removeAllOccurences((long[])a, (long)2L)));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 3L}, ArrayUtils.removeAllOccurences((long[])a, (long)2L)));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assert.assertTrue((boolean)Arrays.equals(new long[]{1L, 2L, 2L, 3L, 2L}, ArrayUtils.removeAllOccurences((long[])a, (long)4L)));
    }

    @Test
    public void testRemoveAllFloatOccurences() {
        float[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (float)2.0f));
        a = new float[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, ArrayUtils.removeAllOccurences((float[])a, (float)2.0f)));
        a = new float[]{2.0f};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, ArrayUtils.removeAllOccurences((float[])a, (float)2.0f)));
        a = new float[]{2.0f, 2.0f};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_FLOAT_ARRAY, ArrayUtils.removeAllOccurences((float[])a, (float)2.0f)));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 3.0f}, ArrayUtils.removeAllOccurences((float[])a, (float)2.0f)));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assert.assertTrue((boolean)Arrays.equals(new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f}, ArrayUtils.removeAllOccurences((float[])a, (float)4.0f)));
    }

    @Test
    public void testRemoveAllDoubleOccurences() {
        double[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (double)2.0));
        a = new double[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, ArrayUtils.removeAllOccurences((double[])a, (double)2.0)));
        a = new double[]{2.0};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, ArrayUtils.removeAllOccurences((double[])a, (double)2.0)));
        a = new double[]{2.0, 2.0};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_DOUBLE_ARRAY, ArrayUtils.removeAllOccurences((double[])a, (double)2.0)));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 3.0}, ArrayUtils.removeAllOccurences((double[])a, (double)2.0)));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assert.assertTrue((boolean)Arrays.equals(new double[]{1.0, 2.0, 2.0, 3.0, 2.0}, ArrayUtils.removeAllOccurences((double[])a, (double)4.0)));
    }

    @Test
    public void testRemoveAllObjectOccurences() {
        Object[] a = null;
        Assert.assertNull((Object)ArrayUtils.removeAllOccurences(a, (Object)"2"));
        a = new String[]{};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.removeAllOccurences((Object[])a, (Object)"2")));
        a = new String[]{"2"};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.removeAllOccurences((Object[])a, (Object)"2")));
        a = new String[]{"2", "2"};
        Assert.assertTrue((boolean)Arrays.equals(ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils.removeAllOccurences((Object[])a, (Object)"2")));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"1", "3"}, ArrayUtils.removeAllOccurences((Object[])a, (Object)"2")));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"1", "2", "2", "3", "2"}, ArrayUtils.removeAllOccurences((Object[])a, (Object)"4")));
    }
}

