/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiLineToStringStyleTest {
    private final Integer base = 5;
    private final String baseStr = this.base.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this.base));

    @Before
    public void setUp() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @After
    public void tearDown() throws Exception {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testBlank() {
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testAppendSuper() {
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]").append("a", (Object)"hello").toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=hello" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  3" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "  b=4" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<Integer>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=[]" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new ArrayList(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a={}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", new HashMap(), true).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=<size=0>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], false).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a={}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new String[0], true).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Jane Doe";
        p.age = 25;
        p.smoker = true;
        String pBaseStr = p.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(p));
        Assert.assertEquals((Object)(pBaseStr + "[" + SystemUtils.LINE_SEPARATOR + "  name=Jane Doe" + SystemUtils.LINE_SEPARATOR + "  age=25" + SystemUtils.LINE_SEPARATOR + "  smoker=true" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    @Test
    public void testLong() {
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  3" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  a=3" + SystemUtils.LINE_SEPARATOR + "  b=4" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {<null>,5,{3,6}}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {<null>,5,{3,6}}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {1,2,-3,4}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {1,2,-3,4}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        Object array = new long[][]{{1L, 2L}, null, {5L}};
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {{1,2},<null>,{5}}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  {{1,2},<null>,{5}}" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        array = null;
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assert.assertEquals((Object)(this.baseStr + "[" + SystemUtils.LINE_SEPARATOR + "  <null>" + SystemUtils.LINE_SEPARATOR + "]"), (Object)new ToStringBuilder((Object)this.base).append(array).toString());
    }
}

