/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang3.test.SystemDefaults;
import org.apache.commons.lang3.test.SystemDefaultsSwitch;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class DateUtilsTest {
    private static Date BASE_DATE;
    @Rule
    public SystemDefaultsSwitch defaults = new SystemDefaultsSwitch();
    private DateFormat dateParser = null;
    private DateFormat dateTimeParser = null;
    private Date dateAmPm1 = null;
    private Date dateAmPm2 = null;
    private Date dateAmPm3 = null;
    private Date dateAmPm4 = null;
    private Date date0 = null;
    private Date date1 = null;
    private Date date2 = null;
    private Date date3 = null;
    private Date date4 = null;
    private Date date5 = null;
    private Date date6 = null;
    private Date date7 = null;
    private Date date8 = null;
    private Calendar calAmPm1 = null;
    private Calendar calAmPm2 = null;
    private Calendar calAmPm3 = null;
    private Calendar calAmPm4 = null;
    private Calendar cal1 = null;
    private Calendar cal2 = null;
    private Calendar cal3 = null;
    private Calendar cal4 = null;
    private Calendar cal5 = null;
    private Calendar cal6 = null;
    private Calendar cal7 = null;
    private Calendar cal8 = null;
    private TimeZone zone = null;
    private TimeZone defaultZone = null;

    @BeforeClass
    public static void classSetup() {
        GregorianCalendar cal = new GregorianCalendar(2000, 6, 5, 4, 3, 2);
        cal.set(14, 1);
        BASE_DATE = cal.getTime();
    }

    @Before
    public void setUp() throws Exception {
        this.dateParser = new SimpleDateFormat("MMM dd, yyyy", Locale.ENGLISH);
        this.dateTimeParser = new SimpleDateFormat("MMM dd, yyyy H:mm:ss.SSS", Locale.ENGLISH);
        this.dateAmPm1 = this.dateTimeParser.parse("February 3, 2002 01:10:00.000");
        this.dateAmPm2 = this.dateTimeParser.parse("February 3, 2002 11:10:00.000");
        this.dateAmPm3 = this.dateTimeParser.parse("February 3, 2002 13:10:00.000");
        this.dateAmPm4 = this.dateTimeParser.parse("February 3, 2002 19:10:00.000");
        this.date0 = this.dateTimeParser.parse("February 3, 2002 12:34:56.789");
        this.date1 = this.dateTimeParser.parse("February 12, 2002 12:34:56.789");
        this.date2 = this.dateTimeParser.parse("November 18, 2001 1:23:11.321");
        this.defaultZone = TimeZone.getDefault();
        this.zone = TimeZone.getTimeZone("MET");
        TimeZone.setDefault(this.zone);
        this.dateTimeParser.setTimeZone(this.zone);
        this.date3 = this.dateTimeParser.parse("March 30, 2003 05:30:45.000");
        this.date4 = this.dateTimeParser.parse("March 30, 2003 01:10:00.000");
        this.date5 = this.dateTimeParser.parse("March 30, 2003 01:40:00.000");
        this.date6 = this.dateTimeParser.parse("March 30, 2003 02:10:00.000");
        this.date7 = this.dateTimeParser.parse("March 30, 2003 02:40:00.000");
        this.date8 = this.dateTimeParser.parse("October 26, 2003 05:30:45.000");
        this.dateTimeParser.setTimeZone(this.defaultZone);
        TimeZone.setDefault(this.defaultZone);
        this.calAmPm1 = Calendar.getInstance();
        this.calAmPm1.setTime(this.dateAmPm1);
        this.calAmPm2 = Calendar.getInstance();
        this.calAmPm2.setTime(this.dateAmPm2);
        this.calAmPm3 = Calendar.getInstance();
        this.calAmPm3.setTime(this.dateAmPm3);
        this.calAmPm4 = Calendar.getInstance();
        this.calAmPm4.setTime(this.dateAmPm4);
        this.cal1 = Calendar.getInstance();
        this.cal1.setTime(this.date1);
        this.cal2 = Calendar.getInstance();
        this.cal2.setTime(this.date2);
        TimeZone.setDefault(this.zone);
        this.cal3 = Calendar.getInstance();
        this.cal3.setTime(this.date3);
        this.cal4 = Calendar.getInstance();
        this.cal4.setTime(this.date4);
        this.cal5 = Calendar.getInstance();
        this.cal5.setTime(this.date5);
        this.cal6 = Calendar.getInstance();
        this.cal6.setTime(this.date6);
        this.cal7 = Calendar.getInstance();
        this.cal7.setTime(this.date7);
        this.cal8 = Calendar.getInstance();
        this.cal8.setTime(this.date8);
        TimeZone.setDefault(this.defaultZone);
    }

    @Test
    public void testConstructor() {
        Assert.assertNotNull((Object)new DateUtils());
        Constructor<?>[] cons = DateUtils.class.getDeclaredConstructors();
        Assert.assertEquals((long)1L, (long)cons.length);
        Assert.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assert.assertTrue((boolean)Modifier.isPublic(DateUtils.class.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isFinal(DateUtils.class.getModifiers()));
    }

    @Test
    public void testIsSameDay_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assert.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assert.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assert.assertTrue((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assert.assertFalse((boolean)DateUtils.isSameDay((Date)datea, (Date)dateb));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_DateNullNull() throws Exception {
        DateUtils.isSameDay((Date)null, (Date)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_DateNullNotNull() throws Exception {
        DateUtils.isSameDay((Date)null, (Date)new Date());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_DateNotNullNull() throws Exception {
        DateUtils.isSameDay((Date)new Date(), (Date)null);
    }

    @Test
    public void testIsSameDay_Cal() {
        GregorianCalendar cala = new GregorianCalendar(2004, 6, 9, 13, 45);
        GregorianCalendar calb = new GregorianCalendar(2004, 6, 9, 13, 45);
        Assert.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(6, 1);
        Assert.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        cala.add(6, 1);
        Assert.assertTrue((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
        calb.add(1, 1);
        Assert.assertFalse((boolean)DateUtils.isSameDay((Calendar)cala, (Calendar)calb));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_CalNullNull() throws Exception {
        DateUtils.isSameDay((Calendar)null, (Calendar)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_CalNullNotNull() throws Exception {
        DateUtils.isSameDay((Calendar)null, (Calendar)Calendar.getInstance());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameDay_CalNotNullNull() throws Exception {
        DateUtils.isSameDay((Calendar)Calendar.getInstance(), (Calendar)null);
    }

    @Test
    public void testIsSameInstant_Date() {
        Date datea = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Date dateb = new GregorianCalendar(2004, 6, 9, 13, 45).getTime();
        Assert.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assert.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        datea = new GregorianCalendar(2004, 6, 10, 13, 45).getTime();
        Assert.assertTrue((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
        dateb = new GregorianCalendar(2005, 6, 10, 13, 45).getTime();
        Assert.assertFalse((boolean)DateUtils.isSameInstant((Date)datea, (Date)dateb));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_DateNullNull() throws Exception {
        DateUtils.isSameInstant((Date)null, (Date)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_DateNullNotNull() throws Exception {
        DateUtils.isSameInstant((Date)null, (Date)new Date());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_DateNotNullNull() throws Exception {
        DateUtils.isSameInstant((Date)new Date(), (Date)null);
    }

    @Test
    public void testIsSameInstant_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assert.assertFalse((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
        calb.set(2004, 6, 9, 11, 45, 0);
        Assert.assertTrue((boolean)DateUtils.isSameInstant((Calendar)cala, (Calendar)calb));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_CalNullNull() throws Exception {
        DateUtils.isSameInstant((Calendar)null, (Calendar)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_CalNullNotNull() throws Exception {
        DateUtils.isSameInstant((Calendar)null, (Calendar)Calendar.getInstance());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameInstant_CalNotNullNull() throws Exception {
        DateUtils.isSameInstant((Calendar)Calendar.getInstance(), (Calendar)null);
    }

    @Test
    public void testIsSameLocalTime_Cal() {
        GregorianCalendar cala = new GregorianCalendar(TimeZone.getTimeZone("GMT+1"));
        GregorianCalendar calb = new GregorianCalendar(TimeZone.getTimeZone("GMT-1"));
        cala.set(2004, 6, 9, 13, 45, 0);
        cala.set(14, 0);
        calb.set(2004, 6, 9, 13, 45, 0);
        calb.set(14, 0);
        Assert.assertTrue((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
        Calendar calc = Calendar.getInstance();
        Calendar cald = Calendar.getInstance();
        calc.set(2004, 6, 9, 4, 0, 0);
        cald.set(2004, 6, 9, 16, 0, 0);
        calc.set(14, 0);
        cald.set(14, 0);
        Assert.assertFalse((String)"LANG-677", (boolean)DateUtils.isSameLocalTime((Calendar)calc, (Calendar)cald));
        calb.set(2004, 6, 9, 11, 45, 0);
        Assert.assertFalse((boolean)DateUtils.isSameLocalTime((Calendar)cala, (Calendar)calb));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameLocalTime_CalNullNull() throws Exception {
        DateUtils.isSameLocalTime((Calendar)null, (Calendar)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameLocalTime_CalNullNotNull() throws Exception {
        DateUtils.isSameLocalTime((Calendar)null, (Calendar)Calendar.getInstance());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsSameLocalTime_CalNotNullNull() throws Exception {
        DateUtils.isSameLocalTime((Calendar)Calendar.getInstance(), (Calendar)null);
    }

    @Test
    public void testParseDate() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(1972, 11, 3);
        String dateStr = "1972-12-03";
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        Date date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assert.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "1972-338";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assert.assertEquals((Object)cal.getTime(), (Object)date);
        dateStr = "19721203";
        date = DateUtils.parseDate((String)dateStr, (String[])parsers);
        Assert.assertEquals((Object)cal.getTime(), (Object)date);
    }

    @Test(expected=ParseException.class)
    public void testParseDate_NoDateString() throws Exception {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        DateUtils.parseDate((String)"PURPLE", (String[])parsers);
    }

    @Test(expected=ParseException.class)
    public void testParseDate_InvalidDateString() throws Exception {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        DateUtils.parseDate((String)"197212AB", (String[])parsers);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParseDate_Null() throws Exception {
        String[] parsers = new String[]{"yyyy'-'DDD", "yyyy'-'MM'-'dd", "yyyyMMdd"};
        DateUtils.parseDate(null, (String[])parsers);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParse_NullParsers() throws Exception {
        DateUtils.parseDate((String)"19721203", (String[])null);
    }

    @Test(expected=ParseException.class)
    public void testParse_EmptyParsers() throws Exception {
        DateUtils.parseDate((String)"19721203", (String[])new String[0]);
    }

    @Test
    public void testParseDateWithLeniency() throws Exception {
        GregorianCalendar cal = new GregorianCalendar(1998, 6, 30);
        String dateStr = "02 942, 1996";
        String[] parsers = new String[]{"MM DDD, yyyy"};
        Date date = DateUtils.parseDate((String)"02 942, 1996", (String[])parsers);
        Assert.assertEquals((Object)cal.getTime(), (Object)date);
        try {
            DateUtils.parseDateStrictly((String)"02 942, 1996", (String[])parsers);
            Assert.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Test
    public void testAddYears() throws Exception {
        Date result = DateUtils.addYears((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2001, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addYears((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 1999, 6, 5, 4, 3, 2, 1);
    }

    @Test
    public void testAddMonths() throws Exception {
        Date result = DateUtils.addMonths((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 7, 5, 4, 3, 2, 1);
        result = DateUtils.addMonths((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
    }

    @Test
    public void testAddWeeks() throws Exception {
        Date result = DateUtils.addWeeks((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 12, 4, 3, 2, 1);
        result = DateUtils.addWeeks((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 28, 4, 3, 2, 1);
    }

    @Test
    public void testAddDays() throws Exception {
        Date result = DateUtils.addDays((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 6, 4, 3, 2, 1);
        result = DateUtils.addDays((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 4, 4, 3, 2, 1);
    }

    @Test
    public void testAddHours() throws Exception {
        Date result = DateUtils.addHours((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 5, 3, 2, 1);
        result = DateUtils.addHours((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 3, 3, 2, 1);
    }

    @Test
    public void testAddMinutes() throws Exception {
        Date result = DateUtils.addMinutes((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 4, 2, 1);
        result = DateUtils.addMinutes((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 2, 2, 1);
    }

    @Test
    public void testAddSeconds() throws Exception {
        Date result = DateUtils.addSeconds((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 3, 1);
        result = DateUtils.addSeconds((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 1, 1);
    }

    @Test
    public void testAddMilliseconds() throws Exception {
        Date result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 2);
        result = DateUtils.addMilliseconds((Date)BASE_DATE, (int)-1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
    }

    @Test
    public void testSetYears() throws Exception {
        Date result = DateUtils.setYears((Date)BASE_DATE, (int)2000);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2008);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2008, 6, 5, 4, 3, 2, 1);
        result = DateUtils.setYears((Date)BASE_DATE, (int)2005);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2005, 6, 5, 4, 3, 2, 1);
    }

    @Test
    public void testSetMonths() throws Exception {
        Date result = DateUtils.setMonths((Date)BASE_DATE, (int)5);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 5, 5, 4, 3, 2, 1);
        result = DateUtils.setMonths((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 1, 5, 4, 3, 2, 1);
        try {
            DateUtils.setMonths((Date)BASE_DATE, (int)12);
            Assert.fail((String)"DateUtils.setMonths did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetDays() throws Exception {
        Date result = DateUtils.setDays((Date)BASE_DATE, (int)1);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 1, 4, 3, 2, 1);
        result = DateUtils.setDays((Date)BASE_DATE, (int)29);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 29, 4, 3, 2, 1);
        try {
            DateUtils.setDays((Date)BASE_DATE, (int)32);
            Assert.fail((String)"DateUtils.setDays did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetHours() throws Exception {
        Date result = DateUtils.setHours((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 0, 3, 2, 1);
        result = DateUtils.setHours((Date)BASE_DATE, (int)23);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 23, 3, 2, 1);
        try {
            DateUtils.setHours((Date)BASE_DATE, (int)24);
            Assert.fail((String)"DateUtils.setHours did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetMinutes() throws Exception {
        Date result = DateUtils.setMinutes((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 0, 2, 1);
        result = DateUtils.setMinutes((Date)BASE_DATE, (int)59);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 59, 2, 1);
        try {
            DateUtils.setMinutes((Date)BASE_DATE, (int)60);
            Assert.fail((String)"DateUtils.setMinutes did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetSeconds() throws Exception {
        Date result = DateUtils.setSeconds((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 0, 1);
        result = DateUtils.setSeconds((Date)BASE_DATE, (int)59);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 59, 1);
        try {
            DateUtils.setSeconds((Date)BASE_DATE, (int)60);
            Assert.fail((String)"DateUtils.setSeconds did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetMilliseconds() throws Exception {
        Date result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)0);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 0);
        result = DateUtils.setMilliseconds((Date)BASE_DATE, (int)999);
        Assert.assertNotSame((Object)BASE_DATE, (Object)result);
        this.assertDate(BASE_DATE, 2000, 6, 5, 4, 3, 2, 1);
        this.assertDate(result, 2000, 6, 5, 4, 3, 2, 999);
        try {
            DateUtils.setMilliseconds((Date)BASE_DATE, (int)1000);
            Assert.fail((String)"DateUtils.setMilliseconds did not throw an expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertDate(Date date, int year, int month, int day, int hour, int min, int sec, int mil) throws Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        Assert.assertEquals((long)year, (long)cal.get(1));
        Assert.assertEquals((long)month, (long)cal.get(2));
        Assert.assertEquals((long)day, (long)cal.get(5));
        Assert.assertEquals((long)hour, (long)cal.get(11));
        Assert.assertEquals((long)min, (long)cal.get(12));
        Assert.assertEquals((long)sec, (long)cal.get(13));
        Assert.assertEquals((long)mil, (long)cal.get(14));
    }

    @Test
    public void testToCalendar() {
        Assert.assertEquals((String)"Failed to convert to a Calendar and back", (Object)this.date1, (Object)DateUtils.toCalendar((Date)this.date1).getTime());
        try {
            DateUtils.toCalendar(null);
            Assert.fail((String)"Expected NullPointerException to be thrown");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test(expected=NullPointerException.class)
    public void testToCalendarWithDateNull() {
        DateUtils.toCalendar(null, (TimeZone)this.zone);
    }

    @Test(expected=NullPointerException.class)
    public void testToCalendarWithTimeZoneNull() {
        DateUtils.toCalendar((Date)this.date1, null);
    }

    @Test
    public void testToCalendarWithDateAndTimeZoneNotNull() {
        Calendar c = DateUtils.toCalendar((Date)this.date2, (TimeZone)this.defaultZone);
        Assert.assertEquals((String)"Convert Date and TimeZone to a Calendar, but failed to get the Date back", (Object)this.date2, (Object)c.getTime());
        Assert.assertEquals((String)"Convert Date and TimeZone to a Calendar, but failed to get the TimeZone back", (Object)this.defaultZone, (Object)c.getTimeZone());
    }

    @Test(expected=NullPointerException.class)
    public void testToCalendarWithDateAndTimeZoneNull() {
        DateUtils.toCalendar(null, null);
    }

    @Test
    public void testRound() throws Exception {
        Assert.assertEquals((String)"round year-1 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1));
        Assert.assertEquals((String)"round year-2 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Date)this.date2, (int)1));
        Assert.assertEquals((String)"round month-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date1, (int)2));
        Assert.assertEquals((String)"round month-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Date)this.date2, (int)2));
        Assert.assertEquals((String)"round semimonth-0 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Date)this.date0, (int)1001));
        Assert.assertEquals((String)"round semimonth-1 failed", (Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Date)this.date1, (int)1001));
        Assert.assertEquals((String)"round semimonth-2 failed", (Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Date)this.date2, (int)1001));
        Assert.assertEquals((String)"round date-1 failed", (Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Date)this.date1, (int)5));
        Assert.assertEquals((String)"round date-2 failed", (Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Date)this.date2, (int)5));
        Assert.assertEquals((String)"round hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Date)this.date1, (int)10));
        Assert.assertEquals((String)"round hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Date)this.date2, (int)10));
        Assert.assertEquals((String)"round minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Date)this.date1, (int)12));
        Assert.assertEquals((String)"round minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Date)this.date2, (int)12));
        Assert.assertEquals((String)"round second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Date)this.date1, (int)13));
        Assert.assertEquals((String)"round second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Date)this.date2, (int)13));
        Assert.assertEquals((String)"round ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"round ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"round ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"round ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Date)this.dateAmPm4, (int)9));
        Assert.assertEquals((String)"round year-1 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1));
        Assert.assertEquals((String)"round year-2 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.round((Object)this.date2, (int)1));
        Assert.assertEquals((String)"round month-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.round((Object)this.date1, (int)2));
        Assert.assertEquals((String)"round month-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.round((Object)this.date2, (int)2));
        Assert.assertEquals((String)"round semimonth-1 failed", (Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.round((Object)this.date1, (int)1001));
        Assert.assertEquals((String)"round semimonth-2 failed", (Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.round((Object)this.date2, (int)1001));
        Assert.assertEquals((String)"round date-1 failed", (Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.round((Object)this.date1, (int)5));
        Assert.assertEquals((String)"round date-2 failed", (Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.round((Object)this.date2, (int)5));
        Assert.assertEquals((String)"round hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.round((Object)this.date1, (int)10));
        Assert.assertEquals((String)"round hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.round((Object)this.date2, (int)10));
        Assert.assertEquals((String)"round minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.round((Object)this.date1, (int)12));
        Assert.assertEquals((String)"round minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.round((Object)this.date2, (int)12));
        Assert.assertEquals((String)"round second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.date1, (int)13));
        Assert.assertEquals((String)"round second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.date2, (int)13));
        Assert.assertEquals((String)"round calendar second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.round((Object)this.cal1, (int)13));
        Assert.assertEquals((String)"round calendar second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.round((Object)this.cal2, (int)13));
        Assert.assertEquals((String)"round ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"round ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"round ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"round ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.dateAmPm4, (int)9));
        try {
            DateUtils.round((Date)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.round((Calendar)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.round(null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.round((Object)"", (int)13);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            DateUtils.round((Date)this.date1, (int)-9999);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((String)"round ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm1, (int)9));
        Assert.assertEquals((String)"round ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm2, (int)9));
        Assert.assertEquals((String)"round ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm3, (int)9));
        Assert.assertEquals((String)"round ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.round((Object)this.calAmPm4, (int)9));
        TimeZone.setDefault(this.zone);
        this.dateTimeParser.setTimeZone(this.zone);
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)5));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Date)this.date4, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 01:00:00.000"), (Object)DateUtils.round((Object)this.cal4, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date5, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal5, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Date)this.date6, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.round((Object)this.cal6, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Date)this.date7, (int)11));
        Assert.assertEquals((String)"round MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.round((Object)this.cal7, (int)11));
        TimeZone.setDefault(this.defaultZone);
        this.dateTimeParser.setTimeZone(this.defaultZone);
    }

    @Test
    public void testRoundLang346() throws Exception {
        TimeZone.setDefault(this.defaultZone);
        this.dateTimeParser.setTimeZone(this.defaultZone);
        Calendar testCalendar = Calendar.getInstance();
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        Date date = testCalendar.getTime();
        Assert.assertEquals((String)"Minute Round Up Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:09:00.000"), (Object)DateUtils.round((Date)date, (int)12));
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Minute No Round Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:08:00.000"), (Object)DateUtils.round((Date)date, (int)12));
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Second Round Up with 600 Milli Seconds Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:08:51.000"), (Object)DateUtils.round((Date)date, (int)13));
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Second Round Down with 200 Milli Seconds Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:08:50.000"), (Object)DateUtils.round((Date)date, (int)13));
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 600);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Second Round Up with 200 Milli Seconds Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:08:21.000"), (Object)DateUtils.round((Date)date, (int)13));
        testCalendar.set(2007, 6, 2, 8, 8, 20);
        testCalendar.set(14, 200);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Second Round Down with 200 Milli Seconds Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:08:20.000"), (Object)DateUtils.round((Date)date, (int)13));
        testCalendar.set(2007, 6, 2, 8, 8, 50);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Hour Round Down Failed", (Object)this.dateTimeParser.parse("July 2, 2007 08:00:00.000"), (Object)DateUtils.round((Date)date, (int)10));
        testCalendar.set(2007, 6, 2, 8, 31, 50);
        date = testCalendar.getTime();
        Assert.assertEquals((String)"Hour Round Up Failed", (Object)this.dateTimeParser.parse("July 2, 2007 09:00:00.000"), (Object)DateUtils.round((Date)date, (int)10));
    }

    @Test
    public void testTruncate() throws Exception {
        Assert.assertEquals((String)"truncate year-1 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1));
        Assert.assertEquals((String)"truncate year-2 failed", (Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1));
        Assert.assertEquals((String)"truncate month-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)2));
        Assert.assertEquals((String)"truncate month-2 failed", (Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)2));
        Assert.assertEquals((String)"truncate semimonth-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)1001));
        Assert.assertEquals((String)"truncate semimonth-2 failed", (Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)1001));
        Assert.assertEquals((String)"truncate date-1 failed", (Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Date)this.date1, (int)5));
        Assert.assertEquals((String)"truncate date-2 failed", (Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Date)this.date2, (int)5));
        Assert.assertEquals((String)"truncate hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)10));
        Assert.assertEquals((String)"truncate hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)10));
        Assert.assertEquals((String)"truncate minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Date)this.date1, (int)12));
        Assert.assertEquals((String)"truncate minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Date)this.date2, (int)12));
        Assert.assertEquals((String)"truncate second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Date)this.date1, (int)13));
        Assert.assertEquals((String)"truncate second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Date)this.date2, (int)13));
        Assert.assertEquals((String)"truncate ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"truncate ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"truncate ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"truncate ampm-4 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Date)this.dateAmPm4, (int)9));
        Assert.assertEquals((String)"truncate year-1 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1));
        Assert.assertEquals((String)"truncate year-2 failed", (Object)this.dateParser.parse("January 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1));
        Assert.assertEquals((String)"truncate month-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)2));
        Assert.assertEquals((String)"truncate month-2 failed", (Object)this.dateParser.parse("November 1, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)2));
        Assert.assertEquals((String)"truncate semimonth-1 failed", (Object)this.dateParser.parse("February 1, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)1001));
        Assert.assertEquals((String)"truncate semimonth-2 failed", (Object)this.dateParser.parse("November 16, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)1001));
        Assert.assertEquals((String)"truncate date-1 failed", (Object)this.dateParser.parse("February 12, 2002"), (Object)DateUtils.truncate((Object)this.date1, (int)5));
        Assert.assertEquals((String)"truncate date-2 failed", (Object)this.dateParser.parse("November 18, 2001"), (Object)DateUtils.truncate((Object)this.date2, (int)5));
        Assert.assertEquals((String)"truncate hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)10));
        Assert.assertEquals((String)"truncate hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:00:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)10));
        Assert.assertEquals((String)"truncate minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:00.000"), (Object)DateUtils.truncate((Object)this.date1, (int)12));
        Assert.assertEquals((String)"truncate minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:00.000"), (Object)DateUtils.truncate((Object)this.date2, (int)12));
        Assert.assertEquals((String)"truncate second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.date1, (int)13));
        Assert.assertEquals((String)"truncate second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.date2, (int)13));
        Assert.assertEquals((String)"truncate ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"truncate ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"truncate ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"truncate ampm-4 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.dateAmPm4, (int)9));
        Assert.assertEquals((String)"truncate calendar second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:56.000"), (Object)DateUtils.truncate((Object)this.cal1, (int)13));
        Assert.assertEquals((String)"truncate calendar second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:11.000"), (Object)DateUtils.truncate((Object)this.cal2, (int)13));
        Assert.assertEquals((String)"truncate ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm1, (int)9));
        Assert.assertEquals((String)"truncate ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 00:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm2, (int)9));
        Assert.assertEquals((String)"truncate ampm-3 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm3, (int)9));
        Assert.assertEquals((String)"truncate ampm-4 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.truncate((Object)this.calAmPm4, (int)9));
        try {
            DateUtils.truncate((Date)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.truncate((Calendar)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.truncate(null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.truncate((Object)"", (int)13);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        TimeZone.setDefault(this.zone);
        this.dateTimeParser.setTimeZone(this.zone);
        Assert.assertEquals((String)"truncate MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date3, (int)5));
        Assert.assertEquals((String)"truncate MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal3, (int)5));
        Assert.assertEquals((String)"truncate MET date across DST change-over", (Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Date)this.date8, (int)5));
        Assert.assertEquals((String)"truncate MET date across DST change-over", (Object)this.dateTimeParser.parse("October 26, 2003 00:00:00.000"), (Object)DateUtils.truncate((Object)this.cal8, (int)5));
        TimeZone.setDefault(this.defaultZone);
        this.dateTimeParser.setTimeZone(this.defaultZone);
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        try {
            DateUtils.truncate((Calendar)endCal, (int)5);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        endCal.set(1, 280000001);
        try {
            DateUtils.truncate((Calendar)endCal, (int)5);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.truncate((Calendar)endCal, (int)5);
        Assert.assertEquals((long)0L, (long)cal.get(10));
    }

    @Test
    public void testTruncateLang59() throws Exception {
        TimeZone MST_MDT = TimeZone.getTimeZone("MST7MDT");
        TimeZone.setDefault(MST_MDT);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        format.setTimeZone(MST_MDT);
        Date oct31_01MDT = new Date(1099206000000L);
        Date oct31MDT = new Date(oct31_01MDT.getTime() - 3600000L);
        Date oct31_01_02MDT = new Date(oct31_01MDT.getTime() + 120000L);
        Date oct31_01_02_03MDT = new Date(oct31_01_02MDT.getTime() + 3000L);
        Date oct31_01_02_03_04MDT = new Date(oct31_01_02_03MDT.getTime() + 4L);
        Assert.assertEquals((String)"Check 00:00:00.000", (Object)"2004-10-31 00:00:00.000 MDT", (Object)format.format(oct31MDT));
        Assert.assertEquals((String)"Check 01:00:00.000", (Object)"2004-10-31 01:00:00.000 MDT", (Object)format.format(oct31_01MDT));
        Assert.assertEquals((String)"Check 01:02:00.000", (Object)"2004-10-31 01:02:00.000 MDT", (Object)format.format(oct31_01_02MDT));
        Assert.assertEquals((String)"Check 01:02:03.000", (Object)"2004-10-31 01:02:03.000 MDT", (Object)format.format(oct31_01_02_03MDT));
        Assert.assertEquals((String)"Check 01:02:03.004", (Object)"2004-10-31 01:02:03.004 MDT", (Object)format.format(oct31_01_02_03_04MDT));
        Calendar gval = Calendar.getInstance();
        gval.setTime(new Date(oct31_01MDT.getTime()));
        gval.set(12, gval.get(12));
        Assert.assertEquals((String)"Demonstrate Problem", (long)gval.getTime().getTime(), (long)(oct31_01MDT.getTime() + 3600000L));
        Assert.assertEquals((String)"Truncate Calendar.MILLISECOND", (Object)oct31_01_02_03_04MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)14));
        Assert.assertEquals((String)"Truncate Calendar.SECOND", (Object)oct31_01_02_03MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)13));
        Assert.assertEquals((String)"Truncate Calendar.MINUTE", (Object)oct31_01_02MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)12));
        Assert.assertEquals((String)"Truncate Calendar.HOUR_OF_DAY", (Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)11));
        Assert.assertEquals((String)"Truncate Calendar.HOUR", (Object)oct31_01MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)10));
        Assert.assertEquals((String)"Truncate Calendar.DATE", (Object)oct31MDT, (Object)DateUtils.truncate((Date)oct31_01_02_03_04MDT, (int)5));
        Assert.assertEquals((String)"Round Calendar.MILLISECOND", (Object)oct31_01_02_03_04MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)14));
        Assert.assertEquals((String)"Round Calendar.SECOND", (Object)oct31_01_02_03MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)13));
        Assert.assertEquals((String)"Round Calendar.MINUTE", (Object)oct31_01_02MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)12));
        Assert.assertEquals((String)"Round Calendar.HOUR_OF_DAY", (Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)11));
        Assert.assertEquals((String)"Round Calendar.HOUR", (Object)oct31_01MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)10));
        Assert.assertEquals((String)"Round Calendar.DATE", (Object)oct31MDT, (Object)DateUtils.round((Date)oct31_01_02_03_04MDT, (int)5));
        TimeZone.setDefault(this.defaultZone);
    }

    @Test
    public void testLang530() throws ParseException {
        Date d = new Date();
        String isoDateStr = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(d);
        Date d2 = DateUtils.parseDate((String)isoDateStr, (String[])new String[]{DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern()});
        Assert.assertEquals((String)"Date not equal to itself ISO formatted and parsed", (long)d.getTime(), (long)(d2.getTime() + d.getTime() % 1000L));
    }

    @Test
    public void testCeil() throws Exception {
        Assert.assertEquals((String)"ceiling javadoc-1 failed", (Object)this.dateTimeParser.parse("March 28, 2002 14:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)10));
        Assert.assertEquals((String)"ceiling javadoc-2 failed", (Object)this.dateTimeParser.parse("April 1, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateTimeParser.parse("March 28, 2002 13:45:01.231"), (int)2));
        Assert.assertEquals((String)"ceiling year-1 failed", (Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Date)this.date1, (int)1));
        Assert.assertEquals((String)"ceiling year-2 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Date)this.date2, (int)1));
        Assert.assertEquals((String)"ceiling month-1 failed", (Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)2));
        Assert.assertEquals((String)"ceiling month-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)2));
        Assert.assertEquals((String)"ceiling semimonth-1 failed", (Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)1001));
        Assert.assertEquals((String)"ceiling semimonth-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)1001));
        Assert.assertEquals((String)"ceiling date-1 failed", (Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Date)this.date1, (int)5));
        Assert.assertEquals((String)"ceiling date-2 failed", (Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Date)this.date2, (int)5));
        Assert.assertEquals((String)"ceiling hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)10));
        Assert.assertEquals((String)"ceiling hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)10));
        Assert.assertEquals((String)"ceiling minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)12));
        Assert.assertEquals((String)"ceiling minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)12));
        Assert.assertEquals((String)"ceiling second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Date)this.date1, (int)13));
        Assert.assertEquals((String)"ceiling second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Date)this.date2, (int)13));
        Assert.assertEquals((String)"ceiling ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"ceiling ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"ceiling ampm-3 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"ceiling ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.dateAmPm4, (int)9));
        Assert.assertEquals((String)"ceiling year-1 failed", (Object)this.dateParser.parse("January 1, 2003"), (Object)DateUtils.ceiling((Object)this.date1, (int)1));
        Assert.assertEquals((String)"ceiling year-2 failed", (Object)this.dateParser.parse("January 1, 2002"), (Object)DateUtils.ceiling((Object)this.date2, (int)1));
        Assert.assertEquals((String)"ceiling month-1 failed", (Object)this.dateParser.parse("March 1, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)2));
        Assert.assertEquals((String)"ceiling month-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)2));
        Assert.assertEquals((String)"ceiling semimonth-1 failed", (Object)this.dateParser.parse("February 16, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)1001));
        Assert.assertEquals((String)"ceiling semimonth-2 failed", (Object)this.dateParser.parse("December 1, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)1001));
        Assert.assertEquals((String)"ceiling date-1 failed", (Object)this.dateParser.parse("February 13, 2002"), (Object)DateUtils.ceiling((Object)this.date1, (int)5));
        Assert.assertEquals((String)"ceiling date-2 failed", (Object)this.dateParser.parse("November 19, 2001"), (Object)DateUtils.ceiling((Object)this.date2, (int)5));
        Assert.assertEquals((String)"ceiling hour-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 13:00:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)10));
        Assert.assertEquals((String)"ceiling hour-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 2:00:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)10));
        Assert.assertEquals((String)"ceiling minute-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:35:00.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)12));
        Assert.assertEquals((String)"ceiling minute-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:24:00.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)12));
        Assert.assertEquals((String)"ceiling second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.date1, (int)13));
        Assert.assertEquals((String)"ceiling second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.date2, (int)13));
        Assert.assertEquals((String)"ceiling ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm1, (int)9));
        Assert.assertEquals((String)"ceiling ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm2, (int)9));
        Assert.assertEquals((String)"ceiling ampm-3 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm3, (int)9));
        Assert.assertEquals((String)"ceiling ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.dateAmPm4, (int)9));
        Assert.assertEquals((String)"ceiling calendar second-1 failed", (Object)this.dateTimeParser.parse("February 12, 2002 12:34:57.000"), (Object)DateUtils.ceiling((Object)this.cal1, (int)13));
        Assert.assertEquals((String)"ceiling calendar second-2 failed", (Object)this.dateTimeParser.parse("November 18, 2001 1:23:12.000"), (Object)DateUtils.ceiling((Object)this.cal2, (int)13));
        Assert.assertEquals((String)"ceiling ampm-1 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm1, (int)9));
        Assert.assertEquals((String)"ceiling ampm-2 failed", (Object)this.dateTimeParser.parse("February 3, 2002 12:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm2, (int)9));
        Assert.assertEquals((String)"ceiling ampm-3 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm3, (int)9));
        Assert.assertEquals((String)"ceiling ampm-4 failed", (Object)this.dateTimeParser.parse("February 4, 2002 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.calAmPm4, (int)9));
        try {
            DateUtils.ceiling((Date)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.ceiling((Calendar)null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.ceiling(null, (int)13);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.ceiling((Object)"", (int)13);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        try {
            DateUtils.ceiling((Date)this.date1, (int)-9999);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TimeZone.setDefault(this.zone);
        this.dateTimeParser.setTimeZone(this.zone);
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 31, 2003 00:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)5));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date4, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal4, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Date)this.date5, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 03:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal5, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date6, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal6, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Date)this.date7, (int)11));
        Assert.assertEquals((String)"ceiling MET date across DST change-over", (Object)this.dateTimeParser.parse("March 30, 2003 04:00:00.000"), (Object)DateUtils.ceiling((Object)this.cal7, (int)11));
        TimeZone.setDefault(this.defaultZone);
        this.dateTimeParser.setTimeZone(this.defaultZone);
        Date endOfTime = new Date(Long.MAX_VALUE);
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(endOfTime);
        try {
            DateUtils.ceiling((Calendar)endCal, (int)5);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        endCal.set(1, 280000001);
        try {
            DateUtils.ceiling((Calendar)endCal, (int)5);
            Assert.fail();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        endCal.set(1, 280000000);
        Calendar cal = DateUtils.ceiling((Calendar)endCal, (int)5);
        Assert.assertEquals((long)0L, (long)cal.get(10));
    }

    @Test
    public void testIteratorEx() throws Exception {
        try {
            DateUtils.iterator((Calendar)Calendar.getInstance(), (int)-9999);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.iterator((Date)null, (int)4);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.iterator((Calendar)null, (int)4);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.iterator(null, (int)4);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DateUtils.iterator((Object)"", (int)4);
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testWeekIterator() throws Exception {
        Calendar now = Calendar.getInstance();
        for (int i = 0; i < 7; ++i) {
            Calendar today = DateUtils.truncate((Calendar)now, (int)5);
            Calendar sunday = DateUtils.truncate((Calendar)now, (int)5);
            sunday.add(5, 1 - sunday.get(7));
            Calendar monday = DateUtils.truncate((Calendar)now, (int)5);
            if (monday.get(7) == 1) {
                monday.add(5, -6);
            } else {
                monday.add(5, 2 - monday.get(7));
            }
            Calendar centered = DateUtils.truncate((Calendar)now, (int)5);
            centered.add(5, -3);
            Iterator it = DateUtils.iterator((Calendar)now, (int)1);
            DateUtilsTest.assertWeekIterator(it, sunday);
            it = DateUtils.iterator((Calendar)now, (int)2);
            DateUtilsTest.assertWeekIterator(it, monday);
            it = DateUtils.iterator((Calendar)now, (int)3);
            DateUtilsTest.assertWeekIterator(it, today);
            it = DateUtils.iterator((Calendar)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            it = DateUtils.iterator((Object)now, (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            it = DateUtils.iterator((Object)now.getTime(), (int)4);
            DateUtilsTest.assertWeekIterator(it, centered);
            try {
                it.next();
                Assert.fail();
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            it = DateUtils.iterator((Calendar)now, (int)4);
            it.next();
            try {
                it.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            now.add(5, 1);
        }
    }

    @Test
    public void testMonthIterator() throws Exception {
        Iterator it = DateUtils.iterator((Date)this.date1, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 27, 2002"), this.dateParser.parse("March 2, 2002"));
        it = DateUtils.iterator((Date)this.date1, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("January 28, 2002"), this.dateParser.parse("March 3, 2002"));
        it = DateUtils.iterator((Date)this.date2, (int)5);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 28, 2001"), this.dateParser.parse("December 1, 2001"));
        it = DateUtils.iterator((Date)this.date2, (int)6);
        DateUtilsTest.assertWeekIterator(it, this.dateParser.parse("October 29, 2001"), this.dateParser.parse("December 2, 2001"));
    }

    @SystemDefaults(locale="en")
    @Test
    public void testLANG799_EN_OK() throws ParseException {
        DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @SystemDefaults(locale="en")
    @Test(expected=ParseException.class)
    public void testLANG799_EN_FAIL() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @SystemDefaults(locale="de")
    @Test
    public void testLANG799_DE_OK() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
        DateUtils.parseDateStrictly((String)"Mi, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @SystemDefaults(locale="de")
    @Test(expected=ParseException.class)
    public void testLANG799_DE_FAIL() throws ParseException {
        DateUtils.parseDate((String)"Wed, 09 Apr 2008 23:55:38 GMT", (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    @SystemDefaults(locale="en")
    @Test
    public void testLANG799_EN_WITH_DE_LOCALE() throws ParseException {
        DateUtils.parseDate((String)"Mi, 09 Apr 2008 23:55:38 GMT", (Locale)Locale.GERMAN, (String[])new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz"});
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start) {
        Calendar end = (Calendar)start.clone();
        end.add(5, 6);
        DateUtilsTest.assertWeekIterator(it, start, end);
    }

    private static void assertWeekIterator(Iterator<?> it, Date start, Date end) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(start);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(end);
        DateUtilsTest.assertWeekIterator(it, calStart, calEnd);
    }

    private static void assertWeekIterator(Iterator<?> it, Calendar start, Calendar end) {
        Calendar cal = (Calendar)it.next();
        DateUtilsTest.assertCalendarsEquals("", start, cal, 0L);
        Calendar last = null;
        int count = 1;
        while (it.hasNext()) {
            DateUtilsTest.assertCalendarsEquals("", cal, DateUtils.truncate((Calendar)cal, (int)5), 0L);
            last = cal;
            cal = (Calendar)it.next();
            ++count;
            last.add(5, 1);
            DateUtilsTest.assertCalendarsEquals("", last, cal, 0L);
        }
        if (count % 7 != 0) {
            throw new AssertionFailedError("There were " + count + " days in this iterator");
        }
        DateUtilsTest.assertCalendarsEquals("", end, cal, 0L);
    }

    private static void assertCalendarsEquals(String message, Calendar cal1, Calendar cal2, long delta) {
        if (Math.abs(cal1.getTime().getTime() - cal2.getTime().getTime()) > delta) {
            throw new AssertionFailedError(message + " expected " + cal1.getTime() + " but got " + cal2.getTime());
        }
    }

    @Test
    public void testLANG799() throws ParseException {
        DateUtils.parseDateStrictly((String)"09 abril 2008 23:55:38 GMT", (Locale)new Locale("es"), (String[])new String[]{"dd MMM yyyy HH:mm:ss zzz"});
    }
}

