/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractTestCase {
    protected File dir;
    protected File resultDir;
    private File archive;
    protected List<String> archiveList;
    protected ArchiveStreamFactory factory = new ArchiveStreamFactory();
    private static final boolean ON_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");

    @Before
    public void setUp() throws Exception {
        this.dir = AbstractTestCase.mkdir("dir");
        this.resultDir = AbstractTestCase.mkdir("dir-result");
        this.archive = null;
    }

    public static File mkdir(String name) throws IOException {
        return Files.createTempDirectory(name, new FileAttribute[0]).toFile();
    }

    public static File getFile(String path) throws IOException {
        URL url = AbstractTestCase.class.getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("couldn't find " + path);
        }
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        return new File(uri);
    }

    @After
    public void tearDown() throws Exception {
        AbstractTestCase.rmdir(this.dir);
        AbstractTestCase.rmdir(this.resultDir);
        this.resultDir = null;
        this.dir = null;
        if (!AbstractTestCase.tryHardToDelete(this.archive)) {
            throw new Exception("Could not delete " + this.archive.getPath());
        }
    }

    public static void rmdir(File f) {
        String[] s = f.list();
        if (s != null) {
            for (String element : s) {
                boolean ok;
                File file = new File(f, element);
                if (file.isDirectory()) {
                    AbstractTestCase.rmdir(file);
                }
                if ((ok = AbstractTestCase.tryHardToDelete(file)) || !file.exists()) continue;
                System.out.println("Failed to delete " + element + " in " + f.getPath());
            }
        }
        AbstractTestCase.tryHardToDelete(f);
        if (f.exists()) {
            throw new Error("Failed to delete " + f.getPath());
        }
    }

    public static boolean tryHardToDelete(File f) {
        if (f != null && f.exists() && !f.delete()) {
            if (ON_WINDOWS) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return f.delete();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createArchive(String archivename) throws Exception {
        ArchiveOutputStream out = null;
        OutputStream stream = null;
        try {
            this.archive = File.createTempFile("test", "." + archivename);
            this.archive.deleteOnExit();
            this.archiveList = new ArrayList<String>();
            stream = new FileOutputStream(this.archive);
            out = this.factory.createArchiveOutputStream(archivename, stream);
            File file1 = AbstractTestCase.getFile("test1.xml");
            File file2 = AbstractTestCase.getFile("test2.xml");
            File file3 = AbstractTestCase.getFile("test3.xml");
            File file4 = AbstractTestCase.getFile("test4.xml");
            File file5 = AbstractTestCase.getFile("test.txt");
            File file6 = AbstractTestCase.getFile("test with spaces.txt");
            this.addArchiveEntry(out, "testdata/test1.xml", file1);
            this.addArchiveEntry(out, "testdata/test2.xml", file2);
            this.addArchiveEntry(out, "test/test3.xml", file3);
            this.addArchiveEntry(out, "bla/test4.xml", file4);
            this.addArchiveEntry(out, "bla/test5.xml", file4);
            this.addArchiveEntry(out, "bla/blubber/test6.xml", file4);
            this.addArchiveEntry(out, "test.txt", file5);
            this.addArchiveEntry(out, "something/bla", file6);
            this.addArchiveEntry(out, "test with spaces.txt", file6);
            out.finish();
            File file = this.archive;
            return file;
        }
        finally {
            if (out != null) {
                out.close();
            } else if (stream != null) {
                stream.close();
            }
        }
    }

    private void addArchiveEntry(ArchiveOutputStream out, String filename, File infile) throws IOException, FileNotFoundException {
        ArchiveEntry entry = out.createArchiveEntry(infile, filename);
        out.putArchiveEntry(entry);
        IOUtils.copy((InputStream)new FileInputStream(infile), (OutputStream)out);
        out.closeArchiveEntry();
        this.archiveList.add(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createEmptyArchive(String archivename) throws Exception {
        ArchiveOutputStream out = null;
        OutputStream stream = null;
        this.archiveList = new ArrayList<String>();
        try {
            this.archive = File.createTempFile("empty", "." + archivename);
            this.archive.deleteOnExit();
            stream = new FileOutputStream(this.archive);
            out = this.factory.createArchiveOutputStream(archivename, stream);
            out.finish();
        }
        finally {
            if (out != null) {
                out.close();
            } else if (stream != null) {
                stream.close();
            }
        }
        return this.archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File createSingleEntryArchive(String archivename) throws Exception {
        ArchiveOutputStream out = null;
        OutputStream stream = null;
        this.archiveList = new ArrayList<String>();
        try {
            this.archive = File.createTempFile("empty", "." + archivename);
            this.archive.deleteOnExit();
            stream = new FileOutputStream(this.archive);
            out = this.factory.createArchiveOutputStream(archivename, stream);
            this.addArchiveEntry(out, "test1.xml", AbstractTestCase.getFile("test1.xml"));
            out.finish();
        }
        finally {
            if (out != null) {
                out.close();
            } else if (stream != null) {
                stream.close();
            }
        }
        return this.archive;
    }

    protected void checkArchiveContent(File archive, List<String> expected) throws Exception {
        try (FileInputStream is = new FileInputStream(archive);){
            BufferedInputStream buf = new BufferedInputStream(is);
            ArchiveInputStream in = this.factory.createArchiveInputStream((InputStream)buf);
            this.checkArchiveContent(in, expected);
        }
    }

    protected void checkArchiveContent(ArchiveInputStream in, List<String> expected) throws Exception {
        this.checkArchiveContent(in, expected, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File checkArchiveContent(ArchiveInputStream in, List<String> expected, boolean cleanUp) throws Exception {
        File result = AbstractTestCase.mkdir("dir-result");
        result.deleteOnExit();
        try {
            ArchiveEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                File outfile = new File(result.getCanonicalPath() + "/result/" + entry.getName());
                long copied = 0L;
                if (entry.isDirectory()) {
                    outfile.mkdirs();
                } else {
                    outfile.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(outfile);){
                        copied = IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                }
                long size = entry.getSize();
                if (size != -1L) {
                    Assert.assertEquals((String)"Entry.size should equal bytes read.", (long)size, (long)copied);
                }
                if (!outfile.exists()) {
                    Assert.fail((String)("extraction failed: " + entry.getName()));
                }
                if (expected == null || expected.remove(this.getExpectedString(entry))) continue;
                Assert.fail((String)("unexpected entry: " + this.getExpectedString(entry)));
            }
            in.close();
            if (expected != null && expected.size() > 0) {
                Assert.fail((String)(expected.size() + " missing entries: " + Arrays.toString(expected.toArray())));
            }
            if (expected != null) {
                Assert.assertEquals((long)0L, (long)expected.size());
            }
        }
        finally {
            if (cleanUp) {
                AbstractTestCase.rmdir(result);
            }
        }
        return result;
    }

    protected String getExpectedString(ArchiveEntry entry) {
        return entry.getName();
    }

    protected File[] createTempDirAndFile() throws IOException {
        File tmpDir = this.createTempDir();
        File tmpFile = File.createTempFile("testfile", "", tmpDir);
        tmpFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tmpFile);){
            fos.write(new byte[]{102, 111, 111});
            File[] fileArray = new File[]{tmpDir, tmpFile};
            return fileArray;
        }
    }

    protected File createTempDir() throws IOException {
        File tmpDir = AbstractTestCase.mkdir("testdir");
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    protected void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected static interface StreamWrapper<I extends InputStream> {
        public I wrap(InputStream var1) throws Exception;
    }
}

