/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.dump.ShortFileException;
import org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class DumpArchiveInputStreamTest
extends AbstractTestCase {
    @Test
    public void testNotADumpArchive() throws Exception {
        try (FileInputStream is = new FileInputStream(DumpArchiveInputStreamTest.getFile("bla.zip"));){
            new DumpArchiveInputStream((InputStream)is).close();
            Assert.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof ShortFileException));
        }
    }

    @Test
    public void testNotADumpArchiveButBigEnough() throws Exception {
        try (FileInputStream is = new FileInputStream(DumpArchiveInputStreamTest.getFile("zip64support.tar.bz2"));){
            new DumpArchiveInputStream((InputStream)is).close();
            Assert.fail((String)"expected an exception");
        }
        catch (ArchiveException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof UnrecognizedFormatException));
        }
    }

    @Test
    public void testConsumesArchiveCompletely() throws Exception {
        InputStream is = DumpArchiveInputStreamTest.class.getResourceAsStream("/archive_with_trailer.dump");
        DumpArchiveInputStream dump = new DumpArchiveInputStream(is);
        while (dump.getNextDumpEntry() != null) {
        }
        byte[] expected = new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10};
        byte[] actual = new byte[expected.length];
        is.read(actual);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        dump.close();
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        try (FileInputStream in = new FileInputStream(DumpArchiveInputStreamTest.getFile("bla.dump"));
             DumpArchiveInputStream archive = new DumpArchiveInputStream((InputStream)in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read());
            Assert.assertEquals((long)-1L, (long)archive.read());
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws Exception {
        byte[] buf = new byte[2];
        try (FileInputStream in = new FileInputStream(DumpArchiveInputStreamTest.getFile("bla.dump"));
             DumpArchiveInputStream archive = new DumpArchiveInputStream((InputStream)in);){
            DumpArchiveEntry e = archive.getNextEntry();
            IOUtils.toByteArray((InputStream)archive);
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
            Assert.assertEquals((long)-1L, (long)archive.read(buf));
        }
    }
}

