/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedArchiverTest
extends AbstractTestCase {
    private final String format;
    private File target;

    @Parameterized.Parameters(name="format={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"tar"}, {"cpio"}, {"zip"});
    }

    public ParameterizedArchiverTest(String format) {
        this.format = format;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File c = new File(this.dir, "a/b/c");
        c.mkdirs();
        try (OutputStream os = Files.newOutputStream(new File(this.dir, "a/b/d.txt").toPath(), new OpenOption[0]);){
            os.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
        }
        os = Files.newOutputStream(new File(this.dir, "a/b/c/e.txt").toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            os.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var3_3 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        this.target = new File(this.resultDir, "test." + this.format);
    }

    @Test
    public void fileVersion() throws IOException, ArchiveException {
        new Archiver().create(this.format, this.target, this.dir);
        this.verifyContent();
    }

    @Test
    public void outputStreamVersion() throws IOException, ArchiveException {
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);){
            new Archiver().create(this.format, os, this.dir);
        }
        this.verifyContent();
    }

    @Test
    public void channelVersion() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create(this.format, (SeekableByteChannel)c, this.dir);
        }
        this.verifyContent();
    }

    @Test
    public void archiveStreamVersion() throws IOException, ArchiveException {
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);
             ArchiveOutputStream aos = new ArchiveStreamFactory().createArchiveOutputStream(this.format, os);){
            new Archiver().create(aos, this.dir);
        }
        this.verifyContent();
    }

    private void verifyContent() throws IOException, ArchiveException {
        try (InputStream is = Files.newInputStream(this.target.toPath(), new OpenOption[0]);
             BufferedInputStream bis = new BufferedInputStream(is);
             ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream(this.format, (InputStream)bis);){
            this.assertDir("a", ais.getNextEntry());
            this.assertDir("a/b", ais.getNextEntry());
            ArchiveEntry n = ais.getNextEntry();
            Assert.assertNotNull((Object)n);
            if (n.getName().endsWith("/")) {
                this.assertDir("a/b/c", n);
                this.assertHelloWorld("a/b/c/e.txt", "2", ais.getNextEntry(), (InputStream)ais);
                this.assertHelloWorld("a/b/d.txt", "1", ais.getNextEntry(), (InputStream)ais);
            } else {
                this.assertHelloWorld("a/b/d.txt", "1", n, (InputStream)ais);
                this.assertDir("a/b/c", ais.getNextEntry());
                this.assertHelloWorld("a/b/c/e.txt", "2", ais.getNextEntry(), (InputStream)ais);
            }
        }
    }

    private void assertDir(String expectedName, ArchiveEntry entry) {
        Assert.assertNotNull((String)(expectedName + " does not exists"), (Object)entry);
        Assert.assertEquals((Object)(expectedName + "/"), (Object)entry.getName());
        Assert.assertTrue((String)(expectedName + " is not a directory"), (boolean)entry.isDirectory());
    }

    private void assertHelloWorld(String expectedName, String suffix, ArchiveEntry entry, InputStream is) throws IOException {
        Assert.assertNotNull((String)(expectedName + " does not exists"), (Object)entry);
        Assert.assertEquals((Object)expectedName, (Object)entry.getName());
        Assert.assertFalse((String)(expectedName + " is a directory"), (boolean)entry.isDirectory());
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = IOUtils.toByteArray((InputStream)is);
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

