/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.crypto.Cipher;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.PasswordRequiredException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZFileOptions;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.MultiReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Test;

public class SevenZFileTest
extends AbstractTestCase {
    private static final String TEST2_CONTENT = "<?xml version = '1.0'?>\r\n<!DOCTYPE connections>\r\n<meinxml>\r\n\t<leer />\r\n</meinxml>\n";

    @Test
    public void testRandomlySkippingEntries() throws Exception {
        SevenZArchiveEntry entry;
        HashMap<String, byte[]> entriesByName = new HashMap<String, byte[]>();
        SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("COMPRESS-320/Copy.7z"));
        while ((entry = archive.getNextEntry()) != null) {
            if (!entry.hasStream()) continue;
            entriesByName.put(entry.getName(), this.readFully(archive));
        }
        archive.close();
        String[] variants = new String[]{"BZip2-solid.7z", "BZip2.7z", "Copy-solid.7z", "Copy.7z", "Deflate-solid.7z", "Deflate.7z", "LZMA-solid.7z", "LZMA.7z", "LZMA2-solid.7z", "LZMA2.7z"};
        Random rnd = new Random(-559038737L);
        for (String fileName : variants) {
            archive = new SevenZFile(SevenZFileTest.getFile("COMPRESS-320/" + fileName));
            while ((entry = archive.getNextEntry()) != null) {
                if (rnd.nextBoolean() || !entry.hasStream()) continue;
                Assert.assertTrue((boolean)entriesByName.containsKey(entry.getName()));
                byte[] content = this.readFully(archive);
                Assert.assertTrue((String)("Content mismatch on: " + fileName + "!" + entry.getName()), (boolean)Arrays.equals(content, (byte[])entriesByName.get(entry.getName())));
            }
            archive.close();
        }
    }

    private byte[] readFully(SevenZFile archive) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        while ((len = archive.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    @Test
    public void testAllEmptyFilesArchive() throws Exception {
        try (SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("7z-empty-mhc-off.7z"));){
            Assert.assertNotNull((Object)archive.getNextEntry());
        }
    }

    @Test
    public void testHelloWorldHeaderCompressionOffCopy() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-copy.7z");
    }

    @Test
    public void testHelloWorldHeaderCompressionOffLZMA2() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-lzma2.7z");
    }

    @Test
    public void test7zUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.7z"), SevenZMethod.LZMA);
    }

    @Test
    public void test7zDeflateUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.deflate.7z"), SevenZMethod.DEFLATE);
    }

    @Test
    public void test7zDeflate64Unarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.deflate64.7z"), SevenZMethod.DEFLATE64);
    }

    @Test
    public void test7zDecryptUnarchive() throws Exception {
        if (SevenZFileTest.isStrongCryptoAvailable()) {
            this.test7zUnarchive(SevenZFileTest.getFile("bla.encrypted.7z"), SevenZMethod.LZMA, "foo".getBytes("UTF-16LE"));
        }
    }

    @Test
    public void test7zDecryptUnarchiveUsingCharArrayPassword() throws Exception {
        if (SevenZFileTest.isStrongCryptoAvailable()) {
            this.test7zUnarchive(SevenZFileTest.getFile("bla.encrypted.7z"), SevenZMethod.LZMA, "foo".toCharArray());
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m) throws Exception {
        this.test7zUnarchive(f, m, (char[])null);
    }

    @Test
    public void testEncryptedArchiveRequiresPassword() throws Exception {
        try {
            new SevenZFile(SevenZFileTest.getFile("bla.encrypted.7z")).close();
            Assert.fail((String)"shouldn't decrypt without a password");
        }
        catch (PasswordRequiredException ex) {
            String msg = ex.getMessage();
            Assert.assertTrue((String)"Should start with whining about being unable to decrypt", (boolean)msg.startsWith("Cannot read encrypted content from "));
            Assert.assertTrue((String)"Should finish the sentence properly", (boolean)msg.endsWith(" without a password."));
            Assert.assertTrue((String)"Should contain archive's name", (boolean)msg.contains("bla.encrypted.7z"));
        }
    }

    @Test
    public void testCompressedHeaderWithNonDefaultDictionarySize() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            int count = 0;
            while (sevenZFile.getNextEntry() != null) {
                ++count;
            }
            Assert.assertEquals((long)446L, (long)count);
        }
    }

    @Test
    public void testSignatureCheck() {
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)SevenZFile.sevenZSignature.length));
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length + 1)));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length - 1)));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (int)6));
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 28}, (int)6));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 29}, (int)6));
    }

    @Test
    public void testReadingBackLZMA2DictSize() throws Exception {
        SevenZArchiveEntry entry;
        File output = new File(this.dir, "lzma2-dictsize.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
            entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        var3_3 = null;
        try (SevenZFile archive = new SevenZFile(output);){
            entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)m.getMethod());
            Assert.assertEquals((Object)0x100000, (Object)m.getOptions());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadingBackDeltaDistance() throws Exception {
        SevenZArchiveEntry entry;
        File output = new File(this.dir, "delta-distance.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER, (Object)32), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
            entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        var3_3 = null;
        try (SevenZFile archive = new SevenZFile(output);){
            entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            Assert.assertEquals((Object)SevenZMethod.DELTA_FILTER, (Object)m.getMethod());
            Assert.assertEquals((Object)32, (Object)m.getOptions());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void getEntriesOfUnarchiveTest() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"));){
            Iterable entries = sevenZFile.getEntries();
            Iterator iter = entries.iterator();
            SevenZArchiveEntry entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void getEntriesOfUnarchiveInMemoryTest() throws IOException {
        byte[] data = null;
        try (FileInputStream fis = new FileInputStream(SevenZFileTest.getFile("bla.7z"));){
            data = IOUtils.toByteArray((InputStream)fis);
        }
        var3_3 = null;
        try (SevenZFile sevenZFile = new SevenZFile((SeekableByteChannel)new SeekableInMemoryByteChannel(data));){
            Iterable entries = sevenZFile.getEntries();
            Iterator iter = entries.iterator();
            SevenZArchiveEntry entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
            Assert.assertFalse((boolean)iter.hasNext());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void readEntriesOfSize0() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-348.7z"));){
            int entries = 0;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            while (entry != null) {
                ++entries;
                int b = sevenZFile.read();
                if ("2.txt".equals(entry.getName()) || "5.txt".equals(entry.getName())) {
                    Assert.assertEquals((long)-1L, (long)b);
                } else {
                    Assert.assertNotEquals((long)-1L, (long)b);
                }
                entry = sevenZFile.getNextEntry();
            }
            Assert.assertEquals((long)5L, (long)entries);
        }
    }

    @Test(expected=MemoryLimitException.class)
    public void limitExtractionMemory() throws IOException {
        SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"), SevenZFileOptions.builder().withMaxMemoryLimitInKb(1).build());
        Throwable throwable = null;
        if (sevenZFile != null) {
            if (throwable != null) {
                try {
                    sevenZFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                sevenZFile.close();
            }
        }
    }

    @Test
    public void test7zMultiVolumeUnarchive() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(MultiReadOnlySeekableByteChannel.forFiles((File[])new File[]{SevenZFileTest.getFile("bla-multi.7z.001"), SevenZFileTest.getFile("bla-multi.7z.002")}));){
            this.test7zUnarchive(sevenZFile, SevenZMethod.LZMA2);
        }
    }

    @Test
    public void getDefaultNameWorksAsExpected() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.deflate64.7z"));){
            Assert.assertEquals((Object)"bla.deflate64", (Object)sevenZFile.getDefaultName());
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]));
        var2_2 = null;
        try {
            Assert.assertNull((Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]), "foo");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)"foo~", (Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]), ".foo");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)".foo~", (Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
    }

    @Test
    public void noNameMeansNoNameByDefault() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla-nonames.7z"));){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertNull((Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertNull((Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    @Test
    public void noNameCanBeReplacedByDefaultName() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla-nonames.7z"), SevenZFileOptions.builder().withUseDefaultNameForUnnamedEntries(true).build());){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"bla-nonames", (Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"bla-nonames", (Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    @Test
    public void givenNameWinsOverDefaultName() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"), SevenZFileOptions.builder().withUseDefaultNameForUnnamedEntries(true).build());){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"test1.xml", (Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"test2.xml", (Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m, byte[] password) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(f, password);){
            this.test7zUnarchive(sevenZFile, m);
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m, char[] password) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(f, password);){
            this.test7zUnarchive(sevenZFile, m);
        }
    }

    private void test7zUnarchive(SevenZFile sevenZFile, SevenZMethod m) throws Exception {
        int bytesRead;
        SevenZArchiveEntry entry = sevenZFile.getNextEntry();
        Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        Assert.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
        entry = sevenZFile.getNextEntry();
        Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
        Assert.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
        byte[] contents = new byte[(int)entry.getSize()];
        for (int off = 0; off < contents.length; off += bytesRead) {
            bytesRead = sevenZFile.read(contents, off, contents.length - off);
            assert (bytesRead >= 0);
        }
        Assert.assertEquals((Object)TEST2_CONTENT, (Object)new String(contents, "UTF-8"));
        Assert.assertNull((Object)sevenZFile.getNextEntry());
    }

    private void checkHelloWorld(String filename) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile(filename));){
            int bytesRead;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            Assert.assertEquals((Object)"Hello world.txt", (Object)entry.getName());
            byte[] contents = new byte[(int)entry.getSize()];
            for (int off = 0; off < contents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead >= 0);
            }
            Assert.assertEquals((Object)"Hello, world!\n", (Object)new String(contents, "UTF-8"));
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    private static boolean isStrongCryptoAvailable() throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength("AES/ECB/PKCS5Padding") >= 256;
    }
}

