/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import org.apache.commons.compress.archivers.tar.TarUtils;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.junit.Assert;
import org.junit.Test;

public class TarUtilsTest {
    @Test
    public void testName() {
        byte[] buff = new byte[20];
        String sb1 = "abcdefghijklmnopqrstuvwxyz";
        int off = TarUtils.formatNameBytes((String)"abcdefghijklmnopqrstuvwxyz", (byte[])buff, (int)1, (int)(buff.length - 1));
        Assert.assertEquals((long)off, (long)20L);
        String sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)10);
        Assert.assertEquals((Object)sb2, (Object)"abcdefghijklmnopqrstuvwxyz".substring(0, 10));
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)19);
        Assert.assertEquals((Object)sb2, (Object)"abcdefghijklmnopqrstuvwxyz".substring(0, 19));
        buff = new byte[30];
        off = TarUtils.formatNameBytes((String)"abcdefghijklmnopqrstuvwxyz", (byte[])buff, (int)1, (int)(buff.length - 1));
        Assert.assertEquals((long)off, (long)30L);
        sb2 = TarUtils.parseName((byte[])buff, (int)1, (int)(buff.length - 1));
        Assert.assertEquals((Object)"abcdefghijklmnopqrstuvwxyz", (Object)sb2);
        buff = new byte[]{0, 1, 0};
        sb2 = TarUtils.parseName((byte[])buff, (int)0, (int)3);
        Assert.assertEquals((Object)"", (Object)sb2);
    }

    @Test
    public void testParseOctal() throws Exception {
        long MAX_OCTAL = 0x1FFFFFFFFL;
        long MAX_OCTAL_OVERFLOW = 0xFFFFFFFFFL;
        String maxOctal = "777777777777";
        byte[] buffer = "777777777777".getBytes("UTF-8");
        long value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0xFFFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 32;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer[buffer.length - 1] = 0;
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0x1FFFFFFFFL, (long)value);
        buffer = new byte[]{0, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0L, (long)value);
        buffer = new byte[]{0, 32};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0L, (long)value);
        buffer = new byte[]{32, 0};
        value = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0L, (long)value);
    }

    @Test
    public void testParseOctalInvalid() throws Exception {
        byte[] buffer = new byte[]{};
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buffer = new byte[]{0};
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Expected IllegalArgumentException - should be at least 2 bytes long");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buffer = "abcdef ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buffer = " 0 07 ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Expected IllegalArgumentException - embedded space");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        buffer = " 0\u000007 ".getBytes("UTF-8");
        try {
            TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Expected IllegalArgumentException - embedded NUL");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkRoundTripOctal(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctal((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)value, (long)parseValue);
    }

    private void checkRoundTripOctal(long value) {
        this.checkRoundTripOctal(value, 12);
    }

    @Test
    public void testRoundTripOctal() {
        this.checkRoundTripOctal(0L);
        this.checkRoundTripOctal(1L);
        this.checkRoundTripOctal(0x1FFFFFFFFL);
        this.checkRoundTripOctal(0L, 8);
        this.checkRoundTripOctal(1L, 8);
        this.checkRoundTripOctal(0x1FFFFFL, 8);
    }

    private void checkRoundTripOctalOrBinary(long value, int bufsize) {
        byte[] buffer = new byte[bufsize];
        TarUtils.formatLongOctalOrBinaryBytes((long)value, (byte[])buffer, (int)0, (int)buffer.length);
        long parseValue = TarUtils.parseOctalOrBinary((byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)value, (long)parseValue);
    }

    @Test
    public void testRoundTripOctalOrBinary8() {
        this.testRoundTripOctalOrBinary(8);
    }

    @Test
    public void testRoundTripOctalOrBinary12() {
        this.testRoundTripOctalOrBinary(12);
        this.checkRoundTripOctalOrBinary(Long.MAX_VALUE, 12);
        this.checkRoundTripOctalOrBinary(-9223372036854775807L, 12);
    }

    private void testRoundTripOctalOrBinary(int length) {
        this.checkRoundTripOctalOrBinary(0L, length);
        this.checkRoundTripOctalOrBinary(1L, length);
        this.checkRoundTripOctalOrBinary(0x1FFFFFFFFL, length);
        this.checkRoundTripOctalOrBinary(-1L, length);
        this.checkRoundTripOctalOrBinary(0xFFFFFFFFFFFFFFL, length);
        this.checkRoundTripOctalOrBinary(-72057594037927935L, length);
    }

    @Test
    public void testTrailers() {
        byte[] buffer = new byte[12];
        TarUtils.formatLongOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)32L, (long)buffer[buffer.length - 1]);
        Assert.assertEquals((long)51L, (long)buffer[buffer.length - 2]);
        TarUtils.formatOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)0L, (long)buffer[buffer.length - 1]);
        Assert.assertEquals((long)32L, (long)buffer[buffer.length - 2]);
        Assert.assertEquals((long)51L, (long)buffer[buffer.length - 3]);
        TarUtils.formatCheckSumOctalBytes((long)123L, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((long)32L, (long)buffer[buffer.length - 1]);
        Assert.assertEquals((long)0L, (long)buffer[buffer.length - 2]);
        Assert.assertEquals((long)51L, (long)buffer[buffer.length - 3]);
    }

    @Test
    public void testNegative() throws Exception {
        byte[] buffer = new byte[22];
        TarUtils.formatUnsignedOctalString((long)-1L, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((Object)"1777777777777777777777", (Object)new String(buffer, "UTF-8"));
    }

    @Test
    public void testOverflow() throws Exception {
        byte[] buffer = new byte[7];
        TarUtils.formatUnsignedOctalString((long)0x1FFFFFL, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((Object)"7777777", (Object)new String(buffer, "UTF-8"));
        try {
            TarUtils.formatUnsignedOctalString((long)0x3FFFFFL, (byte[])buffer, (int)0, (int)buffer.length);
            Assert.fail((String)"Should have cause IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testRoundTripNames() {
        this.checkName("");
        this.checkName("The quick brown fox\n");
        this.checkName("\u007f");
    }

    @Test
    public void testRoundEncoding() throws Exception {
        ZipEncoding enc = ZipEncodingHelper.getZipEncoding((String)"ISO-8859-1");
        String s = "0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model";
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model", (byte[])buff, (int)0, (int)buff.length, (ZipEncoding)enc);
        Assert.assertEquals((Object)"0302-0601-3\u00b1\u00b1\u00b1F06\u00b1W220\u00b1ZB\u00b1LALALA\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1\u00b1CAN\u00b1\u00b1DC\u00b1\u00b1\u00b104\u00b1060302\u00b1MOE.model", (Object)TarUtils.parseName((byte[])buff, (int)0, (int)len, (ZipEncoding)enc));
    }

    private void checkName(String string) {
        byte[] buff = new byte[100];
        int len = TarUtils.formatNameBytes((String)string, (byte[])buff, (int)0, (int)buff.length);
        Assert.assertEquals((Object)string, (Object)TarUtils.parseName((byte[])buff, (int)0, (int)len));
    }

    @Test
    public void testReadNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        Assert.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }

    @Test
    public void testReadNegativeBinary12Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -15, -17};
        Assert.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)12));
    }

    @Test
    public void testWriteNegativeBinary8Byte() {
        byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -15, -17};
        Assert.assertEquals((long)-3601L, (long)TarUtils.parseOctalOrBinary((byte[])b, (int)0, (int)8));
    }

    @Test
    public void testVerifyHeaderCheckSum() {
        byte[] valid = new byte[]{116, 101, 115, 116, 49, 46, 120, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 48, 48, 48, 54, 52, 52, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 55, 54, 53, 0, 48, 48, 48, 48, 48, 48, 48, 49, 49, 52, 50, 0, 49, 48, 55, 49, 54, 53, 52, 53, 54, 50, 54, 0, 48, 49, 50, 50, 54, 48, 0, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 116, 97, 114, 32, 32, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 99, 117, 114, 100, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])valid));
        byte[] compress117 = new byte[]{55, 122, 67, 46, 116, 120, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 48, 48, 55, 55, 55, 32, 0, 32, 32, 32, 32, 32, 48, 32, 0, 32, 32, 32, 32, 32, 48, 32, 0, 32, 32, 32, 32, 32, 32, 49, 51, 48, 51, 51, 32, 49, 49, 49, 49, 53, 49, 54, 54, 48, 49, 54, 32, 32, 32, 53, 52, 49, 55, 32, 0, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Assert.assertTrue((boolean)TarUtils.verifyCheckSum((byte[])compress117));
        byte[] invalid = new byte[]{70, 79, 82, 77, 0, 0, 15, 46, 65, 73, 70, 70, 67, 79, 77, 77, 0, 0, 0, 18, 0, 2, 0, 0, 3, -64, 0, 16, 64, 14, -84, 68, 0, 0, 0, 0, 0, 0, 83, 83, 78, 68, 0, 0, 15, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 1, -1, -2, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 1, -1, -1, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -1, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 2, -1, -2, 0, 2, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, -1, -1, 0, 1, 0, 0, 0, 0, -1, -1, 0, 2, -1, -2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        Assert.assertFalse((boolean)TarUtils.verifyCheckSum((byte[])invalid));
    }

    @Test
    public void testParseOctalCompress330() throws Exception {
        long expected = 32768L;
        byte[] buffer = new byte[]{32, 32, 32, 32, 32, 49, 48, 48, 48, 48, 48, 32};
        Assert.assertEquals((long)32768L, (long)TarUtils.parseOctalOrBinary((byte[])buffer, (int)0, (int)buffer.length));
    }

    @Test
    public void testRoundTripOctalOrBinary8_ValueTooBigForBinary() {
        try {
            this.checkRoundTripOctalOrBinary(Long.MAX_VALUE, 8);
            Assert.fail((String)"Should throw exception - value is too long to fit buffer of this len");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Value 9223372036854775807 is too large for 8 byte field.", (Object)e.getMessage());
        }
    }
}

