/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import org.apache.commons.compress.archivers.zip.ZipShort;
import org.junit.Assert;
import org.junit.Test;

public class ZipShortTest {
    @Test
    public void testToBytes() {
        ZipShort zs = new ZipShort(4660);
        byte[] result = zs.getBytes();
        Assert.assertEquals((String)"length getBytes", (long)2L, (long)result.length);
        Assert.assertEquals((String)"first byte getBytes", (long)52L, (long)result[0]);
        Assert.assertEquals((String)"second byte getBytes", (long)18L, (long)result[1]);
    }

    @Test
    public void testPut() {
        byte[] arr = new byte[3];
        ZipShort.putShort((int)4660, (byte[])arr, (int)1);
        Assert.assertEquals((String)"first byte getBytes", (long)52L, (long)arr[1]);
        Assert.assertEquals((String)"second byte getBytes", (long)18L, (long)arr[2]);
    }

    @Test
    public void testFromBytes() {
        byte[] val = new byte[]{52, 18};
        ZipShort zs = new ZipShort(val);
        Assert.assertEquals((String)"value from bytes", (long)4660L, (long)zs.getValue());
    }

    @Test
    public void testEquals() {
        ZipShort zs = new ZipShort(4660);
        ZipShort zs2 = new ZipShort(4660);
        ZipShort zs3 = new ZipShort(22136);
        Assert.assertTrue((String)"reflexive", (boolean)zs.equals((Object)zs));
        Assert.assertTrue((String)"works", (boolean)zs.equals((Object)zs2));
        Assert.assertTrue((String)"works, part two", (!zs.equals((Object)zs3) ? 1 : 0) != 0);
        Assert.assertTrue((String)"symmetric", (boolean)zs2.equals((Object)zs));
        Assert.assertTrue((String)"null handling", (!zs.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"non ZipShort handling", (!zs.equals((Object)new Integer(4660)) ? 1 : 0) != 0);
    }

    @Test
    public void testSign() {
        ZipShort zs = new ZipShort(new byte[]{-1, -1});
        Assert.assertEquals((long)65535L, (long)zs.getValue());
    }

    @Test
    public void testClone() {
        ZipShort s1 = new ZipShort(42);
        ZipShort s2 = (ZipShort)s1.clone();
        Assert.assertNotSame((Object)s1, (Object)s2);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.getValue(), (long)s2.getValue());
    }
}

