/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public final class FramedSnappyTestCase
extends AbstractTestCase {
    @Test
    public void testDefaultExtraction() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws IOException {
                return new FramedSnappyCompressorInputStream(is);
            }
        });
    }

    @Test
    public void testDefaultExtractionViaFactory() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream("snappy-framed", is);
            }
        });
    }

    @Test
    public void testDefaultExtractionViaFactoryAutodetection() throws Exception {
        this.testUnarchive(new AbstractTestCase.StreamWrapper<CompressorInputStream>(){

            @Override
            public CompressorInputStream wrap(InputStream is) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream(is);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUnarchive(AbstractTestCase.StreamWrapper<CompressorInputStream> wrapper) throws Exception {
        File input = FramedSnappyTestCase.getFile("bla.tar.sz");
        File output = new File(this.dir, "bla.tar");
        try (FileInputStream is = new FileInputStream(input);){
            CompressorInputStream in = wrapper.wrap(new BufferedInputStream(is));
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(output);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                Assert.assertEquals((long)995L, (long)in.getBytesRead());
            }
            finally {
                if (out != null) {
                    out.close();
                }
                in.close();
            }
        }
        File original = FramedSnappyTestCase.getFile("bla.tar");
        try (FileInputStream written = new FileInputStream(output);
             FileInputStream orig = new FileInputStream(original);){
            Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)written), (byte[])IOUtils.toByteArray((InputStream)orig));
        }
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.testRoundtrip(FramedSnappyTestCase.getFile("test.txt"));
        this.testRoundtrip(FramedSnappyTestCase.getFile("bla.tar"));
        this.testRoundtrip(FramedSnappyTestCase.getFile("COMPRESS-256.7z"));
    }

    @Test
    public void testRoundtripWithOneBigWrite() throws Exception {
        Throwable throwable;
        Random r = new Random();
        File input = new File(this.dir, "bigChunkTest");
        try (FileOutputStream fs = new FileOutputStream(input);){
            for (int i = 0; i < 131072; ++i) {
                fs.write(r.nextInt(256));
            }
        }
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".sz");
        try (FileInputStream is = new FileInputStream(input);){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(outputSz);
                 CompressorOutputStream sos2 = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", (OutputStream)os);){
                byte[] b = IOUtils.toByteArray((InputStream)is);
                sos2.write((int)b[0]);
                sos2.write(b, 1, b.length - 1);
            }
            catch (Throwable sos2) {
                throwable = sos2;
                throw sos2;
            }
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        is = new FileInputStream(input);
        var7_13 = null;
        try {
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", (InputStream)new FileInputStream(outputSz));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var7_13 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var7_13 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var7_13.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
    }

    private void testRoundtrip(File input) throws Exception {
        Throwable throwable;
        long start = System.currentTimeMillis();
        File outputSz = new File(this.dir, input.getName() + ".sz");
        try (FileInputStream is = new FileInputStream(input);){
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(outputSz);
                 CompressorOutputStream sos2 = new CompressorStreamFactory().createCompressorOutputStream("snappy-framed", (OutputStream)os);){
                IOUtils.copy((InputStream)is, (OutputStream)sos2);
            }
            catch (Throwable sos2) {
                throwable = sos2;
                throw sos2;
            }
        }
        System.err.println(input.getName() + " written, uncompressed bytes: " + input.length() + ", compressed bytes: " + outputSz.length() + " after " + (System.currentTimeMillis() - start) + "ms");
        is = new FileInputStream(input);
        var6_5 = null;
        try {
            throwable = null;
            try (CompressorInputStream sis = new CompressorStreamFactory().createCompressorInputStream("snappy-framed", (InputStream)new FileInputStream(outputSz));){
                byte[] expected = IOUtils.toByteArray((InputStream)is);
                byte[] actual = IOUtils.toByteArray((InputStream)sis);
                Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var6_5 = throwable3;
            throw throwable3;
        }
        finally {
            if (is != null) {
                if (var6_5 != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable4) {
                        var6_5.addSuppressed(throwable4);
                    }
                } else {
                    is.close();
                }
            }
        }
    }
}

