/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.junit.Assert;
import org.junit.Test;

public class BlockLZ4CompressorInputStreamTest
extends AbstractTestCase {
    @Test
    public void readBlaLz4() throws IOException {
        try (BlockLZ4CompressorInputStream a = new BlockLZ4CompressorInputStream((InputStream)new FileInputStream(BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4")));
             FileInputStream e = new FileInputStream(BlockLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        try (FileInputStream is = new FileInputStream(input);){
            BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = BlockLZ4CompressorInputStreamTest.getFile("bla.tar.block_lz4");
        byte[] buf = new byte[2];
        try (FileInputStream is = new FileInputStream(input);){
            BlockLZ4CompressorInputStream in = new BlockLZ4CompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }
}

