/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.lz4;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public final class FramedLZ4CompressorInputStreamTest
extends AbstractTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testMatches() throws IOException {
        Assert.assertFalse((boolean)FramedLZ4CompressorInputStream.matches((byte[])new byte[10], (int)4));
        byte[] b = new byte[12];
        File input = FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4");
        try (FileInputStream in = new FileInputStream(input);){
            IOUtils.readFully((InputStream)in, (byte[])b);
        }
        Assert.assertFalse((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)3));
        Assert.assertTrue((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)4));
        Assert.assertTrue((boolean)FramedLZ4CompressorInputStream.matches((byte[])b, (int)5));
    }

    @Test
    public void readBlaLz4() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4")));
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4ViaFactory() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), (InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4")));
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4ViaFactoryAutoDetection() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4"))));
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readBlaLz4WithDecompressConcatenated() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4")), true);
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readDoubledBlaLz4WithDecompressConcatenatedTrue() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new FramedLZ4CompressorInputStream(in, true);
            }
        }, true);
    }

    @Test
    public void readDoubledBlaLz4WithDecompressConcatenatedFalse() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new FramedLZ4CompressorInputStream(in, false);
            }
        }, false);
    }

    @Test
    public void readDoubledBlaLz4WithoutExplicitDecompressConcatenated() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new FramedLZ4CompressorInputStream(in);
            }
        }, false);
    }

    @Test
    public void readBlaLz4ViaFactoryWithDecompressConcatenated() throws Exception {
        try (CompressorInputStream a = new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), (InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4")), true);
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithDecompressConcatenatedTrue() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in, true);
            }
        }, true);
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithDecompressConcatenatedFalse() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in, false);
            }
        }, false);
    }

    @Test
    public void readDoubledBlaLz4ViaFactoryWithoutExplicitDecompressConcatenated() throws Exception {
        this.readDoubledBlaLz4(new StreamWrapper(){

            @Override
            public InputStream wrap(InputStream in) throws Exception {
                return new CompressorStreamFactory().createCompressorInputStream(CompressorStreamFactory.getLZ4Framed(), in);
            }
        }, false);
    }

    @Test
    public void readBlaDumpLz4() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.dump.lz4")));
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.dump"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
    }

    @Test(expected=IOException.class)
    public void rejectsNonLZ4Stream() throws IOException {
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar")));){
            Assert.fail((String)"expected exception");
        }
    }

    @Test
    public void rejectsFileWithoutFrameDescriptor() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"frame flags"));
        }
    }

    @Test
    public void rejectsFileWithoutBlockSizeByte() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 100};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"BD byte"));
        }
    }

    @Test
    public void rejectsFileWithWrongVersion() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 36};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"version"));
        }
    }

    @Test
    public void rejectsFileWithInsufficientContentSize() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 108, 112};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content size"));
        }
    }

    @Test
    public void rejectsFileWithoutHeaderChecksum() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"header checksum"));
        }
    }

    @Test
    public void rejectsFileWithBadHeaderChecksum() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"header checksum mismatch"));
        }
    }

    @Test
    public void readsUncompressedBlocks() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33}, (byte[])actual);
        }
    }

    @Test
    public void readsUncompressedBlocksUsingSingleByteRead() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            int h = a.read();
            Assert.assertEquals((long)72L, (long)h);
        }
    }

    @Test
    public void rejectsBlocksWithoutChecksum() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 112, 112, 114, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"block checksum"));
        }
    }

    @Test
    public void rejectsStreamsWithoutContentChecksum() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, -71, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content checksum"));
        }
    }

    @Test
    public void rejectsStreamsWithBadContentChecksum() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 100, 112, -71, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 1, 2, 3, 4};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input));){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"content checksum mismatch"));
        }
    }

    @Test
    public void skipsOverSkippableFrames() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 95, 42, 77, 24, 2, 0, 0, 0, 1, 2, 4, 34, 77, 24, 96, 112, 115, 1, 0, 0, -128, 33, 0, 0, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 33}, (byte[])actual);
        }
    }

    @Test
    public void skipsOverTrailingSkippableFrames() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 81, 42, 77, 24, 2, 0, 0, 0, 1, 2};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33}, (byte[])actual);
        }
    }

    @Test
    public void rejectsSkippableFrameFollowedByJunk() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 80, 42, 77, 24, 2, 0, 0, 0, 1, 2, 1, 34, 77, 24};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
        }
    }

    @Test
    public void rejectsSkippableFrameFollowedByTooFewBytes() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 82, 42, 77, 24, 2, 0, 0, 0, 1, 2, 4};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
        }
    }

    @Test
    public void rejectsSkippableFrameWithPrematureEnd() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 80, 42, 77, 24, 2, 0, 0, 0, 1};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Premature end of stream while skipping frame"));
        }
    }

    @Test
    public void rejectsSkippableFrameWithPrematureEndInLengthBytes() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 85, 42, 77, 24, 2, 0, 0};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Premature end of data"));
        }
    }

    @Test
    public void rejectsSkippableFrameWithBadSignatureTrailer() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 81, 42, 77, 23};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
        }
    }

    @Test
    public void rejectsSkippableFrameWithBadSignaturePrefix() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 96, 42, 77, 24};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
        }
    }

    @Test
    public void rejectsTrailingBytesAfterValidFrame() throws IOException {
        byte[] input = new byte[]{4, 34, 77, 24, 96, 112, 115, 13, 0, 0, -128, 72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 0, 0, 0, 0, 86, 42, 77};
        try (FramedLZ4CompressorInputStream a = new FramedLZ4CompressorInputStream((InputStream)new ByteArrayInputStream(input), true);){
            IOUtils.toByteArray((InputStream)a);
            Assert.fail((String)"expected exception");
        }
        catch (IOException ex) {
            Assert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"garbage"));
        }
    }

    @Test
    public void singleByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4");
        try (FileInputStream is = new FileInputStream(input);){
            FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read());
            Assert.assertEquals((long)-1L, (long)in.read());
            in.close();
        }
    }

    @Test
    public void multiByteReadConsistentlyReturnsMinusOneAtEof() throws IOException {
        File input = FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4");
        byte[] buf = new byte[2];
        try (FileInputStream is = new FileInputStream(input);){
            FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            Assert.assertEquals((long)-1L, (long)in.read(buf));
            in.close();
        }
    }

    @Test
    public void backreferenceOfSize0CausesIOException() throws IOException {
        this.expectIOException("COMPRESS-490/ArithmeticException.lz4");
    }

    @Test
    public void backreferenceAtStartCausesIOException() throws IOException {
        this.expectIOException("COMPRESS-490/ArrayIndexOutOfBoundsException1.lz4");
    }

    @Test
    public void backreferenceWithOffsetTooBigCausesIOException() throws IOException {
        this.expectIOException("COMPRESS-490/ArrayIndexOutOfBoundsException2.lz4");
    }

    private void readDoubledBlaLz4(StreamWrapper wrapper, boolean expectDuplicateOutput) throws Exception {
        byte[] singleInput;
        try (FileInputStream i = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar.lz4"));){
            singleInput = IOUtils.toByteArray((InputStream)i);
        }
        byte[] input = FramedLZ4CompressorInputStreamTest.duplicate(singleInput);
        try (InputStream a = wrapper.wrap(new ByteArrayInputStream(input));
             FileInputStream e = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile("bla.tar"));){
            byte[] expected = IOUtils.toByteArray((InputStream)e);
            byte[] actual = IOUtils.toByteArray((InputStream)a);
            Assert.assertArrayEquals((byte[])(expectDuplicateOutput ? FramedLZ4CompressorInputStreamTest.duplicate(expected) : expected), (byte[])actual);
        }
    }

    private static byte[] duplicate(byte[] from) {
        byte[] to = Arrays.copyOf(from, 2 * from.length);
        System.arraycopy(from, 0, to, from.length, from.length);
        return to;
    }

    private void expectIOException(String fileName) throws IOException {
        this.thrown.expect(IOException.class);
        try (FileInputStream is = new FileInputStream(FramedLZ4CompressorInputStreamTest.getFile(fileName));){
            FramedLZ4CompressorInputStream in = new FramedLZ4CompressorInputStream((InputStream)is);
            IOUtils.toByteArray((InputStream)in);
        }
    }

    static interface StreamWrapper {
        public InputStream wrap(InputStream var1) throws Exception;
    }
}

