/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Test;

public class SeekableInMemoryByteChannelTest {
    private final byte[] testData = "Some data".getBytes(Charset.forName("UTF-8"));

    @Test
    public void shouldReadContentsProperly() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
        int readCount = c.read(readBuffer);
        Assert.assertEquals((long)this.testData.length, (long)readCount);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])readBuffer.array());
        Assert.assertEquals((long)this.testData.length, (long)c.position());
        c.close();
    }

    @Test
    public void shouldReadContentsWhenBiggerBufferSupplied() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length + 1);
        int readCount = c.read(readBuffer);
        Assert.assertEquals((long)this.testData.length, (long)readCount);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(readBuffer.array(), this.testData.length));
        Assert.assertEquals((long)this.testData.length, (long)c.position());
        c.close();
    }

    @Test
    public void shouldReadDataFromSetPosition() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        ByteBuffer readBuffer = ByteBuffer.allocate(4);
        c.position(5L);
        int readCount = c.read(readBuffer);
        Assert.assertEquals((long)4L, (long)readCount);
        Assert.assertEquals((Object)"data", (Object)new String(readBuffer.array(), Charset.forName("UTF-8")));
        Assert.assertEquals((long)this.testData.length, (long)c.position());
        c.close();
    }

    @Test
    public void shouldSignalEOFWhenPositionAtTheEnd() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        ByteBuffer readBuffer = ByteBuffer.allocate(this.testData.length);
        c.position((long)(this.testData.length + 1));
        int readCount = c.read(readBuffer);
        Assert.assertEquals((long)0L, (long)readBuffer.position());
        Assert.assertEquals((long)-1L, (long)readCount);
        c.close();
    }

    @Test(expected=ClosedChannelException.class)
    public void shouldThrowExceptionOnReadingClosedChannel() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.close();
        c.read(ByteBuffer.allocate(1));
    }

    @Test
    public void shouldWriteDataProperly() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        ByteBuffer inData = ByteBuffer.wrap(this.testData);
        int writeCount = c.write(inData);
        Assert.assertEquals((long)this.testData.length, (long)writeCount);
        Assert.assertArrayEquals((byte[])this.testData, (byte[])Arrays.copyOf(c.array(), (int)c.size()));
        Assert.assertEquals((long)this.testData.length, (long)c.position());
        c.close();
    }

    @Test
    public void shouldWriteDataProperlyAfterPositionSet() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        ByteBuffer inData = ByteBuffer.wrap(this.testData);
        ByteBuffer expectedData = ByteBuffer.allocate(this.testData.length + 5).put(this.testData, 0, 5).put(this.testData);
        c.position(5L);
        int writeCount = c.write(inData);
        Assert.assertEquals((long)this.testData.length, (long)writeCount);
        Assert.assertArrayEquals((byte[])expectedData.array(), (byte[])Arrays.copyOf(c.array(), (int)c.size()));
        Assert.assertEquals((long)(this.testData.length + 5), (long)c.position());
        c.close();
    }

    @Test(expected=ClosedChannelException.class)
    public void shouldThrowExceptionOnWritingToClosedChannel() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.close();
        c.write(ByteBuffer.allocate(1));
    }

    @Test
    public void shouldTruncateContentsProperly() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        c.truncate(4L);
        byte[] bytes = Arrays.copyOf(c.array(), (int)c.size());
        Assert.assertEquals((Object)"Some", (Object)new String(bytes, Charset.forName("UTF-8")));
        c.close();
    }

    @Test
    public void shouldSetProperPositionOnTruncate() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        c.position((long)this.testData.length);
        c.truncate(4L);
        Assert.assertEquals((long)4L, (long)c.position());
        Assert.assertEquals((long)4L, (long)c.size());
        c.close();
    }

    @Test
    public void shouldSetProperPosition() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel(this.testData);
        long posAtFour = c.position(4L).position();
        long posAtTheEnd = c.position((long)this.testData.length).position();
        long posPastTheEnd = c.position((long)this.testData.length + 1L).position();
        Assert.assertEquals((long)4L, (long)posAtFour);
        Assert.assertEquals((long)c.size(), (long)posAtTheEnd);
        Assert.assertEquals((long)posPastTheEnd, (long)posPastTheEnd);
        c.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionWhenSettingIncorrectPosition() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.position(0x80000000L);
        c.close();
    }

    @Test(expected=ClosedChannelException.class)
    public void shouldThrowExceptionWhenSettingPositionOnClosedChannel() throws IOException {
        SeekableInMemoryByteChannel c = new SeekableInMemoryByteChannel();
        c.close();
        c.position(1L);
    }
}

