/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsListFilesTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    private File getLocalTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @Before
    public void setUp() throws Exception {
        File dir = this.getLocalTestDirectory();
        File file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "README");
        FileUtils.touch((File)file);
        dir = new File(dir, "subdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-build.xml");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-readme.txt");
        FileUtils.touch((File)file);
        dir = new File(dir, "subsubdir1");
        dir.mkdirs();
        file = new File(dir, "dummy-file.txt");
        FileUtils.touch((File)file);
        file = new File(dir, "dummy-index.html");
        FileUtils.touch((File)file);
        dir = dir.getParentFile();
        dir = new File(dir, "CVS");
        dir.mkdirs();
        file = new File(dir, "Entries");
        FileUtils.touch((File)file);
        file = new File(dir, "Repository");
        FileUtils.touch((File)file);
    }

    private Collection<String> filesToFilenames(Collection<File> files) {
        ArrayList<String> filenames = new ArrayList<String>(files.size());
        for (File file : files) {
            filenames.add(file.getName());
        }
        return filenames;
    }

    private Collection<String> filesToFilenames(Iterator<File> files) {
        ArrayList<String> filenames = new ArrayList<String>();
        while (files.hasNext()) {
            filenames.add(files.next().getName());
        }
        return filenames;
    }

    @Test
    public void testIterateFilesByExtension() throws Exception {
        String[] extensions = new String[]{"xml", "txt"};
        Iterator files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)false);
        Collection<String> filenames = this.filesToFilenames(files);
        Assert.assertEquals((long)1L, (long)filenames.size());
        Assert.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assert.assertFalse((boolean)filenames.contains("README"));
        Assert.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        Assert.assertEquals((long)4L, (long)filenames.size());
        Assert.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        Assert.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.iterateFiles((File)this.getLocalTestDirectory(), null, (boolean)false);
        filenames = this.filesToFilenames(files);
        Assert.assertEquals((long)2L, (long)filenames.size());
        Assert.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assert.assertTrue((boolean)filenames.contains("README"));
        Assert.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    @Test
    public void testListFilesByExtension() throws Exception {
        String[] extensions = new String[]{"xml", "txt"};
        Collection files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)false);
        Assert.assertEquals((long)1L, (long)files.size());
        Collection<String> filenames = this.filesToFilenames(files);
        Assert.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assert.assertFalse((boolean)filenames.contains("README"));
        Assert.assertFalse((boolean)filenames.contains("dummy-file.txt"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (String[])extensions, (boolean)true);
        filenames = this.filesToFilenames(files);
        Assert.assertEquals((long)4L, (long)filenames.size());
        Assert.assertTrue((boolean)filenames.contains("dummy-file.txt"));
        Assert.assertFalse((boolean)filenames.contains("dummy-index.html"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), null, (boolean)false);
        Assert.assertEquals((long)2L, (long)files.size());
        filenames = this.filesToFilenames(files);
        Assert.assertTrue((boolean)filenames.contains("dummy-build.xml"));
        Assert.assertTrue((boolean)filenames.contains("README"));
        Assert.assertFalse((boolean)filenames.contains("dummy-file.txt"));
    }

    @Test
    public void testListFiles() throws Exception {
        IOFileFilter fileFilter = FileFilterUtils.trueFileFilter();
        Collection files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, null);
        Collection<String> filenames = this.filesToFilenames(files);
        Assert.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        Assert.assertFalse((String)"'dummy-index.html' shouldn't be found", (boolean)filenames.contains("dummy-index.html"));
        Assert.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        IOFileFilter dirFilter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"CVS"));
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assert.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        Assert.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        Assert.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.makeCVSAware(null);
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assert.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        Assert.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        Assert.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        fileFilter = FileFilterUtils.trueFileFilter();
        dirFilter = FileFilterUtils.prefixFileFilter((String)"sub");
        dirFilter = FileFilterUtils.makeCVSAware((IOFileFilter)dirFilter);
        files = FileUtils.listFiles((File)this.getLocalTestDirectory(), (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
        filenames = this.filesToFilenames(files);
        Assert.assertTrue((String)"'dummy-build.xml' is missing", (boolean)filenames.contains("dummy-build.xml"));
        Assert.assertTrue((String)"'dummy-index.html' is missing", (boolean)filenames.contains("dummy-index.html"));
        Assert.assertFalse((String)"'Entries' shouldn't be found", (boolean)filenames.contains("Entries"));
        try {
            FileUtils.listFiles((File)this.getLocalTestDirectory(), null, null);
            Assert.fail((String)"Expected error about null parameter");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

