/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.XmlStreamReader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BOMInputStreamTest {
    private void assertData(byte[] expected, byte[] actual, int len) throws Exception {
        Assert.assertEquals((String)"length", (long)expected.length, (long)len);
        for (int ii = 0; ii < expected.length; ++ii) {
            Assert.assertEquals((String)("byte " + ii), (long)expected[ii], (long)actual[ii]);
        }
    }

    private InputStream createUtf16BeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 2];
            data[0] = -2;
            data[1] = -1;
            System.arraycopy(baseData, 0, data, 2, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf16LeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 2];
            data[0] = -1;
            data[1] = -2;
            System.arraycopy(baseData, 0, data, 2, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf32BeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 4];
            data[0] = 0;
            data[1] = 0;
            data[2] = -2;
            data[3] = -1;
            System.arraycopy(baseData, 0, data, 4, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf32LeDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 4];
            data[0] = -1;
            data[1] = -2;
            data[2] = 0;
            data[3] = 0;
            System.arraycopy(baseData, 0, data, 4, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private InputStream createUtf8DataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 3];
            data[0] = -17;
            data[1] = -69;
            data[2] = -65;
            System.arraycopy(baseData, 0, data, 3, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private void parseXml(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"X", (Object)doc.getFirstChild().getNodeName());
    }

    private void parseXml(Reader in) throws SAXException, IOException, ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"X", (Object)doc.getFirstChild().getNodeName());
    }

    private void readBOMInputStreamTwice(String resource) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream(resource);
        Assert.assertNotNull((Object)inputStream);
        BOMInputStream bomInputStream = new BOMInputStream(inputStream);
        bomInputStream.mark(1000000);
        this.readFile(bomInputStream);
        bomInputStream.reset();
        this.readFile(bomInputStream);
        inputStream.close();
        bomInputStream.close();
    }

    private void readFile(BOMInputStream bomInputStream) throws Exception {
        int bytes;
        byte[] bytesFromStream = new byte[100];
        while ((bytes = bomInputStream.read(bytesFromStream)) > 0) {
        }
    }

    @Test
    public void testAvailableWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        Assert.assertEquals((long)7L, (long)in.available());
        in.close();
    }

    @Test
    public void testAvailableWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertEquals((long)4L, (long)in.available());
        in.close();
    }

    @Test
    public void testClose() throws Exception {
        ExpectCloseInputStream del = new ExpectCloseInputStream();
        BOMInputStream in = new BOMInputStream((InputStream)del);
        in.close();
        del.assertCloseCalled();
        del.close();
    }

    @Test
    public void testEmptyBufferWithBOM() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        byte[] buf = new byte[1024];
        Assert.assertEquals((long)-1L, (long)in.read(buf));
        in.close();
    }

    @Test
    public void testEmptyBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        byte[] buf = new byte[1024];
        Assert.assertEquals((long)-1L, (long)in.read(buf));
        in.close();
    }

    @Test
    public void testGetBOMFirstThenRead() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        in.close();
    }

    @Test
    public void testGetBOMFirstThenReadInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true), true);
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        Assert.assertEquals((long)239L, (long)in.read());
        Assert.assertEquals((long)187L, (long)in.read());
        Assert.assertEquals((long)191L, (long)in.read());
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        in.close();
    }

    @Test
    public void testLargeBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
        in.close();
    }

    @Test
    public void testLargeBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
        in.close();
    }

    @Test
    public void testLeadingNonBOMBufferedRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
        in.close();
    }

    @Test
    public void testLeadingNonBOMSingleRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertEquals((long)239L, (long)in.read());
        Assert.assertEquals((long)171L, (long)in.read());
        Assert.assertEquals((long)205L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        in.close();
    }

    @Test
    public void testMarkResetAfterReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        Assert.assertTrue((boolean)in.markSupported());
        in.read();
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        Assert.assertEquals((long)66L, (long)in.read());
        in.close();
    }

    @Test
    public void testMarkResetAfterReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertTrue((boolean)in.markSupported());
        in.read();
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        Assert.assertEquals((long)66L, (long)in.read());
        in.close();
    }

    @Test
    public void testMarkResetBeforeReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        Assert.assertTrue((boolean)in.markSupported());
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        Assert.assertEquals((long)65L, (long)in.read());
        in.close();
    }

    @Test
    public void testMarkResetBeforeReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertTrue((boolean)in.markSupported());
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        Assert.assertEquals((long)65L, (long)in.read());
        in.close();
    }

    @Test
    public void testNoBoms() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try {
            new BOMInputStream(this.createUtf8DataStream(data, true), false, (ByteOrderMark[])null).close();
            Assert.fail((String)"Null BOMs, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new BOMInputStream(this.createUtf8DataStream(data, true), false, new ByteOrderMark[0]).close();
            Assert.fail((String)"Null BOMs, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReadEmpty() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertNull((String)"getBOM", (Object)in.getBOM());
        in.close();
    }

    @Test
    public void testReadSmall() throws Exception {
        byte[] data = new byte[]{65, 66};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertNull((String)"getBOM", (Object)in.getBOM());
        in.close();
    }

    @Test
    public void testReadTwiceWithBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileBOM.xml");
    }

    @Test
    public void testReadTwiceWithoutBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileNoBOM.xml");
    }

    @Test
    public void testReadWithBOMInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true), true);
        Assert.assertEquals((long)239L, (long)in.read());
        Assert.assertEquals((long)187L, (long)in.read());
        Assert.assertEquals((long)191L, (long)in.read());
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        in.close();
    }

    @Test
    public void testReadWithBOMUtf16Be() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_16BE);
        BOMInputStream in = new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE});
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-16BE)", (boolean)in.hasBOM(ByteOrderMark.UTF_16BE));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_16BE, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_16LE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadWithBOMUtf16Le() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_16LE);
        BOMInputStream in = new BOMInputStream(this.createUtf16LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16LE});
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-16LE)", (boolean)in.hasBOM(ByteOrderMark.UTF_16LE));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_16LE, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_16BE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadWithBOMUtf32Be() throws Exception {
        Assume.assumeTrue((boolean)Charset.isSupported("UTF_32BE"));
        byte[] data = "ABC".getBytes("UTF_32BE");
        BOMInputStream in = new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE});
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-32BE)", (boolean)in.hasBOM(ByteOrderMark.UTF_32BE));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_32BE, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_32LE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadWithBOMUtf32Le() throws Exception {
        Assume.assumeTrue((boolean)Charset.isSupported("UTF_32LE"));
        byte[] data = "ABC".getBytes("UTF_32LE");
        BOMInputStream in = new BOMInputStream(this.createUtf32LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32LE});
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)0L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-32LE)", (boolean)in.hasBOM(ByteOrderMark.UTF_32LE));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_32LE, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_32BE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadWithBOMUtf8() throws Exception {
        byte[] data = "ABC".getBytes(StandardCharsets.UTF_8);
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_8});
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_16BE);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        in.close();
    }

    @Test
    public void testReadWithMultipleBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_8});
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertFalse((String)"hasBOM(UTF-16BE)", (boolean)in.hasBOM(ByteOrderMark.UTF_16BE));
        Assert.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        in.close();
    }

    @Test
    public void testReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        Assert.assertEquals((long)65L, (long)in.read());
        Assert.assertEquals((long)66L, (long)in.read());
        Assert.assertEquals((long)67L, (long)in.read());
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        Assert.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        Assert.assertNull((String)"getBOM", (Object)in.getBOM());
        in.close();
    }

    @Test
    public void testReadXmlWithBOMUcs2() throws Exception {
        Assume.assumeFalse((String)"This test does not pass on some IBM VMs xml parsers", (boolean)System.getProperty("java.vendor").contains("IBM"));
        Assume.assumeTrue((boolean)Charset.isSupported("ISO-10646-UCS-2"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"ISO-10646-UCS-2\"?><X/>".getBytes("ISO-10646-UCS-2");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE}));
        this.parseXml(this.createUtf16BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUcs4() throws Exception {
        Assume.assumeTrue((boolean)Charset.isSupported("ISO-10646-UCS-4"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"ISO-10646-UCS-4\"?><X/>".getBytes("ISO-10646-UCS-4");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE}));
        Assume.assumeTrue((String)"JVM and SAX need to support UTF_32LE for this", (boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"));
        this.parseXml(this.createUtf32BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf16Be() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?><X/>".getBytes(StandardCharsets.UTF_16BE);
        this.parseXml((InputStream)new BOMInputStream(this.createUtf16BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE}));
        this.parseXml(this.createUtf16BeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf16Le() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?><X/>".getBytes(StandardCharsets.UTF_16LE);
        this.parseXml((InputStream)new BOMInputStream(this.createUtf16LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16LE}));
        this.parseXml(this.createUtf16LeDataStream(data, true));
    }

    @Test
    public void testReadXmlWithBOMUtf32Be() throws Exception {
        Assume.assumeTrue((String)"JVM and SAX need to support UTF_32BE for this", (boolean)this.jvmAndSaxBothSupportCharset("UTF_32BE"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32BE\"?><X/>".getBytes("UTF_32BE");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf32BeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32BE}));
        this.parseXml((Reader)new XmlStreamReader(this.createUtf32BeDataStream(data, true)));
    }

    @Test
    public void testReadXmlWithBOMUtf32Le() throws Exception {
        Assume.assumeTrue((String)"JVM and SAX need to support UTF_32LE for this", (boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32LE\"?><X/>".getBytes("UTF_32LE");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf32LeDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_32LE}));
        this.parseXml((Reader)new XmlStreamReader(this.createUtf32LeDataStream(data, true)));
    }

    @Test
    public void testReadXmlWithBOMUtf8() throws Exception {
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><X/>".getBytes(StandardCharsets.UTF_8);
        this.parseXml((InputStream)new BOMInputStream(this.createUtf8DataStream(data, true)));
        this.parseXml(this.createUtf8DataStream(data, true));
    }

    @Test
    public void testReadXmlWithoutBOMUtf32Be() throws Exception {
        Assume.assumeTrue((String)"JVM and SAX need to support UTF_32BE for this", (boolean)this.jvmAndSaxBothSupportCharset("UTF_32BE"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF_32BE\"?><X/>".getBytes("UTF_32BE");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf32BeDataStream(data, false)));
        this.parseXml(this.createUtf32BeDataStream(data, false));
    }

    @Test
    public void testReadXmlWithoutBOMUtf32Le() throws Exception {
        Assume.assumeTrue((String)"JVM and SAX need to support UTF_32LE for this", (boolean)this.jvmAndSaxBothSupportCharset("UTF_32LE"));
        byte[] data = "<?xml version=\"1.0\" encoding=\"UTF-32LE\"?><X/>".getBytes("UTF_32LE");
        this.parseXml((InputStream)new BOMInputStream(this.createUtf32LeDataStream(data, false)));
        this.parseXml(this.createUtf32BeDataStream(data, false));
    }

    @Test
    public void testSkipWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        in.skip(2L);
        Assert.assertEquals((long)67L, (long)in.read());
        in.close();
    }

    @Test
    public void testSkipWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        in.skip(2L);
        Assert.assertEquals((long)67L, (long)in.read());
        in.close();
    }

    @Test
    public void skipReturnValueWithBom() throws IOException {
        byte[] baseData = new byte[]{49, 50, 51};
        BOMInputStream is1 = new BOMInputStream(this.createUtf8DataStream(baseData, true));
        Assert.assertEquals((long)2L, (long)is1.skip(2L));
        Assert.assertEquals((long)51L, (long)is1.read());
        is1.close();
    }

    @Test
    public void skipReturnValueWithoutBom() throws IOException {
        byte[] baseData = new byte[]{49, 50, 51};
        BOMInputStream is2 = new BOMInputStream(this.createUtf8DataStream(baseData, false));
        Assert.assertEquals((long)2L, (long)is2.skip(2L));
        Assert.assertEquals((long)51L, (long)is2.read());
        is2.close();
    }

    @Test
    public void testSmallBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, true));
        byte[] buf = new byte[1024];
        this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
        this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
        in.close();
    }

    @Test
    public void testSmallBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createUtf8DataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
        this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
        in.close();
    }

    @Test
    public void testSupportCode() throws Exception {
        InputStream in = this.createUtf8DataStream(new byte[]{65, 66}, true);
        byte[] buf = new byte[1024];
        int len = in.read(buf);
        Assert.assertEquals((long)5L, (long)len);
        Assert.assertEquals((long)239L, (long)(buf[0] & 0xFF));
        Assert.assertEquals((long)187L, (long)(buf[1] & 0xFF));
        Assert.assertEquals((long)191L, (long)(buf[2] & 0xFF));
        Assert.assertEquals((long)65L, (long)(buf[3] & 0xFF));
        Assert.assertEquals((long)66L, (long)(buf[4] & 0xFF));
        this.assertData(new byte[]{-17, -69, -65, 65, 66}, buf, len);
    }

    private boolean jvmAndSaxBothSupportCharset(String charSetName) throws ParserConfigurationException, SAXException, IOException {
        return Charset.isSupported(charSetName) && this.doesSaxSupportCharacterSet(charSetName);
    }

    private boolean doesSaxSupportCharacterSet(String charSetName) throws ParserConfigurationException, SAXException, IOException {
        block2: {
            byte[] data = ("<?xml version=\"1.0\" encoding=\"" + charSetName + "\"?><Z/>").getBytes(charSetName);
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            try {
                InputSource is = new InputSource(new ByteArrayInputStream(data));
                is.setEncoding(charSetName);
                documentBuilder.parse(is);
            }
            catch (SAXParseException e) {
                if (!e.getMessage().contains(charSetName)) break block2;
                return false;
            }
        }
        return true;
    }

    private static class ExpectCloseInputStream
    extends InputStream {
        private boolean _closeCalled;

        private ExpectCloseInputStream() {
        }

        public void assertCloseCalled() {
            Assert.assertTrue((boolean)this._closeCalled);
        }

        @Override
        public void close() throws IOException {
            this._closeCalled = true;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }
}

