/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.junit.Assert;
import org.junit.Test;

public class BoundedInputStreamTest {
    @Test
    public void testReadSingle() throws Exception {
        int i;
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        BoundedInputStream bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        for (i = 0; i < helloWorld.length; ++i) {
            Assert.assertEquals((String)("limit = length byte[" + i + "]"), (long)helloWorld[i], (long)bounded.read());
        }
        Assert.assertEquals((String)"limit = length end", (long)-1L, (long)bounded.read());
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        for (i = 0; i < helloWorld.length; ++i) {
            Assert.assertEquals((String)("limit > length byte[" + i + "]"), (long)helloWorld[i], (long)bounded.read());
        }
        Assert.assertEquals((String)"limit > length end", (long)-1L, (long)bounded.read());
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)hello.length);
        for (i = 0; i < hello.length; ++i) {
            Assert.assertEquals((String)("limit < length byte[" + i + "]"), (long)hello[i], (long)bounded.read());
        }
        Assert.assertEquals((String)"limit < length end", (long)-1L, (long)bounded.read());
    }

    @Test
    public void testReadArray() throws Exception {
        byte[] helloWorld = "Hello World".getBytes();
        byte[] hello = "Hello".getBytes();
        BoundedInputStream bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld));
        this.compare("limit = -1", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), 0L);
        this.compare("limit = 0", new byte[0], IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)helloWorld.length);
        this.compare("limit = length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length + 1));
        this.compare("limit > length", helloWorld, IOUtils.toByteArray((InputStream)bounded));
        bounded = new BoundedInputStream((InputStream)new ByteArrayInputStream(helloWorld), (long)(helloWorld.length - 6));
        this.compare("limit < length", hello, IOUtils.toByteArray((InputStream)bounded));
    }

    private void compare(String msg, byte[] expected, byte[] actual) {
        Assert.assertEquals((String)(msg + " length"), (long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)(msg + " byte[" + i + "]"), (long)expected[i], (long)actual[i]);
        }
    }
}

