/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.input.NullReader;
import org.apache.commons.io.input.ProxyReader;
import org.junit.Test;

public class ProxyReaderTest {
    @Test
    public void testNullCharArray() throws Exception {
        ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));
        proxy.read(null);
        proxy.read(null, 0, 0);
        proxy.close();
    }

    @Test
    public void testNullCharBuffer() throws Exception {
        ProxyReaderImpl proxy = new ProxyReaderImpl((Reader)((Object)new CustomNullReader(0)));
        proxy.read(null);
        proxy.close();
    }

    private static class CustomNullReader
    extends NullReader {
        CustomNullReader(int len) {
            super((long)len);
        }

        public int read(char[] chars) throws IOException {
            return chars == null ? 0 : super.read(chars);
        }

        public int read(CharBuffer target) throws IOException {
            return target == null ? 0 : super.read(target);
        }
    }

    private static class ProxyReaderImpl
    extends ProxyReader {
        ProxyReaderImpl(Reader proxy) {
            super(proxy);
        }
    }
}

