/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.input.TeeInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TeeInputStreamTest {
    private final String ASCII = "US-ASCII";
    private InputStream tee;
    private ByteArrayOutputStream output;

    @Before
    public void setUp() throws Exception {
        ByteArrayInputStream input = new ByteArrayInputStream("abc".getBytes("US-ASCII"));
        this.output = new ByteArrayOutputStream();
        this.tee = new TeeInputStream((InputStream)input, (OutputStream)this.output);
    }

    @Test
    public void testReadNothing() throws Exception {
        Assert.assertEquals((Object)"", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadOneByte() throws Exception {
        Assert.assertEquals((long)97L, (long)this.tee.read());
        Assert.assertEquals((Object)"a", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadEverything() throws Exception {
        Assert.assertEquals((long)97L, (long)this.tee.read());
        Assert.assertEquals((long)98L, (long)this.tee.read());
        Assert.assertEquals((long)99L, (long)this.tee.read());
        Assert.assertEquals((long)-1L, (long)this.tee.read());
        Assert.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadToArray() throws Exception {
        byte[] buffer = new byte[8];
        Assert.assertEquals((long)3L, (long)this.tee.read(buffer));
        Assert.assertEquals((long)97L, (long)buffer[0]);
        Assert.assertEquals((long)98L, (long)buffer[1]);
        Assert.assertEquals((long)99L, (long)buffer[2]);
        Assert.assertEquals((long)-1L, (long)this.tee.read(buffer));
        Assert.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testReadToArrayWithOffset() throws Exception {
        byte[] buffer = new byte[8];
        Assert.assertEquals((long)3L, (long)this.tee.read(buffer, 4, 4));
        Assert.assertEquals((long)97L, (long)buffer[4]);
        Assert.assertEquals((long)98L, (long)buffer[5]);
        Assert.assertEquals((long)99L, (long)buffer[6]);
        Assert.assertEquals((long)-1L, (long)this.tee.read(buffer, 4, 4));
        Assert.assertEquals((Object)"abc", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testSkip() throws Exception {
        Assert.assertEquals((long)97L, (long)this.tee.read());
        Assert.assertEquals((long)1L, (long)this.tee.skip(1L));
        Assert.assertEquals((long)99L, (long)this.tee.read());
        Assert.assertEquals((long)-1L, (long)this.tee.read());
        Assert.assertEquals((Object)"ac", (Object)new String(this.output.toString("US-ASCII")));
    }

    @Test
    public void testMarkReset() throws Exception {
        Assert.assertEquals((long)97L, (long)this.tee.read());
        this.tee.mark(1);
        Assert.assertEquals((long)98L, (long)this.tee.read());
        this.tee.reset();
        Assert.assertEquals((long)98L, (long)this.tee.read());
        Assert.assertEquals((long)99L, (long)this.tee.read());
        Assert.assertEquals((long)-1L, (long)this.tee.read());
        Assert.assertEquals((Object)"abbc", (Object)new String(this.output.toString("US-ASCII")));
    }
}

