/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class CountingOutputStreamTest {
    @Test
    public void testCounting() throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        for (int i2 = 0; i2 < 20; ++i2) {
            cos.write(i2);
        }
        this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 0, 20);
        Assert.assertEquals((String)"CountingOutputStream.getCount()", (long)cos.getCount(), (long)20L);
        byte[] array = new byte[10];
        for (i = 20; i < 30; ++i) {
            array[i - 20] = (byte)i;
        }
        cos.write(array);
        this.assertByteArrayEquals("CountingOutputStream.write(byte[])", baos.toByteArray(), 0, 30);
        Assert.assertEquals((String)"CountingOutputStream.getCount()", (long)cos.getCount(), (long)30L);
        for (i = 25; i < 35; ++i) {
            array[i - 25] = (byte)i;
        }
        cos.write(array, 5, 5);
        this.assertByteArrayEquals("CountingOutputStream.write(byte[], int, int)", baos.toByteArray(), 0, 35);
        Assert.assertEquals((String)"CountingOutputStream.getCount()", (long)cos.getCount(), (long)35L);
        int count = cos.resetCount();
        Assert.assertEquals((String)"CountingOutputStream.resetCount()", (long)count, (long)35L);
        for (int i3 = 0; i3 < 10; ++i3) {
            cos.write(i3);
        }
        this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 35, 45);
        Assert.assertEquals((String)"CountingOutputStream.getCount()", (long)cos.getCount(), (long)10L);
        cos.close();
    }

    @Test
    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        NullOutputStream nos = new NullOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)nos);
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        try {
            cos.getCount();
            Assert.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            cos.resetCount();
            Assert.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        Assert.assertEquals((String)"getByteCount()", (long)0x80000000L, (long)cos.getByteCount());
        Assert.assertEquals((String)"resetByteCount()", (long)0x80000000L, (long)cos.resetByteCount());
    }

    private void assertByteArrayEquals(String msg, byte[] array, int start, int end) {
        for (int i = start; i < end; ++i) {
            Assert.assertEquals((String)(msg + ": array[" + i + "] mismatch"), (long)array[i], (long)(i - start));
        }
    }
}

