/*
 * Decompiled with CFR 0.152.
 */
package almaligner;

import almaligner.Anymaliagn;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.SoftBevelBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;

public class MainFrame
extends JFrame {
    private File inputFile;
    private JButton browseButton;
    private JCheckBox computeWeightsCheckBox;
    private JLabel computeWeightsLabel;
    private JTextField corpusNameTextField;
    private JPanel mainPanel;
    private JLabel moreOptionsLabel;
    private JPanel moreOptionsPanel;
    private JProgressBar progressBar;
    private JLabel selectCorpusLabel;
    private JButton startButton;
    private JLabel stopAlignmentsLabel;
    private JSpinner stopAlignmentsSpinner;
    private JLabel stopSecondsLabel;
    private JSpinner stopSecondsSpinner;
    private JLabel versionLabel;

    public MainFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        this.initComponents();
        this.initializeInterface();
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.selectCorpusLabel = new JLabel();
        this.browseButton = new JButton();
        this.startButton = new JButton();
        this.corpusNameTextField = new JTextField();
        this.moreOptionsLabel = new JLabel();
        this.moreOptionsPanel = new JPanel();
        this.stopSecondsLabel = new JLabel();
        this.stopSecondsSpinner = new JSpinner();
        this.stopAlignmentsLabel = new JLabel();
        this.stopAlignmentsSpinner = new JSpinner();
        this.computeWeightsLabel = new JLabel();
        this.computeWeightsCheckBox = new JCheckBox();
        this.progressBar = new JProgressBar();
        this.versionLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Almaligner");
        this.setSize(new Dimension(400, 300));
        this.selectCorpusLabel.setText("Select input file (TMX or TSV)");
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.browseButtonActionPerformed(evt);
            }
        });
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.startButtonActionPerformed(evt);
            }
        });
        this.corpusNameTextField.setEnabled(false);
        this.corpusNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.corpusNameTextFieldActionPerformed(evt);
            }
        });
        this.moreOptionsLabel.setHorizontalAlignment(2);
        this.moreOptionsLabel.setIcon(new ImageIcon(this.getClass().getResource("/gui/resources/options_more_16x16.png")));
        this.moreOptionsLabel.setLabelFor(this.moreOptionsPanel);
        this.moreOptionsLabel.setText("More options");
        this.moreOptionsLabel.setHorizontalTextPosition(2);
        this.moreOptionsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MainFrame.this.moreOptionsLabelMouseClicked(evt);
            }
        });
        this.moreOptionsPanel.setBorder(new SoftBevelBorder(0));
        this.stopSecondsLabel.setText("Stop after (seconds)");
        this.stopAlignmentsLabel.setText("Stop when alignments per second drop below");
        this.computeWeightsLabel.setText("Compute lexical weights");
        this.computeWeightsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.computeWeightsCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout moreOptionsPanelLayout = new GroupLayout(this.moreOptionsPanel);
        this.moreOptionsPanel.setLayout(moreOptionsPanelLayout);
        moreOptionsPanelLayout.setHorizontalGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moreOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moreOptionsPanelLayout.createSequentialGroup().addComponent(this.stopSecondsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.stopSecondsSpinner, -2, 70, -2)).addGroup(moreOptionsPanelLayout.createSequentialGroup().addComponent(this.stopAlignmentsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addComponent(this.stopAlignmentsSpinner, -2, 70, -2)).addGroup(moreOptionsPanelLayout.createSequentialGroup().addComponent(this.computeWeightsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.computeWeightsCheckBox))).addContainerGap()));
        moreOptionsPanelLayout.setVerticalGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moreOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopSecondsLabel).addComponent(this.stopSecondsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopAlignmentsLabel).addComponent(this.stopAlignmentsSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(moreOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.computeWeightsLabel).addComponent(this.computeWeightsCheckBox)).addContainerGap(41, Short.MAX_VALUE)));
        this.versionLabel.setFont(new Font("Lucida Grande", 0, 10));
        this.versionLabel.setText("Version");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moreOptionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.selectCorpusLabel, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.corpusNameTextField)).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.moreOptionsLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.startButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.versionLabel))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.selectCorpusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.browseButton).addComponent(this.corpusNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreOptionsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moreOptionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 70, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startButton).addComponent(this.versionLabel))));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mainPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.addChoosableFileFilter(new FileNameExtensionFilter("TMX (Translation Memory Exchange)", "tmx"));
        fc.addChoosableFileFilter(new FileNameExtensionFilter("TSV (TAB Separated File)", "tsv"));
        fc.setAcceptAllFileFilterUsed(true);
        int retVal = fc.showOpenDialog(this);
        if (retVal == 1) {
            return;
        }
        this.inputFile = fc.getSelectedFile();
        this.corpusNameTextField.setText(FilenameUtils.getBaseName((String)this.inputFile.toString()));
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.executeAnymalign();
        this.startButton.setEnabled(false);
    }

    public JButton getStartButton() {
        return this.startButton;
    }

    private void corpusNameTextFieldActionPerformed(ActionEvent evt) {
    }

    private void moreOptionsLabelMouseClicked(MouseEvent evt) {
        if (this.moreOptionsPanel.isVisible()) {
            this.moreOptionsLabel.setText("More options");
            this.moreOptionsPanel.setVisible(false);
            this.moreOptionsLabel.setIcon(new ImageIcon(this.getClass().getResource("/gui/resources/options_more_16x16.png")));
        } else {
            this.moreOptionsLabel.setText("Less options");
            this.moreOptionsPanel.setVisible(true);
            this.moreOptionsLabel.setIcon(new ImageIcon(this.getClass().getResource("/gui/resources/options_less_16x16.png")));
        }
    }

    private void computeWeightsCheckBoxActionPerformed(ActionEvent evt) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    public File getCorpus() {
        return this.inputFile;
    }

    public void setVersion(double version) {
        this.versionLabel.setText("Version " + version);
    }

    private void executeAnymalign() {
        if (!this.inputFile.canRead()) {
            System.err.println("Cannot read file " + this.inputFile);
        }
        Anymaliagn anymaliagn = new Anymaliagn(this.inputFile, this);
        Thread anymalignThread = new Thread(anymaliagn);
        anymalignThread.start();
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void initializeInterface() {
        SpinnerNumberModel stopSecondsModel = new SpinnerNumberModel(5, 0, 1000000, 60);
        this.stopSecondsSpinner.setModel(stopSecondsModel);
        SpinnerNumberModel stopAlignmentsModel = new SpinnerNumberModel(0, 0, 2000, 100);
        this.stopAlignmentsSpinner.setModel(stopAlignmentsModel);
        this.computeWeightsCheckBox.setSelected(false);
        this.moreOptionsPanel.setVisible(false);
    }

    public JCheckBox getComputeWeightsCheckBox() {
        return this.computeWeightsCheckBox;
    }

    public JSpinner getStopAlignmentsSpinner() {
        return this.stopAlignmentsSpinner;
    }

    public JSpinner getStopSecondsSpinner() {
        return this.stopSecondsSpinner;
    }
}

