/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.io.FileSystemUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileSystemUtilsTestCase {
    @Test
    public void testGetFreeSpace_String() throws Exception {
        if (File.separatorChar == '/') {
            String osName = System.getProperty("os.name");
            String[] cmd = (osName = osName.toLowerCase(Locale.ENGLISH)).contains("hp-ux") || osName.contains("aix") ? new String[]{"df", "-P", "/"} : (osName.contains("sunos") || osName.contains("sun os") || osName.contains("solaris") ? new String[]{"/usr/xpg4/bin/df", "-P", "/"} : new String[]{"df", "/"});
            Process proc = Runtime.getRuntime().exec(cmd);
            boolean kilobyteBlock = true;
            try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                String line = r.readLine();
                Assert.assertNotNull((String)"Unexpected null line", (Object)line);
                if (line.contains("512")) {
                    kilobyteBlock = false;
                }
            }
            long free = FileSystemUtils.freeSpace((String)"/");
            long kb = FileSystemUtils.freeSpaceKb((String)"/");
            double acceptableDelta = (double)kb * 0.01;
            if (kilobyteBlock) {
                Assert.assertEquals((double)free, (double)kb, (double)acceptableDelta);
            } else {
                Assert.assertEquals((double)((double)free / 2.0), (double)kb, (double)acceptableDelta);
            }
        } else {
            long bytes = FileSystemUtils.freeSpace((String)"");
            long kb = FileSystemUtils.freeSpaceKb((String)"");
            double acceptableDelta = (double)kb * 0.01;
            Assert.assertEquals((double)((double)bytes / 1024.0), (double)kb, (double)acceptableDelta);
        }
    }

    @Test
    public void testGetFreeSpaceOS_String_NullPath() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils();
        try {
            fsu.freeSpaceOS(null, 1, false, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceOS(null, 1, true, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceOS_String_InitError() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils();
        try {
            fsu.freeSpaceOS("", -1, false, -1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceOS("", -1, true, -1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceOS_String_Other() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils();
        try {
            fsu.freeSpaceOS("", 0, false, -1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceOS("", 0, true, -1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceOS_String_Windows() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(){

            protected long freeSpaceWindows(String path, long timeout) throws IOException {
                return 12345L;
            }
        };
        Assert.assertEquals((long)12345L, (long)fsu.freeSpaceOS("", 1, false, -1L));
        Assert.assertEquals((long)12L, (long)fsu.freeSpaceOS("", 1, true, -1L));
    }

    @Test
    public void testGetFreeSpaceOS_String_Unix() throws Exception {
        FileSystemUtils fsu = new FileSystemUtils(){

            protected long freeSpaceUnix(String path, boolean kb, boolean posix, long timeout) throws IOException {
                return kb ? 12345L : 54321L;
            }
        };
        Assert.assertEquals((long)54321L, (long)fsu.freeSpaceOS("", 2, false, -1L));
        Assert.assertEquals((long)12345L, (long)fsu.freeSpaceOS("", 2, true, -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_ParseCommaFormatBytes() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)        180,260 bytes\n              10 Dir(s)  41,411,551,232 bytes free";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)        180,260 bytes\n              10 Dir(s)  41,411,551,232 bytes free");
        Assert.assertEquals((long)41411551232L, (long)fsu.freeSpaceWindows("", -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_EmptyPath() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free", "dir /a /-c ");
        Assert.assertEquals((long)41411551232L, (long)fsu.freeSpaceWindows("", -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_NormalResponse() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free", "dir /a /-c \"C:\"");
        Assert.assertEquals((long)41411551232L, (long)fsu.freeSpaceWindows("C:", -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_StripDrive() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free", "dir /a /-c \"C:\\somedir\"");
        Assert.assertEquals((long)41411551232L, (long)fsu.freeSpaceWindows("C:\\somedir", -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_quoted() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\Xxxx\n\n19/08/2005  22:43    <DIR>          .\n19/08/2005  22:43    <DIR>          ..\n11/08/2005  01:07                81 build.properties\n17/08/2005  21:44    <DIR>          Desktop\n               7 File(s)         180260 bytes\n              10 Dir(s)     41411551232 bytes free", "dir /a /-c \"C:\\somedir\"");
        Assert.assertEquals((long)41411551232L, (long)fsu.freeSpaceWindows("\"C:\\somedir\"", -1L));
    }

    @Test
    public void testGetFreeSpaceWindows_String_EmptyResponse() throws Exception {
        String lines = "";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "");
        try {
            fsu.freeSpaceWindows("C:", -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test(expected=IOException.class)
    public void testGetFreeSpaceWindows_String_EmptyMultiLineResponse() throws Exception {
        String lines = "\n\n";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "\n\n");
        fsu.freeSpaceWindows("C:", -1L);
    }

    @Test(expected=IOException.class)
    public void testGetFreeSpaceWindows_String_InvalidTextResponse() throws Exception {
        String lines = "BlueScreenOfDeath";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "BlueScreenOfDeath");
        fsu.freeSpaceWindows("C:", -1L);
    }

    @Test(expected=IOException.class)
    public void testGetFreeSpaceWindows_String_NoSuchDirectoryResponse() throws Exception {
        String lines = " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\empty\n";
        MockFileSystemUtils fsu = new MockFileSystemUtils(1, " Volume in drive C is HDD\n Volume Serial Number is XXXX-YYYY\n\n Directory of C:\\Documents and Settings\\empty\n");
        fsu.freeSpaceWindows("C:", -1L);
    }

    @Test
    public void testGetFreeSpaceUnix_String_EmptyPath() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424   1472504  90% /home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424   1472504  90% /home/users/s");
        try {
            fsu.freeSpaceUnix("", false, false, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("", true, false, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("", true, true, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("", false, true, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceUnix_String_NormalResponseLinux() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\n/dev/xxx                497944    308528    189416  62% /";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\n/dev/xxx                497944    308528    189416  62% /");
        Assert.assertEquals((long)189416L, (long)fsu.freeSpaceUnix("/", false, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_NormalResponseFreeBSD() throws Exception {
        String lines = "Filesystem  1K-blocks      Used    Avail Capacity  Mounted on\n/dev/xxxxxx    128990    102902    15770    87%    /";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem  1K-blocks      Used    Avail Capacity  Mounted on\n/dev/xxxxxx    128990    102902    15770    87%    /");
        Assert.assertEquals((long)15770L, (long)fsu.freeSpaceUnix("/", false, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_NormalResponseKbLinux() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\n/dev/xxx                497944    308528    189416  62% /";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\n/dev/xxx                497944    308528    189416  62% /");
        Assert.assertEquals((long)189416L, (long)fsu.freeSpaceUnix("/", true, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_NormalResponseKbFreeBSD() throws Exception {
        String lines = "Filesystem  1K-blocks      Used    Avail Capacity  Mounted on\n/dev/xxxxxx    128990    102902    15770    87%    /";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem  1K-blocks      Used    Avail Capacity  Mounted on\n/dev/xxxxxx    128990    102902    15770    87%    /");
        Assert.assertEquals((long)15770L, (long)fsu.freeSpaceUnix("/", true, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_NormalResponseKbSolaris() throws Exception {
        String lines = "Filesystem            kbytes    used   avail capacity  Mounted on\n/dev/dsk/x0x0x0x0    1350955  815754  481163    63%";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem            kbytes    used   avail capacity  Mounted on\n/dev/dsk/x0x0x0x0    1350955  815754  481163    63%");
        Assert.assertEquals((long)481163L, (long)fsu.freeSpaceUnix("/dev/dsk/x0x0x0x0", true, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_LongResponse() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s\n                      14428928  12956424   1472504  90% /home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s\n                      14428928  12956424   1472504  90% /home/users/s");
        Assert.assertEquals((long)1472504L, (long)fsu.freeSpaceUnix("/home/users/s", false, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_LongResponseKb() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s\n                      14428928  12956424   1472504  90% /home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s\n                      14428928  12956424   1472504  90% /home/users/s");
        Assert.assertEquals((long)1472504L, (long)fsu.freeSpaceUnix("/home/users/s", true, false, -1L));
    }

    @Test
    public void testGetFreeSpaceUnix_String_EmptyResponse() throws Exception {
        String lines = "";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "");
        try {
            fsu.freeSpaceUnix("/home/users/s", false, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", false, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceUnix_String_InvalidResponse1() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\n                      14428928  12956424       100";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\n                      14428928  12956424       100");
        try {
            fsu.freeSpaceUnix("/home/users/s", false, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", false, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceUnix_String_InvalidResponse2() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424   nnnnnnn  90% /home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424   nnnnnnn  90% /home/users/s");
        try {
            fsu.freeSpaceUnix("/home/users/s", false, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", false, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceUnix_String_InvalidResponse3() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424        -1  90% /home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx:/home/users/s     14428928  12956424        -1  90% /home/users/s");
        try {
            fsu.freeSpaceUnix("/home/users/s", false, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", false, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFreeSpaceUnix_String_InvalidResponse4() throws Exception {
        String lines = "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s";
        MockFileSystemUtils fsu = new MockFileSystemUtils(0, "Filesystem           1K-blocks      Used Available Use% Mounted on\nxxx-yyyyyyy-zzz:/home/users/s");
        try {
            fsu.freeSpaceUnix("/home/users/s", false, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, false, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", false, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            fsu.freeSpaceUnix("/home/users/s", true, true, -1L);
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class MockFileSystemUtils
    extends FileSystemUtils {
        private final int exitCode;
        private final byte[] bytes;
        private final String cmd;

        public MockFileSystemUtils(int exitCode, String lines) {
            this(exitCode, lines, null);
        }

        public MockFileSystemUtils(int exitCode, String lines, String cmd) {
            this.exitCode = exitCode;
            this.bytes = lines.getBytes();
            this.cmd = cmd;
        }

        Process openProcess(String[] params) {
            if (this.cmd != null) {
                Assert.assertEquals((Object)this.cmd, (Object)params[params.length - 1]);
            }
            return new Process(){

                @Override
                public InputStream getErrorStream() {
                    return null;
                }

                @Override
                public InputStream getInputStream() {
                    return new ByteArrayInputStream(MockFileSystemUtils.this.bytes);
                }

                @Override
                public OutputStream getOutputStream() {
                    return null;
                }

                @Override
                public int waitFor() throws InterruptedException {
                    return MockFileSystemUtils.this.exitCode;
                }

                @Override
                public int exitValue() {
                    return MockFileSystemUtils.this.exitCode;
                }

                @Override
                public void destroy() {
                }
            };
        }
    }
}

