/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FileUtilsFileNewerTestCase {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final int FILE1_SIZE = 1;
    private static final int FILE2_SIZE = 4097;
    private File m_testFile1;
    private File m_testFile2;

    private File getTestDirectory() {
        return this.temporaryFolder.getRoot();
    }

    @Before
    public void setUp() throws Exception {
        this.m_testFile1 = new File(this.getTestDirectory(), "file1-test.txt");
        this.m_testFile2 = new File(this.getTestDirectory(), "file2-test.txt");
        if (!this.m_testFile1.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.m_testFile1 + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(this.m_testFile1));){
            TestUtils.generateTestData(output1, 1L);
        }
        if (!this.m_testFile2.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.m_testFile2 + " as the parent directory does not exist");
        }
        var2_2 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.m_testFile2));){
            TestUtils.generateTestData(output, 4097L);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIsFileNewer() {
        if (!this.m_testFile1.exists()) {
            throw new IllegalStateException("The m_testFile1 should exist");
        }
        long fileLastModified = this.m_testFile1.lastModified();
        long TWO_SECOND = 2000L;
        this.testIsFileNewer("two second earlier is not newer", this.m_testFile1, fileLastModified + 2000L, false);
        this.testIsFileNewer("same time is not newer", this.m_testFile1, fileLastModified, false);
        this.testIsFileNewer("two second later is newer", this.m_testFile1, fileLastModified - 2000L, true);
    }

    @Test
    public void testIsFileNewerImaginaryFile() {
        File imaginaryFile = new File(this.getTestDirectory(), "imaginaryFile");
        if (imaginaryFile.exists()) {
            throw new IllegalStateException("The imaginary File exists");
        }
        this.testIsFileNewer("imaginary file can be newer", imaginaryFile, this.m_testFile2.lastModified(), false);
    }

    protected void testIsFileNewer(String description, File file, long time, boolean wantedResult) {
        Assert.assertEquals((String)(description + " - time"), (Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (long)time));
        Assert.assertEquals((String)(description + " - date"), (Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (Date)new Date(time)));
        File temporaryFile = this.m_testFile2;
        temporaryFile.setLastModified(time);
        Assert.assertEquals((String)"The temporary file hasn't the right last modification date", (long)time, (long)temporaryFile.lastModified());
        Assert.assertEquals((String)(description + " - file"), (Object)wantedResult, (Object)FileUtils.isFileNewer((File)file, (File)temporaryFile));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsFileNewerNoFile() {
        FileUtils.isFileNewer(null, (long)0L);
        Assert.fail((String)"File not specified");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsFileNewerNoDate() {
        FileUtils.isFileNewer((File)this.m_testFile1, (Date)null);
        Assert.fail((String)"Date not specified");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIsFileNewerNoFileReference() {
        FileUtils.isFileNewer((File)this.m_testFile1, (File)null);
        Assert.fail((String)"Reference file not specified");
    }
}

