/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.SizeFileComparator;
import org.apache.commons.io.testtools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeFileComparatorTest
extends ComparatorAbstractTestCase {
    private File smallerDir;
    private File largerDir;
    private File smallerFile;
    private File largerFile;

    @Before
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)SizeFileComparator.SIZE_COMPARATOR;
        this.reverse = SizeFileComparator.SIZE_REVERSE;
        File dir = this.getTestDirectory();
        this.smallerDir = new File(dir, "smallerdir");
        this.largerDir = new File(dir, "largerdir");
        this.smallerFile = new File(this.smallerDir, "smaller.txt");
        File equalFile = new File(dir, "equal.txt");
        this.largerFile = new File(this.largerDir, "larger.txt");
        this.smallerDir.mkdir();
        this.largerDir.mkdir();
        if (!this.smallerFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.smallerFile + " as the parent directory does not exist");
        }
        try (BufferedOutputStream output2 = new BufferedOutputStream(new FileOutputStream(this.smallerFile));){
            TestUtils.generateTestData(output2, 32L);
        }
        if (!equalFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + equalFile + " as the parent directory does not exist");
        }
        var4_4 = null;
        try (BufferedOutputStream output1 = new BufferedOutputStream(new FileOutputStream(equalFile));){
            TestUtils.generateTestData(output1, 48L);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        if (!this.largerFile.getParentFile().exists()) {
            throw new IOException("Cannot create file " + this.largerFile + " as the parent directory does not exist");
        }
        var4_4 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.largerFile));){
            TestUtils.generateTestData(output, 64L);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        this.equalFile1 = equalFile;
        this.equalFile2 = equalFile;
        this.lessFile = this.smallerFile;
        this.moreFile = this.largerFile;
    }

    @Test
    public void testNonexistantFile() {
        File nonexistantFile = new File(new File("."), "nonexistant.txt");
        Assert.assertFalse((boolean)nonexistantFile.exists());
        Assert.assertTrue((String)"less", (this.comparator.compare((Object)nonexistantFile, (Object)this.moreFile) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareDirectorySizes() {
        Assert.assertEquals((String)"sumDirectoryContents=false", (long)0L, (long)this.comparator.compare((Object)this.smallerDir, (Object)this.largerDir));
        Assert.assertEquals((String)"less", (long)-1L, (long)SizeFileComparator.SIZE_SUMDIR_COMPARATOR.compare(this.smallerDir, this.largerDir));
        Assert.assertEquals((String)"less", (long)1L, (long)SizeFileComparator.SIZE_SUMDIR_REVERSE.compare(this.smallerDir, this.largerDir));
    }
}

