/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class CharSequenceInputStreamTest {
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LARGE_TEST_STRING;
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private final Random random = new Random();

    private Set<String> getRequiredCharsetNames() {
        return Charsets.requiredCharsets().keySet();
    }

    private void testBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);){
            byte[] buffer = new byte[128];
            int offset = 0;
            block9: while (true) {
                int bufferLength;
                int bufferOffset;
                int read;
                if ((read = in.read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                    Assert.assertEquals((String)("EOF: offset should equal length for charset " + charsetName), (long)expected.length, (long)offset);
                    break;
                }
                Assert.assertTrue((String)("Read " + read + " <= " + bufferLength), (read <= bufferLength ? 1 : 0) != 0);
                while (true) {
                    if (read <= 0) continue block9;
                    Assert.assertTrue((String)("offset for " + charsetName + " " + offset + " < " + expected.length), (offset < expected.length ? 1 : 0) != 0);
                    Assert.assertEquals((String)("bytes should agree for " + charsetName), (long)expected[offset], (long)buffer[bufferOffset]);
                    ++offset;
                    ++bufferOffset;
                    --read;
                }
                break;
            }
        }
    }

    @Test
    public void testBufferedRead_AvailableCharset() throws IOException {
        for (String csName : Charset.availableCharsets().keySet()) {
            if (!this.isAvailabilityTestableForCharset(csName)) continue;
            this.testBufferedRead(TEST_STRING, csName);
        }
    }

    @Test
    public void testBufferedRead_RequiredCharset() throws IOException {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testBufferedRead(TEST_STRING, csName);
        }
    }

    @Test
    public void testBufferedRead_UTF8() throws IOException {
        this.testBufferedRead(TEST_STRING, "UTF-8");
    }

    private void testCharsetMismatchInfiniteLoop(String csName) throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = Charset.forName(csName);
        try (CharSequenceInputStream stream = new CharSequenceInputStream((CharSequence)new String(inputChars), charset, 512);){
            while (stream.read() != -1) {
            }
        }
    }

    @Test
    public void testCharsetMismatchInfiniteLoop_RequiredCharsets() throws IOException {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testCharsetMismatchInfiniteLoop(csName);
        }
    }

    private void testIO_356(int bufferSize, int dataSize, int readFirst, String csName) throws Exception {
        CharSequenceInputStream is = new CharSequenceInputStream((CharSequence)ALPHABET, csName, bufferSize);
        for (int i = 0; i < readFirst; ++i) {
            int ch = is.read();
            Assert.assertFalse((ch == -1 ? 1 : 0) != 0);
        }
        is.mark(dataSize);
        byte[] data1 = new byte[dataSize];
        int readCount1 = is.read(data1);
        Assert.assertEquals((long)dataSize, (long)readCount1);
        is.reset();
        byte[] data2 = new byte[dataSize];
        int readCount2 = is.read(data2);
        Assert.assertEquals((long)dataSize, (long)readCount2);
        is.close();
        Assert.assertArrayEquals((String)("bufferSize=" + bufferSize + " dataSize=" + dataSize), (byte[])data1, (byte[])data2);
    }

    @Test
    public void testIO_356_B10_D10_S0_UTF16() throws Exception {
        this.testIO_356(10, 10, 0, "UTF-16");
    }

    @Test
    public void testIO_356_B10_D10_S0_UTF8() throws Exception {
        this.testIO_356(10, 10, 0, "UTF-8");
    }

    @Test
    public void testIO_356_B10_D10_S1_UTF8() throws Exception {
        this.testIO_356(10, 10, 1, "UTF-8");
    }

    @Test
    public void testIO_356_B10_D10_S2_UTF8() throws Exception {
        this.testIO_356(10, 10, 2, "UTF-8");
    }

    @Test
    public void testIO_356_B10_D13_S0_UTF8() throws Exception {
        this.testIO_356(10, 13, 0, "UTF-8");
    }

    @Test
    public void testIO_356_B10_D13_S1_UTF8() throws Exception {
        this.testIO_356(10, 13, 1, "UTF-8");
    }

    @Test
    public void testIO_356_B10_D20_S0_UTF8() throws Exception {
        this.testIO_356(10, 20, 0, "UTF-8");
    }

    private void testIO_356_Loop(String csName, int maxBytesPerChar) throws Exception {
        for (int bufferSize = maxBytesPerChar; bufferSize <= 10; ++bufferSize) {
            for (int dataSize = 1; dataSize <= 20; ++dataSize) {
                this.testIO_356(bufferSize, dataSize, 0, csName);
            }
        }
    }

    @Test
    public void testIO_356_Loop_UTF16() throws Exception {
        this.testIO_356_Loop("UTF-16", 4);
    }

    @Test
    public void testIO_356_Loop_UTF8() throws Exception {
        this.testIO_356_Loop("UTF-8", 4);
    }

    @Test
    public void testLargeBufferedRead_RequiredCharsets() throws IOException {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testBufferedRead(LARGE_TEST_STRING, csName);
        }
    }

    @Test
    public void testLargeBufferedRead_UTF8() throws IOException {
        this.testBufferedRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeSingleByteRead_RequiredCharsets() throws IOException {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testSingleByteRead(LARGE_TEST_STRING, csName);
        }
    }

    @Test
    public void testLargeSingleByteRead_UTF8() throws IOException {
        this.testSingleByteRead(LARGE_TEST_STRING, "UTF-8");
    }

    private void testMarkReset(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            Assert.assertEquals((long)2L, (long)r.skip(2L));
            r.mark(0);
            Assert.assertEquals((String)csName, (long)115L, (long)r.read());
            Assert.assertEquals((String)csName, (long)116L, (long)r.read());
            Assert.assertEquals((String)csName, (long)-1L, (long)r.read());
            r.reset();
            Assert.assertEquals((String)csName, (long)115L, (long)r.read());
            Assert.assertEquals((String)csName, (long)116L, (long)r.read());
            Assert.assertEquals((String)csName, (long)-1L, (long)r.read());
            r.reset();
            r.reset();
        }
    }

    @Test
    @Ignore
    public void testMarkReset_RequiredCharsets() throws Exception {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testMarkReset(csName);
        }
    }

    @Test
    public void testMarkReset_USASCII() throws Exception {
        this.testMarkReset("US-ASCII");
    }

    @Test
    public void testMarkReset_UTF8() throws Exception {
        this.testMarkReset("UTF-8");
    }

    @Test
    public void testMarkSupported() throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", "UTF-8");){
            Assert.assertTrue((boolean)r.markSupported());
        }
    }

    private void testReadZero(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            byte[] bytes = new byte[30];
            Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        }
    }

    @Test
    public void testReadZero_EmptyString() throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"", "UTF-8");){
            byte[] bytes = new byte[30];
            Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        }
    }

    @Test
    public void testReadZero_RequiredCharsets() throws Exception {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testReadZero(csName);
        }
    }

    private void testSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        try (CharSequenceInputStream in = new CharSequenceInputStream((CharSequence)testString, charsetName, 512);){
            for (byte b : bytes) {
                int read = in.read();
                Assert.assertTrue((String)("read " + read + " >=0 "), (read >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)("read " + read + " <= 255"), (read <= 255 ? 1 : 0) != 0);
                Assert.assertEquals((String)"Should agree with input", (long)b, (long)((byte)read));
            }
            Assert.assertEquals((long)-1L, (long)in.read());
        }
    }

    @Test
    public void testSingleByteRead_RequiredCharsets() throws IOException {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testSingleByteRead(TEST_STRING, csName);
        }
    }

    @Test
    public void testSingleByteRead_UTF16() throws IOException {
        this.testSingleByteRead(TEST_STRING, "UTF-16");
    }

    @Test
    public void testSingleByteRead_UTF8() throws IOException {
        this.testSingleByteRead(TEST_STRING, "UTF-8");
    }

    private void testSkip(String csName) throws Exception {
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            Assert.assertEquals((long)1L, (long)r.skip(1L));
            Assert.assertEquals((long)2L, (long)r.skip(2L));
            Assert.assertEquals((String)csName, (long)116L, (long)r.read());
            r.skip(100L);
            Assert.assertEquals((String)csName, (long)-1L, (long)r.read());
        }
    }

    @Test
    @Ignore
    public void testSkip_RequiredCharsets() throws Exception {
        for (String csName : this.getRequiredCharsetNames()) {
            this.testSkip(csName);
        }
    }

    @Test
    public void testSkip_USASCII() throws Exception {
        this.testSkip("US-ASCII");
    }

    @Test
    public void testSkip_UTF8() throws Exception {
        this.testSkip("UTF-8");
    }

    private int checkAvail(InputStream is, int min) throws Exception {
        int available = is.available();
        Assert.assertTrue((String)("avail should be >= " + min + ", but was " + available), (available >= min ? 1 : 0) != 0);
        return available;
    }

    private void testAvailableSkip(String csName) throws Exception {
        String input = "test";
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            int available = this.checkAvail((InputStream)r, "test".length());
            Assert.assertEquals((long)(available - 1), (long)r.skip(available - 1));
            available = this.checkAvail((InputStream)r, 1);
            Assert.assertEquals((long)1L, (long)r.skip(1L));
            available = this.checkAvail((InputStream)r, 0);
        }
    }

    private void testAvailableRead(String csName) throws Exception {
        String input = "test";
        try (CharSequenceInputStream r = new CharSequenceInputStream((CharSequence)"test", csName);){
            int available = this.checkAvail((InputStream)r, "test".length());
            byte[] buff = new byte[available];
            Assert.assertEquals((long)(available - 1), (long)r.skip(available - 1));
            available = this.checkAvail((InputStream)r, 1);
            buff = new byte[available];
            Assert.assertEquals((long)available, (long)r.read(buff, 0, available));
        }
    }

    @Test
    public void testAvailable() throws Exception {
        for (String csName : Charset.availableCharsets().keySet()) {
            try {
                if (!this.isAvailabilityTestableForCharset(csName)) continue;
                this.testAvailableSkip(csName);
                this.testAvailableRead(csName);
            }
            catch (UnsupportedOperationException e) {
                Assert.fail((String)("Operation not supported for " + csName));
            }
        }
    }

    private boolean isAvailabilityTestableForCharset(String csName) {
        return Charset.forName(csName).canEncode() && !"COMPOUND_TEXT".equalsIgnoreCase(csName) && !"x-COMPOUND_TEXT".equalsIgnoreCase(csName) && !this.isOddBallLegacyCharsetThatDoesNotSupportFrenchCharacters(csName);
    }

    private boolean isOddBallLegacyCharsetThatDoesNotSupportFrenchCharacters(String csName) {
        return "x-IBM1388".equalsIgnoreCase(csName) || "ISO-2022-CN".equalsIgnoreCase(csName) || "ISO-2022-JP".equalsIgnoreCase(csName) || "Shift_JIS".equalsIgnoreCase(csName);
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

