/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.CharSequenceReader;
import org.junit.Assert;
import org.junit.Test;

public class CharSequenceReaderTest {
    private static final char NONE = (new char[1])[0];

    @Test
    public void testClose() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        this.checkRead((Reader)reader, "Foo");
        reader.close();
        this.checkRead((Reader)reader, "Foo");
    }

    @Test
    public void testMarkSupported() throws Exception {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        Assert.assertTrue((boolean)reader.markSupported());
        reader.close();
    }

    @Test
    public void testMark() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        this.checkRead((Reader)reader, "Foo");
        reader.mark(0);
        this.checkRead((Reader)reader, "Bar");
        reader.reset();
        this.checkRead((Reader)reader, "Bar");
        reader.close();
        this.checkRead((Reader)reader, "Foo");
        reader.reset();
        this.checkRead((Reader)reader, "Foo");
    }

    @Test
    public void testSkip() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        Assert.assertEquals((long)3L, (long)reader.skip(3L));
        this.checkRead((Reader)reader, "Bar");
        Assert.assertEquals((long)-1L, (long)reader.skip(3L));
        reader.reset();
        Assert.assertEquals((long)2L, (long)reader.skip(2L));
        Assert.assertEquals((long)4L, (long)reader.skip(10L));
        Assert.assertEquals((long)-1L, (long)reader.skip(1L));
        reader.close();
        Assert.assertEquals((long)6L, (long)reader.skip(20L));
        Assert.assertEquals((long)-1L, (long)reader.read());
    }

    @Test
    public void testRead() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"Foo");
        Assert.assertEquals((long)70L, (long)reader.read());
        Assert.assertEquals((long)111L, (long)reader.read());
        Assert.assertEquals((long)111L, (long)reader.read());
        Assert.assertEquals((long)-1L, (long)reader.read());
        Assert.assertEquals((long)-1L, (long)reader.read());
        reader.close();
    }

    @Test
    public void testReadCharArray() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        char[] chars = new char[2];
        Assert.assertEquals((long)2L, (long)reader.read(chars));
        this.checkArray(new char[]{'F', 'o'}, chars);
        chars = new char[3];
        Assert.assertEquals((long)3L, (long)reader.read(chars));
        this.checkArray(new char[]{'o', 'B', 'a'}, chars);
        chars = new char[3];
        Assert.assertEquals((long)1L, (long)reader.read(chars));
        this.checkArray(new char[]{'r', NONE, NONE}, chars);
        Assert.assertEquals((long)-1L, (long)reader.read(chars));
        reader.close();
    }

    @Test
    public void testReadCharArrayPortion() throws IOException {
        char[] chars = new char[10];
        CharSequenceReader reader = new CharSequenceReader((CharSequence)"FooBar");
        Assert.assertEquals((long)3L, (long)reader.read(chars, 3, 3));
        this.checkArray(new char[]{NONE, NONE, NONE, 'F', 'o', 'o'}, chars);
        Assert.assertEquals((long)3L, (long)reader.read(chars, 0, 3));
        this.checkArray(new char[]{'B', 'a', 'r', 'F', 'o', 'o', NONE}, chars);
        Assert.assertEquals((long)-1L, (long)reader.read(chars));
        reader.close();
    }

    private void checkRead(Reader reader, String expected) throws IOException {
        for (int i = 0; i < expected.length(); ++i) {
            Assert.assertEquals((String)("Read[" + i + "] of '" + expected + "'"), (long)expected.charAt(i), (long)((char)reader.read()));
        }
    }

    private void checkArray(char[] expected, char[] actual) {
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Compare[" + i + "]"), (long)expected[i], (long)actual[i]);
        }
    }
}

