/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.input.InfiniteCircularInputStream;
import org.junit.Assert;
import org.junit.Test;

public class InfiniteCircularInputStreamTest {
    @Test
    public void should_cycle_bytes() throws IOException {
        byte[] input = new byte[]{1, 2};
        byte[] expected = new byte[]{1, 2, 1, 2, 1};
        this.assertStreamOutput(input, expected);
    }

    @Test
    public void should_handle_whole_range_of_bytes() throws IOException {
        int size = 256;
        byte[] contentToCycle = new byte[256];
        int value = -128;
        for (int i = 0; i < contentToCycle.length; ++i) {
            int n = value;
            value = (byte)(value + 1);
            contentToCycle[i] = n;
        }
        byte[] expectedOutput = Arrays.copyOf(contentToCycle, 256);
        this.assertStreamOutput(contentToCycle, expectedOutput);
    }

    private void assertStreamOutput(byte[] toCycle, byte[] expected) throws IOException {
        byte[] actual = new byte[expected.length];
        try (InfiniteCircularInputStream infStream = new InfiniteCircularInputStream(toCycle);){
            int actualReadBytes = infStream.read(actual);
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
            Assert.assertEquals((long)expected.length, (long)actualReadBytes);
        }
    }
}

