/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.NullReader;
import org.junit.Assert;
import org.junit.Test;

public class NullReaderTest {
    @Test
    public void testRead() throws Exception {
        int size = 5;
        TestNullReader reader = new TestNullReader(5);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((String)("Check Value [" + i + "]"), (long)i, (long)reader.read());
        }
        Assert.assertEquals((String)"End of File", (long)-1L, (long)reader.read());
        try {
            int result = reader.read();
            Assert.fail((String)("Should have thrown an IOException, value=[" + result + "]"));
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        reader.close();
        Assert.assertEquals((String)"Available after close", (long)0L, (long)reader.getPosition());
    }

    @Test
    public void testReadCharArray() throws Exception {
        char[] chars = new char[10];
        TestNullReader reader = new TestNullReader(15);
        int count1 = ((Reader)((Object)reader)).read(chars);
        Assert.assertEquals((String)"Read 1", (long)chars.length, (long)count1);
        for (int i = 0; i < count1; ++i) {
            Assert.assertEquals((String)"Check Chars 1", (long)i, (long)chars[i]);
        }
        int count2 = ((Reader)((Object)reader)).read(chars);
        Assert.assertEquals((String)"Read 2", (long)5L, (long)count2);
        for (int i = 0; i < count2; ++i) {
            Assert.assertEquals((String)"Check Chars 2", (long)(count1 + i), (long)chars[i]);
        }
        int count3 = ((Reader)((Object)reader)).read(chars);
        Assert.assertEquals((String)"Read 3 (EOF)", (long)-1L, (long)count3);
        try {
            int count4 = ((Reader)((Object)reader)).read(chars);
            Assert.fail((String)("Should have thrown an IOException, value=[" + count4 + "]"));
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((Reader)((Object)reader)).read(chars, 2, 4);
        Assert.assertEquals((String)"Read 5", (long)4L, (long)count5);
        for (int i = 2; i < 4; ++i) {
            Assert.assertEquals((String)"Check Chars 3", (long)i, (long)chars[i]);
        }
    }

    @Test
    public void testEOFException() throws Exception {
        TestNullReader reader = new TestNullReader(2, false, true);
        Assert.assertEquals((String)"Read 1", (long)0L, (long)((Reader)((Object)reader)).read());
        Assert.assertEquals((String)"Read 2", (long)1L, (long)((Reader)((Object)reader)).read());
        try {
            int result = ((Reader)((Object)reader)).read();
            Assert.fail((String)("Should have thrown an EOFException, value=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullReader reader = new TestNullReader(100, true, false);
        Assert.assertTrue((String)"Mark Should be Supported", (boolean)((Reader)((Object)reader)).markSupported());
        try {
            ((Reader)((Object)reader)).reset();
            Assert.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"No Mark IOException message", (Object)"No position has been marked", (Object)e.getMessage());
        }
        while (position < 3) {
            Assert.assertEquals((String)("Read Before Mark [" + position + "]"), (long)position, (long)((Reader)((Object)reader)).read());
            ++position;
        }
        ((Reader)((Object)reader)).mark(10);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((String)("Read After Mark [" + i + "]"), (long)(position + i), (long)((Reader)((Object)reader)).read());
        }
        ((Reader)((Object)reader)).reset();
        for (i = 0; i < 11; ++i) {
            Assert.assertEquals((String)("Read After Reset [" + i + "]"), (long)(position + i), (long)((Reader)((Object)reader)).read());
        }
        try {
            ((Reader)((Object)reader)).reset();
            Assert.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Read limit IOException message", (Object)("Marked position [" + position + "] is no longer valid - passed the read limit [" + 10 + "]"), (Object)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testMarkNotSupported() throws Exception {
        TestNullReader reader = new TestNullReader(100, false, true);
        Assert.assertFalse((String)"Mark Should NOT be Supported", (boolean)((Reader)((Object)reader)).markSupported());
        try {
            ((Reader)((Object)reader)).mark(5);
            Assert.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"mark() error message", (Object)"Mark not supported", (Object)e.getMessage());
        }
        try {
            ((Reader)((Object)reader)).reset();
            Assert.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((String)"reset() error message", (Object)"Mark not supported", (Object)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testSkip() throws Exception {
        TestNullReader reader = new TestNullReader(10, true, false);
        Assert.assertEquals((String)"Read 1", (long)0L, (long)((Reader)((Object)reader)).read());
        Assert.assertEquals((String)"Read 2", (long)1L, (long)((Reader)((Object)reader)).read());
        Assert.assertEquals((String)"Skip 1", (long)5L, (long)((Reader)((Object)reader)).skip(5L));
        Assert.assertEquals((String)"Read 3", (long)7L, (long)((Reader)((Object)reader)).read());
        Assert.assertEquals((String)"Skip 2", (long)2L, (long)((Reader)((Object)reader)).skip(5L));
        Assert.assertEquals((String)"Skip 3 (EOF)", (long)-1L, (long)((Reader)((Object)reader)).skip(5L));
        try {
            ((Reader)((Object)reader)).skip(5L);
            Assert.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            Assert.assertEquals((String)"Skip after EOF IOException message", (Object)"Skip after end of file", (Object)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
    }

    private static final class TestNullReader
    extends NullReader {
        public TestNullReader(int size) {
            super((long)size);
        }

        public TestNullReader(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processChar() {
            return (int)this.getPosition() - 1;
        }

        protected void processChars(char[] chars, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                chars[i] = (char)(startPos + i);
            }
        }
    }
}

