/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class ByteArrayOutputStreamTestCase {
    private static final byte[] DATA = new byte[64];

    private int writeData(ByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int count) {
        if (count > DATA.length) {
            throw new IllegalArgumentException("Requesting too many bytes");
        }
        if (count == 0) {
            baout.write(100);
            ref.write(100);
            return 1;
        }
        baout.write(DATA, 0, count);
        ref.write(DATA, 0, count);
        return count;
    }

    private int writeData(ByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int[] instructions) {
        int written = 0;
        for (int instruction : instructions) {
            written += this.writeData(baout, ref, instruction);
        }
        return written;
    }

    private static boolean byteCmp(byte[] src, byte[] cmp) {
        for (int i = 0; i < cmp.length; ++i) {
            if (src[i] == cmp[i]) continue;
            return false;
        }
        return true;
    }

    private void checkByteArrays(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            Assert.fail((String)"Resulting byte arrays are not equally long");
        }
        if (!ByteArrayOutputStreamTestCase.byteCmp(expected, actual)) {
            Assert.fail((String)"Resulting byte arrays are not equal");
        }
    }

    private void checkStreams(ByteArrayOutputStream actual, java.io.ByteArrayOutputStream expected) {
        Assert.assertEquals((String)"Sizes are not equal", (long)expected.size(), (long)actual.size());
        byte[] buf = actual.toByteArray();
        byte[] refbuf = expected.toByteArray();
        this.checkByteArrays(buf, refbuf);
    }

    @Test
    public void testToInputStream() throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();
        this.writeData(baout, ref, 32);
        for (int i = 0; i < 128; ++i) {
            this.writeData(baout, ref, 64);
        }
        InputStream in = baout.toInputStream();
        byte[] refData = ref.toByteArray();
        this.writeData(baout, ref, new int[]{2, 4, 8, 16});
        byte[] baoutData = IOUtils.toByteArray((InputStream)in);
        Assert.assertEquals((long)8224L, (long)baoutData.length);
        this.checkByteArrays(refData, baoutData);
        baoutData = IOUtils.toByteArray((InputStream)baout.toInputStream());
        refData = ref.toByteArray();
        Assert.assertEquals((long)8254L, (long)baoutData.length);
        this.checkByteArrays(refData, baoutData);
        baout.close();
        in.close();
    }

    @Test
    public void testToInputStreamWithReset() throws IOException {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();
        this.writeData(baout, ref, 32);
        for (int i = 0; i < 128; ++i) {
            this.writeData(baout, ref, 64);
        }
        InputStream in = baout.toInputStream();
        byte[] refData = ref.toByteArray();
        baout.reset();
        ref.reset();
        this.writeData(baout, ref, new int[]{2, 4, 8, 16});
        byte[] baoutData = IOUtils.toByteArray((InputStream)in);
        Assert.assertEquals((long)8224L, (long)baoutData.length);
        this.checkByteArrays(refData, baoutData);
        baoutData = IOUtils.toByteArray((InputStream)baout.toInputStream());
        refData = ref.toByteArray();
        Assert.assertEquals((long)30L, (long)baoutData.length);
        this.checkByteArrays(refData, baoutData);
        baout.close();
        in.close();
    }

    @Test
    public void testStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream(32);
        java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();
        int written = this.writeData(baout, ref, new int[]{4, 10, 22});
        Assert.assertEquals((long)36L, (long)written);
        this.checkStreams(baout, ref);
        written = this.writeData(baout, ref, new int[]{20, 12});
        Assert.assertEquals((long)32L, (long)written);
        this.checkStreams(baout, ref);
        baout.reset();
        ref.reset();
        written = this.writeData(baout, ref, new int[]{5, 47, 33, 60, 1, 0, 8});
        Assert.assertEquals((long)155L, (long)written);
        this.checkStreams(baout, ref);
        baout.reset();
        written = baout.write((InputStream)new ByteArrayInputStream(ref.toByteArray()));
        Assert.assertEquals((long)155L, (long)written);
        this.checkStreams(baout, ref);
        ByteArrayOutputStream baout1 = new ByteArrayOutputStream(32);
        ref.writeTo((OutputStream)baout1);
        java.io.ByteArrayOutputStream ref1 = new java.io.ByteArrayOutputStream();
        baout.writeTo((OutputStream)ref1);
        this.checkStreams(baout1, ref1);
        String baoutString = baout.toString("ASCII");
        String refString = ref.toString("ASCII");
        Assert.assertEquals((String)"ASCII decoded String must be equal", (Object)refString, (Object)baoutString);
        ByteArrayOutputStream baos1 = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        Assert.assertSame((Object)baos1.toByteArray(), (Object)baos2.toByteArray());
        baos1.close();
        baos2.close();
        baout.close();
        baout1.close();
    }

    static {
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            ByteArrayOutputStreamTestCase.DATA[i] = i;
        }
    }
}

