/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.ProxyWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.Assert;
import org.junit.Test;

public class ProxyWriterTest {
    @Test
    public void appendCharSequence() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.append((CharSequence)"ABC");
        Assert.assertEquals((Object)"ABC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void appendCharSequence_with_offset() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.append((CharSequence)"ABC", 1, 3);
        proxy.flush();
        Assert.assertEquals((Object)"BC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void appendChar() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.append('c');
        Assert.assertEquals((Object)"c", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void writeString() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.write("ABC");
        Assert.assertEquals((Object)"ABC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void writeStringPartial() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.write("ABC", 1, 2);
        Assert.assertEquals((Object)"BC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void writeCharArray() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.write(new char[]{'A', 'B', 'C'});
        Assert.assertEquals((Object)"ABC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void writeInt() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.write(65);
        Assert.assertEquals((Object)"A", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void writeCharArrayPartial() throws Exception {
        StringBuilderWriter writer = new StringBuilderWriter();
        ProxyWriter proxy = new ProxyWriter((Writer)writer);
        proxy.write(new char[]{'A', 'B', 'C'}, 1, 2);
        Assert.assertEquals((Object)"BC", (Object)writer.toString());
        proxy.close();
    }

    @Test
    public void nullString() throws Exception {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        proxy.write((String)null);
        proxy.write((String)null, 0, 0);
        proxy.close();
    }

    @Test
    public void nullCharArray() throws Exception {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        proxy.write((char[])null);
        proxy.write((char[])null, 0, 0);
        proxy.close();
    }

    @Test
    public void nullCharSequencec() throws Exception {
        ProxyWriter proxy = new ProxyWriter((Writer)new NullWriter());
        proxy.append(null);
        proxy.close();
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_append_char() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(int c) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.append('c');
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_append_charSequence() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public Writer append(CharSequence csq) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.append((CharSequence)"ABCE");
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_append_charSequence_offset() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public Writer append(CharSequence csq, int start, int end) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.append((CharSequence)"ABCE", 1, 2);
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_write_int() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(int c) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.write(97);
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_write_char_array() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(char[] cbuf) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.write("ABCE".toCharArray());
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_write_offset_char_array() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.write("ABCE".toCharArray(), 2, 3);
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_write_string() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(String str) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.write("ABCE");
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_write_string_offset() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void write(String str, int off, int len) throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.write("ABCE", 1, 3);
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_flush() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void flush() throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        try (ProxyWriter proxy = new ProxyWriter((Writer)osw);){
            proxy.flush();
        }
    }

    @Test(expected=UnsupportedEncodingException.class)
    public void exceptions_in_close() throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new ByteArrayOutputStream()){

            @Override
            public void close() throws IOException {
                throw new UnsupportedEncodingException("Bah");
            }
        };
        ProxyWriter proxy = new ProxyWriter((Writer)osw);
        proxy.close();
    }
}

