/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import org.apache.commons.io.output.StringBuilderWriter;
import org.junit.Assert;
import org.junit.Test;

public class StringBuilderWriterTest {
    private static final char[] FOOBAR_CHARS = new char[]{'F', 'o', 'o', 'B', 'a', 'r'};

    @Test
    public void testAppendConstructCapacity() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(100);
        writer.append("Foo");
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testAppendConstructStringBuilder() {
        StringBuilder builder = new StringBuilder("Foo");
        StringBuilderWriter writer = new StringBuilderWriter(builder);
        writer.append((CharSequence)"Bar");
        Assert.assertEquals((Object)"FooBar", (Object)writer.toString());
        Assert.assertSame((Object)builder, (Object)writer.getBuilder());
        writer.close();
    }

    @Test
    public void testAppendConstructNull() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter(null);
        writer.append("Foo");
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testAppendChar() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append('F').append('o').append('o');
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testAppendCharSequence() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append("Foo").append("Bar");
        Assert.assertEquals((Object)"FooBar", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testAppendCharSequencePortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.append("FooBar", 3, 6).append(new StringBuffer("FooBar"), 0, 3);
        Assert.assertEquals((Object)"BarFoo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testClose() {
        StringBuilderWriter writer = new StringBuilderWriter();
        try {
            writer.append("Foo");
            writer.close();
            writer.append("Bar");
        }
        catch (Throwable t) {
            Assert.fail((String)("Threw: " + t));
        }
        Assert.assertEquals((Object)"FooBar", (Object)writer.toString());
    }

    @Test
    public void testWriteChar() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(70);
        Assert.assertEquals((Object)"F", (Object)writer.toString());
        writer.write(111);
        Assert.assertEquals((Object)"Fo", (Object)writer.toString());
        writer.write(111);
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testWriteCharArray() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(new char[]{'F', 'o', 'o'});
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.write(new char[]{'B', 'a', 'r'});
        Assert.assertEquals((Object)"FooBar", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testWriteCharArrayPortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write(FOOBAR_CHARS, 3, 3);
        Assert.assertEquals((Object)"Bar", (Object)writer.toString());
        writer.write(FOOBAR_CHARS, 0, 3);
        Assert.assertEquals((Object)"BarFoo", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testWriteString() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write("Foo");
        Assert.assertEquals((Object)"Foo", (Object)writer.toString());
        writer.write("Bar");
        Assert.assertEquals((Object)"FooBar", (Object)writer.toString());
        writer.close();
    }

    @Test
    public void testWriteStringPortion() throws IOException {
        StringBuilderWriter writer = new StringBuilderWriter();
        writer.write("FooBar", 3, 3);
        Assert.assertEquals((Object)"Bar", (Object)writer.toString());
        writer.write("FooBar", 0, 3);
        Assert.assertEquals((Object)"BarFoo", (Object)writer.toString());
        writer.close();
    }
}

