/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.EndianUtils;
import org.junit.Assert;
import org.junit.Test;

public class EndianUtilsTest {
    @Test
    public void testCtor() {
        new EndianUtils();
    }

    @Test
    public void testEOFException() throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(new byte[0]);
        try {
            EndianUtils.readSwappedDouble((InputStream)input);
            Assert.fail((String)"Expected EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Test
    public void testSwapShort() {
        Assert.assertEquals((long)0L, (long)EndianUtils.swapShort((short)0));
        Assert.assertEquals((long)513L, (long)EndianUtils.swapShort((short)258));
        Assert.assertEquals((long)-1L, (long)EndianUtils.swapShort((short)-1));
        Assert.assertEquals((long)258L, (long)EndianUtils.swapShort((short)513));
    }

    @Test
    public void testSwapInteger() {
        Assert.assertEquals((long)0L, (long)EndianUtils.swapInteger((int)0));
        Assert.assertEquals((long)67305985L, (long)EndianUtils.swapInteger((int)16909060));
        Assert.assertEquals((long)0x1000000L, (long)EndianUtils.swapInteger((int)1));
        Assert.assertEquals((long)1L, (long)EndianUtils.swapInteger((int)0x1000000));
        Assert.assertEquals((long)0x11111111L, (long)EndianUtils.swapInteger((int)0x11111111));
        Assert.assertEquals((long)-1412567280L, (long)EndianUtils.swapInteger((int)284151211));
        Assert.assertEquals((long)171L, (long)EndianUtils.swapInteger((int)-1426063360));
    }

    @Test
    public void testSwapLong() {
        Assert.assertEquals((long)0L, (long)EndianUtils.swapLong((long)0L));
        Assert.assertEquals((long)578437695752307201L, (long)EndianUtils.swapLong((long)72623859790382856L));
        Assert.assertEquals((long)-1L, (long)EndianUtils.swapLong((long)-1L));
        Assert.assertEquals((long)171L, (long)EndianUtils.swapLong((long)-6124895493223874560L));
    }

    @Test
    public void testSwapFloat() {
        Assert.assertEquals((double)0.0, (double)EndianUtils.swapFloat((float)0.0f), (double)0.0);
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = Float.intBitsToFloat(67305985);
        Assert.assertEquals((double)f2, (double)EndianUtils.swapFloat((float)f1), (double)0.0);
    }

    @Test
    public void testSwapDouble() {
        Assert.assertEquals((double)0.0, (double)EndianUtils.swapDouble((double)0.0), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = Double.longBitsToDouble(578437695752307201L);
        Assert.assertEquals((double)d2, (double)EndianUtils.swapDouble((double)d1), (double)0.0);
    }

    @Test
    public void testSymmetry() {
        Assert.assertEquals((long)258L, (long)EndianUtils.swapShort((short)EndianUtils.swapShort((short)258)));
        Assert.assertEquals((long)16909060L, (long)EndianUtils.swapInteger((int)EndianUtils.swapInteger((int)16909060)));
        Assert.assertEquals((long)72623859790382856L, (long)EndianUtils.swapLong((long)EndianUtils.swapLong((long)72623859790382856L)));
        float f1 = Float.intBitsToFloat(16909060);
        Assert.assertEquals((double)f1, (double)EndianUtils.swapFloat((float)EndianUtils.swapFloat((float)f1)), (double)0.0);
        double d1 = Double.longBitsToDouble(72623859790382856L);
        Assert.assertEquals((double)d1, (double)EndianUtils.swapDouble((double)EndianUtils.swapDouble((double)d1)), (double)0.0);
    }

    @Test
    public void testReadSwappedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assert.assertEquals((long)258L, (long)EndianUtils.readSwappedShort((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)258L, (long)EndianUtils.readSwappedShort((InputStream)input));
    }

    @Test
    public void testWriteSwappedShort() throws IOException {
        byte[] bytes = new byte[2];
        EndianUtils.writeSwappedShort((byte[])bytes, (int)0, (short)258);
        Assert.assertEquals((long)2L, (long)bytes[0]);
        Assert.assertEquals((long)1L, (long)bytes[1]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2);
        EndianUtils.writeSwappedShort((OutputStream)baos, (short)258);
        bytes = baos.toByteArray();
        Assert.assertEquals((long)2L, (long)bytes[0]);
        Assert.assertEquals((long)1L, (long)bytes[1]);
    }

    @Test
    public void testReadSwappedUnsignedShort() throws IOException {
        byte[] bytes = new byte[]{2, 1};
        Assert.assertEquals((long)258L, (long)EndianUtils.readSwappedUnsignedShort((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)258L, (long)EndianUtils.readSwappedUnsignedShort((InputStream)input));
    }

    @Test
    public void testReadSwappedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assert.assertEquals((long)16909060L, (long)EndianUtils.readSwappedInteger((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)16909060L, (long)EndianUtils.readSwappedInteger((InputStream)input));
    }

    @Test
    public void testWriteSwappedInteger() throws IOException {
        byte[] bytes = new byte[4];
        EndianUtils.writeSwappedInteger((byte[])bytes, (int)0, (int)16909060);
        Assert.assertEquals((long)4L, (long)bytes[0]);
        Assert.assertEquals((long)3L, (long)bytes[1]);
        Assert.assertEquals((long)2L, (long)bytes[2]);
        Assert.assertEquals((long)1L, (long)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedInteger((OutputStream)baos, (int)16909060);
        bytes = baos.toByteArray();
        Assert.assertEquals((long)4L, (long)bytes[0]);
        Assert.assertEquals((long)3L, (long)bytes[1]);
        Assert.assertEquals((long)2L, (long)bytes[2]);
        Assert.assertEquals((long)1L, (long)bytes[3]);
    }

    @Test
    public void testReadSwappedUnsignedInteger() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        Assert.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)16909060L, (long)EndianUtils.readSwappedUnsignedInteger((InputStream)input));
    }

    @Test
    public void testReadSwappedLong() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        Assert.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong((byte[])bytes, (int)0));
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((long)72623859790382856L, (long)EndianUtils.readSwappedLong((InputStream)input));
    }

    @Test
    public void testWriteSwappedLong() throws IOException {
        byte[] bytes = new byte[8];
        EndianUtils.writeSwappedLong((byte[])bytes, (int)0, (long)72623859790382856L);
        Assert.assertEquals((long)8L, (long)bytes[0]);
        Assert.assertEquals((long)7L, (long)bytes[1]);
        Assert.assertEquals((long)6L, (long)bytes[2]);
        Assert.assertEquals((long)5L, (long)bytes[3]);
        Assert.assertEquals((long)4L, (long)bytes[4]);
        Assert.assertEquals((long)3L, (long)bytes[5]);
        Assert.assertEquals((long)2L, (long)bytes[6]);
        Assert.assertEquals((long)1L, (long)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedLong((OutputStream)baos, (long)72623859790382856L);
        bytes = baos.toByteArray();
        Assert.assertEquals((long)8L, (long)bytes[0]);
        Assert.assertEquals((long)7L, (long)bytes[1]);
        Assert.assertEquals((long)6L, (long)bytes[2]);
        Assert.assertEquals((long)5L, (long)bytes[3]);
        Assert.assertEquals((long)4L, (long)bytes[4]);
        Assert.assertEquals((long)3L, (long)bytes[5]);
        Assert.assertEquals((long)2L, (long)bytes[6]);
        Assert.assertEquals((long)1L, (long)bytes[7]);
    }

    @Test
    public void testReadSwappedFloat() throws IOException {
        byte[] bytes = new byte[]{4, 3, 2, 1};
        float f1 = Float.intBitsToFloat(16909060);
        float f2 = EndianUtils.readSwappedFloat((byte[])bytes, (int)0);
        Assert.assertEquals((double)f1, (double)f2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((double)f1, (double)EndianUtils.readSwappedFloat((InputStream)input), (double)0.0);
    }

    @Test
    public void testWriteSwappedFloat() throws IOException {
        byte[] bytes = new byte[4];
        float f1 = Float.intBitsToFloat(16909060);
        EndianUtils.writeSwappedFloat((byte[])bytes, (int)0, (float)f1);
        Assert.assertEquals((long)4L, (long)bytes[0]);
        Assert.assertEquals((long)3L, (long)bytes[1]);
        Assert.assertEquals((long)2L, (long)bytes[2]);
        Assert.assertEquals((long)1L, (long)bytes[3]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        EndianUtils.writeSwappedFloat((OutputStream)baos, (float)f1);
        bytes = baos.toByteArray();
        Assert.assertEquals((long)4L, (long)bytes[0]);
        Assert.assertEquals((long)3L, (long)bytes[1]);
        Assert.assertEquals((long)2L, (long)bytes[2]);
        Assert.assertEquals((long)1L, (long)bytes[3]);
    }

    @Test
    public void testReadSwappedDouble() throws IOException {
        byte[] bytes = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        double d1 = Double.longBitsToDouble(72623859790382856L);
        double d2 = EndianUtils.readSwappedDouble((byte[])bytes, (int)0);
        Assert.assertEquals((double)d1, (double)d2, (double)0.0);
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        Assert.assertEquals((double)d1, (double)EndianUtils.readSwappedDouble((InputStream)input), (double)0.0);
    }

    @Test
    public void testWriteSwappedDouble() throws IOException {
        byte[] bytes = new byte[8];
        double d1 = Double.longBitsToDouble(72623859790382856L);
        EndianUtils.writeSwappedDouble((byte[])bytes, (int)0, (double)d1);
        Assert.assertEquals((long)8L, (long)bytes[0]);
        Assert.assertEquals((long)7L, (long)bytes[1]);
        Assert.assertEquals((long)6L, (long)bytes[2]);
        Assert.assertEquals((long)5L, (long)bytes[3]);
        Assert.assertEquals((long)4L, (long)bytes[4]);
        Assert.assertEquals((long)3L, (long)bytes[5]);
        Assert.assertEquals((long)2L, (long)bytes[6]);
        Assert.assertEquals((long)1L, (long)bytes[7]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
        EndianUtils.writeSwappedDouble((OutputStream)baos, (double)d1);
        bytes = baos.toByteArray();
        Assert.assertEquals((long)8L, (long)bytes[0]);
        Assert.assertEquals((long)7L, (long)bytes[1]);
        Assert.assertEquals((long)6L, (long)bytes[2]);
        Assert.assertEquals((long)5L, (long)bytes[3]);
        Assert.assertEquals((long)4L, (long)bytes[4]);
        Assert.assertEquals((long)3L, (long)bytes[5]);
        Assert.assertEquals((long)2L, (long)bytes[6]);
        Assert.assertEquals((long)1L, (long)bytes[7]);
    }

    @Test
    public void testSymmetryOfLong() {
        double[] tests;
        for (double test : tests = new double[]{34.345, -345.5645, 545.12, 10.043, 7.123456789123}) {
            byte[] buffer = new byte[8];
            long ln1 = Double.doubleToLongBits(test);
            EndianUtils.writeSwappedLong((byte[])buffer, (int)0, (long)ln1);
            long ln2 = EndianUtils.readSwappedLong((byte[])buffer, (int)0);
            Assert.assertEquals((long)ln1, (long)ln2);
            buffer = new byte[8];
            EndianUtils.writeSwappedDouble((byte[])buffer, (int)0, (double)test);
            double val = EndianUtils.readSwappedDouble((byte[])buffer, (int)0);
            Assert.assertEquals((double)test, (double)val, (double)0.0);
        }
    }

    @Test
    public void testUnsignedOverrun() throws Exception {
        byte[] target = new byte[]{0, 0, 0, -128};
        long expected = 0x80000000L;
        long actual = EndianUtils.readSwappedUnsignedInteger((byte[])target, (int)0);
        Assert.assertEquals((String)"readSwappedUnsignedInteger(byte[], int) was incorrect", (long)0x80000000L, (long)actual);
        ByteArrayInputStream in = new ByteArrayInputStream(target);
        actual = EndianUtils.readSwappedUnsignedInteger((InputStream)in);
        Assert.assertEquals((String)"readSwappedUnsignedInteger(InputStream) was incorrect", (long)0x80000000L, (long)actual);
    }
}

