/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.util.Comparator;
import org.apache.commons.io.comparator.AbstractFileComparator;
import org.apache.commons.io.comparator.ComparatorAbstractTestCase;
import org.apache.commons.io.comparator.ExtensionFileComparator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExtensionFileComparatorTest
extends ComparatorAbstractTestCase {
    @Before
    public void setUp() throws Exception {
        this.comparator = (AbstractFileComparator)ExtensionFileComparator.EXTENSION_COMPARATOR;
        this.reverse = ExtensionFileComparator.EXTENSION_REVERSE;
        this.equalFile1 = new File("abc.foo");
        this.equalFile2 = new File("def.foo");
        this.lessFile = new File("abc.abc");
        this.moreFile = new File("abc.xyz");
    }

    @Test
    public void testCaseSensitivity() {
        File file3 = new File("abc.FOO");
        ExtensionFileComparator sensitive = new ExtensionFileComparator(null);
        Assert.assertTrue((String)"sensitive file1 & file2 = 0", (sensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"sensitive file1 & file3 > 0", (sensitive.compare(this.equalFile1, file3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"sensitive file1 & less  > 0", (sensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0);
        Comparator insensitive = ExtensionFileComparator.EXTENSION_INSENSITIVE_COMPARATOR;
        Assert.assertTrue((String)"insensitive file1 & file2 = 0", (insensitive.compare(this.equalFile1, this.equalFile2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file1 & file3 = 0", (insensitive.compare(this.equalFile1, file3) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file1 & file4 > 0", (insensitive.compare(this.equalFile1, this.lessFile) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"insensitive file3 & less  > 0", (insensitive.compare(file3, this.lessFile) > 0 ? 1 : 0) != 0);
    }
}

