/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import org.apache.commons.io.serialization.WildcardClassNameMatcher;
import org.junit.Assert;
import org.junit.Test;

public class WildcardClassNameMatcherTest {
    @Test
    public void noPattern() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org.foo");
        Assert.assertTrue((boolean)ca.matches("org.foo"));
        Assert.assertFalse((boolean)ca.matches("org.foo.and.more"));
        Assert.assertFalse((boolean)ca.matches("org_foo"));
    }

    @Test
    public void star() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org*");
        Assert.assertTrue((boolean)ca.matches("org.foo.should.match"));
        Assert.assertFalse((boolean)ca.matches("bar.should.not.match"));
    }

    @Test
    public void starAndQuestionMark() {
        WildcardClassNameMatcher ca = new WildcardClassNameMatcher("org?apache?something*");
        Assert.assertTrue((boolean)ca.matches("org.apache_something.more"));
        Assert.assertFalse((boolean)ca.matches("org..apache_something.more"));
    }
}

