/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.junit.Assert;
import org.junit.Test;

public class ArchiveUtilsTest
extends AbstractTestCase {
    private static final int bytesToTest = 50;
    private static final byte[] byteTest = new byte[50];

    @Test
    public void testCompareBA() {
        byte[] buffer1 = new byte[]{1, 2, 3};
        byte[] buffer2 = new byte[]{1, 2, 3, 0};
        byte[] buffer3 = new byte[]{1, 2, 3};
        Assert.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2, (boolean)true));
        Assert.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2, (boolean)false));
        Assert.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer2));
        Assert.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1, (boolean)true));
        Assert.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1, (boolean)false));
        Assert.assertFalse((boolean)ArchiveUtils.isEqual((byte[])buffer2, (byte[])buffer1));
        Assert.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer1, (byte[])buffer3));
        Assert.assertTrue((boolean)ArchiveUtils.isEqual((byte[])buffer3, (byte[])buffer1));
    }

    @Test
    public void testCompareAscii() {
        byte[] buffer1 = new byte[]{97, 98, 99};
        byte[] buffer2 = new byte[]{100, 101, 102, 0};
        Assert.assertTrue((boolean)ArchiveUtils.matchAsciiBuffer((String)"abc", (byte[])buffer1));
        Assert.assertFalse((boolean)ArchiveUtils.matchAsciiBuffer((String)"abc\u0000", (byte[])buffer1));
        Assert.assertTrue((boolean)ArchiveUtils.matchAsciiBuffer((String)"def\u0000", (byte[])buffer2));
        Assert.assertFalse((boolean)ArchiveUtils.matchAsciiBuffer((String)"def", (byte[])buffer2));
    }

    @Test
    public void testAsciiConversions() {
        this.asciiToByteAndBackOK("");
        this.asciiToByteAndBackOK("abcd");
        this.asciiToByteAndBackFail("\u8025");
    }

    @Test
    public void sanitizeShortensString() {
        String input = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        String expected = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901...";
        Assert.assertEquals((Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901...", (Object)ArchiveUtils.sanitize((String)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"));
    }

    @Test
    public void sanitizeLeavesShortStringsAlone() {
        String input = "012345678901234567890123456789012345678901234567890123456789";
        Assert.assertEquals((Object)"012345678901234567890123456789012345678901234567890123456789", (Object)ArchiveUtils.sanitize((String)"012345678901234567890123456789012345678901234567890123456789"));
    }

    @Test
    public void sanitizeRemovesUnprintableCharacters() {
        String input = "\b12345678901234567890123456789012345678901234567890123456789";
        String expected = "?12345678901234567890123456789012345678901234567890123456789";
        Assert.assertEquals((Object)"?12345678901234567890123456789012345678901234567890123456789", (Object)ArchiveUtils.sanitize((String)"\b12345678901234567890123456789012345678901234567890123456789"));
    }

    @Test
    public void testIsEqualWithNullWithPositive() {
        byte[] byteArray = new byte[8];
        byteArray[1] = -77;
        Assert.assertFalse((boolean)ArchiveUtils.isEqualWithNull((byte[])byteArray, (int)0, (int)0, (byte[])byteArray, (int)0, (int)80));
    }

    @Test
    public void testToAsciiBytes() {
        byte[] byteArray = ArchiveUtils.toAsciiBytes((String)"SOCKET");
        Assert.assertArrayEquals((byte[])new byte[]{83, 79, 67, 75, 69, 84}, (byte[])byteArray);
        Assert.assertFalse((boolean)ArchiveUtils.isEqualWithNull((byte[])byteArray, (int)0, (int)46, (byte[])byteArray, (int)63, (int)0));
    }

    @Test
    public void testToStringWithNonNull() {
        SevenZArchiveEntry sevenZArchiveEntry = new SevenZArchiveEntry();
        String string = ArchiveUtils.toString((ArchiveEntry)sevenZArchiveEntry);
        Assert.assertEquals((Object)"-       0 null", (Object)string);
    }

    @Test
    public void testIsEqual() {
        Assert.assertTrue((boolean)ArchiveUtils.isEqual((byte[])null, (int)0, (int)0, (byte[])null, (int)0, (int)0));
    }

    @Test(expected=StringIndexOutOfBoundsException.class)
    public void testToAsciiStringThrowsStringIndexOutOfBoundsException() {
        byte[] byteArray = new byte[3];
        ArchiveUtils.toAsciiString((byte[])byteArray, (int)940, (int)2730);
    }

    private void asciiToByteAndBackOK(String inputString) {
        Assert.assertEquals((Object)inputString, (Object)ArchiveUtils.toAsciiString((byte[])ArchiveUtils.toAsciiBytes((String)inputString)));
    }

    private void asciiToByteAndBackFail(String inputString) {
        Assert.assertFalse((boolean)inputString.equals(ArchiveUtils.toAsciiString((byte[])ArchiveUtils.toAsciiBytes((String)inputString))));
    }

    static {
        for (int i = 0; i < byteTest.length; i += 2) {
            ArchiveUtilsTest.byteTest[i] = (byte)i;
            ArchiveUtilsTest.byteTest[i + 1] = (byte)(-i);
        }
    }
}

