/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.examples;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SevenZArchiverTest
extends AbstractTestCase {
    private File target;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        File c = new File(this.dir, "a/b/c");
        c.mkdirs();
        try (OutputStream os = Files.newOutputStream(new File(this.dir, "a/b/d.txt").toPath(), new OpenOption[0]);){
            os.write("Hello, world 1".getBytes(StandardCharsets.UTF_8));
        }
        os = Files.newOutputStream(new File(this.dir, "a/b/c/e.txt").toPath(), new OpenOption[0]);
        var3_3 = null;
        try {
            os.write("Hello, world 2".getBytes(StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (os != null) {
                if (var3_3 != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    os.close();
                }
            }
        }
        this.target = new File(this.resultDir, "test.7z");
    }

    @Test
    public void fileVersion() throws IOException, ArchiveException {
        new Archiver().create("7z", this.target, this.dir);
        this.verifyContent();
    }

    @Test(expected=StreamingNotSupportedException.class)
    public void outputStreamVersion() throws IOException, ArchiveException {
        try (OutputStream os = Files.newOutputStream(this.target.toPath(), new OpenOption[0]);){
            new Archiver().create("7z", os, this.dir);
        }
    }

    @Test
    public void channelVersion() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create("7z", (SeekableByteChannel)c, this.dir);
        }
        this.verifyContent();
    }

    @Test(expected=ArchiveException.class)
    public void unknownFormat() throws IOException, ArchiveException {
        try (FileChannel c = FileChannel.open(this.target.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            new Archiver().create("unknown format", (SeekableByteChannel)c, this.dir);
        }
    }

    private void verifyContent() throws IOException, ArchiveException {
        try (SevenZFile z = new SevenZFile(this.target);){
            this.assertDir("a", (ArchiveEntry)z.getNextEntry());
            this.assertDir("a/b", (ArchiveEntry)z.getNextEntry());
            SevenZArchiveEntry n = z.getNextEntry();
            Assert.assertNotNull((Object)n);
            if (n.getName().endsWith("/")) {
                this.assertDir("a/b/c", (ArchiveEntry)n);
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)z.getNextEntry(), z);
            } else {
                this.assertHelloWorld("a/b/d.txt", "1", (ArchiveEntry)n, z);
                this.assertDir("a/b/c", (ArchiveEntry)z.getNextEntry());
                this.assertHelloWorld("a/b/c/e.txt", "2", (ArchiveEntry)z.getNextEntry(), z);
            }
        }
    }

    private void assertDir(String expectedName, ArchiveEntry entry) {
        Assert.assertNotNull((String)(expectedName + " does not exists"), (Object)entry);
        Assert.assertEquals((Object)(expectedName + "/"), (Object)entry.getName());
        Assert.assertTrue((String)(expectedName + " is not a directory"), (boolean)entry.isDirectory());
    }

    private void assertHelloWorld(String expectedName, String suffix, ArchiveEntry entry, SevenZFile z) throws IOException {
        Assert.assertNotNull((String)(expectedName + " does not exists"), (Object)entry);
        Assert.assertEquals((Object)expectedName, (Object)entry.getName());
        Assert.assertFalse((String)(expectedName + " is a directory"), (boolean)entry.isDirectory());
        byte[] expected = ("Hello, world " + suffix).getBytes(StandardCharsets.UTF_8);
        byte[] actual = new byte[expected.length];
        Assert.assertEquals((long)actual.length, (long)z.read(actual));
        Assert.assertEquals((long)-1L, (long)z.read());
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }
}

