/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.util.Arrays;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class SevenZArchiveEntryTest {
    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowIfNoLastModifiedDateIsSet() {
        new SevenZArchiveEntry().getLastModifiedDate();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowIfNoCreationDateIsSet() {
        new SevenZArchiveEntry().getCreationDate();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldThrowIfNoAccessDateIsSet() {
        new SevenZArchiveEntry().getAccessDate();
    }

    @Test
    public void noMethodsIsDifferentFromSomeMethods() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z2.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.COPY)));
        Assert.assertNotEquals((Object)z1, (Object)z2);
        Assert.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void oneMethodsIsDifferentFromTwoMethods() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.COPY)));
        z2.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
        Assert.assertNotEquals((Object)z1, (Object)z2);
        Assert.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void sameMethodsYieldEqualEntries() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
        z2.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
        Assert.assertEquals((Object)z1, (Object)z2);
        Assert.assertEquals((Object)z2, (Object)z1);
    }

    @Test
    public void methodOrderMattersInEquals() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        z1.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2), new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER)));
        z2.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
        Assert.assertNotEquals((Object)z1, (Object)z2);
        Assert.assertNotEquals((Object)z2, (Object)z1);
    }

    @Test
    public void methodConfigurationMattersInEquals() {
        SevenZArchiveEntry z1 = new SevenZArchiveEntry();
        SevenZArchiveEntry z2 = new SevenZArchiveEntry();
        SevenZArchiveEntry z3 = new SevenZArchiveEntry();
        z1.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)1)));
        z2.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)2)));
        z3.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)2)));
        Assert.assertNotEquals((Object)z1, (Object)z2);
        Assert.assertNotEquals((Object)z2, (Object)z1);
        Assert.assertEquals((Object)z3, (Object)z2);
        Assert.assertEquals((Object)z2, (Object)z3);
    }
}

