/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.NoSuchElementException;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;

public class ArrayIterator2Test<E>
extends AbstractIteratorTest<E> {
    protected int[] testArray = new int[]{2, 4, 6, 8};

    public ArrayIterator2Test(String testName) {
        super(testName);
    }

    @Override
    public ArrayIterator<E> makeEmptyIterator() {
        return new ArrayIterator((Object)new int[0]);
    }

    @Override
    public ArrayIterator<E> makeObject() {
        return new ArrayIterator((Object)this.testArray);
    }

    public ArrayIterator<E> makeArrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public ArrayIterator<E> makeArrayIterator(Object array, int index) {
        return new ArrayIterator(array, index);
    }

    public ArrayIterator<E> makeArrayIterator(Object array, int start, int end) {
        return new ArrayIterator(array, start, end);
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    public void testIterator() {
        ArrayIterator<E> iter = this.makeObject();
        for (int element : this.testArray) {
            Integer testValue = element;
            Number iterValue = (Number)iter.next();
            ArrayIterator2Test.assertEquals((String)"Iteration value is correct", (Object)testValue, (Object)iterValue);
        }
        ArrayIterator2Test.assertTrue((String)"Iterator should now be empty", (!iter.hasNext() ? 1 : 0) != 0);
        try {
            iter.next();
        }
        catch (Exception e) {
            ArrayIterator2Test.assertTrue((String)"NoSuchElementException must be thrown", (boolean)e.getClass().equals(new NoSuchElementException().getClass()));
        }
    }

    public void testIndexedArray() {
        ArrayIterator<E> iter = this.makeArrayIterator(this.testArray, 2);
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ArrayIterator2Test.assertEquals((String)"the count should be right using ArrayIterator(Object,2) ", (int)count, (int)(this.testArray.length - 2));
        iter = this.makeArrayIterator(this.testArray, 1, this.testArray.length - 1);
        count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        ArrayIterator2Test.assertEquals((String)("the count should be right using ArrayIterator(Object,1," + (this.testArray.length - 1) + ") "), (int)count, (int)(this.testArray.length - 2));
        try {
            iter = this.makeArrayIterator(this.testArray, -1);
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,-1) should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iter = this.makeArrayIterator(this.testArray, this.testArray.length + 1);
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,length+1) should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iter = this.makeArrayIterator(this.testArray, 0, -1);
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,0,-1) should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iter = this.makeArrayIterator(this.testArray, 0, this.testArray.length + 1);
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,0,length+1) should throw an ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            iter = this.makeArrayIterator(this.testArray, 1, 1);
        }
        catch (IllegalArgumentException iae) {
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,1,1) should NOT throw an IllegalArgumentException");
        }
        try {
            iter = this.makeArrayIterator(this.testArray, this.testArray.length - 1, this.testArray.length - 2);
            ArrayIterator2Test.fail((String)"new ArrayIterator(Object,length-2,length-1) should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

