/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.AbstractListIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableListIterator;

public class UnmodifiableListIteratorTest<E>
extends AbstractListIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};
    protected List<E> testList;

    public UnmodifiableListIteratorTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public ListIterator<E> makeEmptyIterator() {
        return UnmodifiableListIterator.umodifiableListIterator(Collections.emptyList().listIterator());
    }

    @Override
    public ListIterator<E> makeObject() {
        return UnmodifiableListIterator.umodifiableListIterator(this.testList.listIterator());
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Override
    public boolean supportsAdd() {
        return false;
    }

    @Override
    public boolean supportsSet() {
        return false;
    }

    public void testListIterator() {
        UnmodifiableListIteratorTest.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }

    public void testDecorateFactory() {
        ListIterator<E> it = this.makeObject();
        UnmodifiableListIteratorTest.assertSame((Object)it, (Object)UnmodifiableListIterator.umodifiableListIterator((ListIterator)it));
        it = this.testList.listIterator();
        UnmodifiableListIteratorTest.assertTrue((it != UnmodifiableListIterator.umodifiableListIterator(it) ? 1 : 0) != 0);
        try {
            UnmodifiableListIterator.umodifiableListIterator(null);
            UnmodifiableListIteratorTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

